/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import no.nordicsemi.android.mesh.utils.AddressType;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public final class MeshAddress {
    private static final byte[] VTAD = "vtad".getBytes(Charset.forName("US-ASCII"));
    public static final int UNASSIGNED_ADDRESS = 0;
    public static final int START_UNICAST_ADDRESS = 1;
    public static final int END_UNICAST_ADDRESS = Short.MAX_VALUE;
    public static final int START_GROUP_ADDRESS = 49152;
    public static final int END_GROUP_ADDRESS = 65279;
    public static final int ALL_PROXIES_ADDRESS = 65532;
    public static final int ALL_FRIENDS_ADDRESS = 65533;
    public static final int ALL_RELAYS_ADDRESS = 65534;
    public static final int ALL_NODES_ADDRESS = 65535;
    private static final byte B1_VIRTUAL_ADDRESS = -128;
    public static final int START_VIRTUAL_ADDRESS = 32768;
    public static final int END_VIRTUAL_ADDRESS = 49151;
    public static final int UUID_HASH_BIT_MASK = 16383;

    public static String formatAddress(int address, boolean add0x) {
        return add0x ? "0x" + String.format(Locale.US, "%04X", address) : String.format(Locale.US, "%04X", address);
    }

    public static boolean isAddressInRange(@NonNull byte[] address) {
        return address.length == 2 && MeshAddress.isAddressInRange((address[0] & 0xFF) << 8 | address[1] & 0xFF);
    }

    public static boolean isAddressInRange(int address) {
        return address == (address & 0xFFFF);
    }

    public static boolean isValidUnassignedAddress(@NonNull byte[] address) {
        if (!MeshAddress.isAddressInRange(address)) {
            return false;
        }
        return MeshAddress.isValidUnassignedAddress(MeshParserUtils.unsignedBytesToInt(address[0], address[1]));
    }

    public static boolean isValidUnassignedAddress(int address) {
        return MeshAddress.isAddressInRange(address) && address == 0;
    }

    public static boolean isValidUnicastAddress(@NonNull byte[] address) {
        if (!MeshAddress.isAddressInRange(address)) {
            return false;
        }
        return MeshAddress.isValidUnicastAddress(MeshParserUtils.unsignedBytesToInt(address[0], address[1]));
    }

    public static boolean isValidUnicastAddress(int address) {
        return MeshAddress.isAddressInRange(address) && address >= 1 && address <= Short.MAX_VALUE;
    }

    public static boolean isValidVirtualAddress(@NonNull byte[] address) {
        if (!MeshAddress.isAddressInRange(address)) {
            return false;
        }
        return MeshAddress.isValidVirtualAddress(MeshParserUtils.unsignedBytesToInt(address[0], address[1]));
    }

    public static boolean isValidVirtualAddress(int address) {
        if (MeshAddress.isAddressInRange(address)) {
            return address >= 32768 && address <= 49151;
        }
        return false;
    }

    public static boolean isValidGroupAddress(byte[] address) {
        if (!MeshAddress.isAddressInRange(address)) {
            return false;
        }
        return MeshAddress.isValidGroupAddress(MeshParserUtils.unsignedBytesToInt(address[0], address[1]));
    }

    public static boolean isValidGroupAddress(int address) {
        if (!MeshAddress.isAddressInRange(address)) {
            return false;
        }
        int b0 = address >> 8 & 0xFF;
        int b1 = address & 0xFF;
        boolean groupRange = b0 >= 192 && b0 <= 255;
        boolean rfu = b0 == 255 && b1 >= 0 && b1 <= 251;
        boolean allNodes = b0 == 255 && b1 == 255;
        return groupRange && !rfu && !allNodes;
    }

    public static boolean isValidFixedGroupAddress(int address) {
        if (!MeshAddress.isAddressInRange(address)) {
            return false;
        }
        int b0 = address >> 8 & 0xFF;
        int b1 = address & 0xFF;
        boolean rfu = b0 == 255 && b1 >= 0 && b1 <= 251;
        boolean allNodes = b0 == 255 && b1 > 251 && b1 <= 255;
        return !rfu && allNodes;
    }

    public static boolean isValidSubscriptionAddress(int address) {
        if (MeshAddress.isValidUnassignedAddress(address) || MeshAddress.isValidUnicastAddress(address) || MeshAddress.isValidVirtualAddress(address) || address == 65535) {
            throw new IllegalArgumentException("The value of the Address field shall not be an unassigned address, unicast address, all-nodes address or virtual address.");
        }
        int b0 = address >> 8 & 0xFF;
        int b1 = address & 0xFF;
        boolean groupRange = b0 >= 192;
        boolean rfu = b0 == 255 && b1 <= 251;
        boolean allNodes = b0 == 255 && b1 == 255;
        return groupRange && !rfu && !allNodes;
    }

    public static boolean isValidSubscriptionAddress(@NonNull byte[] address) {
        if (!MeshAddress.isAddressInRange(address)) {
            return false;
        }
        return MeshAddress.isValidSubscriptionAddress((address[0] & 0xFF) << 8 | address[1] & 0xFF);
    }

    public static boolean isValidProxyFilterAddress(int address) {
        if (!MeshAddress.isAddressInRange(address)) {
            return false;
        }
        int b0 = address >> 8 & 0xFF;
        int b1 = address & 0xFF;
        boolean groupRange = b0 >= 192;
        boolean rfu = b0 == 255 && b1 <= 251;
        boolean unicast = MeshAddress.isValidUnicastAddress(address);
        boolean virtual = MeshAddress.isValidVirtualAddress(address);
        return unicast || virtual || groupRange && !rfu;
    }

    public static boolean isValidProxyFilterAddress(@NonNull byte[] address) {
        if (!MeshAddress.isAddressInRange(address)) {
            return false;
        }
        return MeshAddress.isValidProxyFilterAddress((address[0] & 0xFF) << 8 | address[1] & 0xFF);
    }

    @Nullable
    public static AddressType getAddressType(int address) {
        if (MeshAddress.isAddressInRange(address)) {
            if (MeshAddress.isValidUnassignedAddress(address)) {
                return AddressType.UNASSIGNED_ADDRESS;
            }
            if (MeshAddress.isValidUnicastAddress(address)) {
                return AddressType.UNICAST_ADDRESS;
            }
            if (MeshAddress.isValidGroupAddress(address) || MeshAddress.isValidFixedGroupAddress(address)) {
                return AddressType.GROUP_ADDRESS;
            }
            return AddressType.VIRTUAL_ADDRESS;
        }
        return null;
    }

    public static UUID generateRandomLabelUUID() {
        return UUID.randomUUID();
    }

    public static Integer generateVirtualAddress(@NonNull UUID uuid) {
        byte[] uuidBytes = MeshParserUtils.uuidToBytes(uuid);
        byte[] salt = SecureUtils.calculateSalt(VTAD);
        byte[] encryptedUuid = SecureUtils.calculateCMAC(MeshParserUtils.uuidToBytes(uuid), salt);
        ByteBuffer buffer = ByteBuffer.wrap(encryptedUuid);
        buffer.position(12);
        return 0x8000 | buffer.getInt() & 0x3FFF;
    }

    @Nullable
    public static UUID getLabelUuid(@NonNull List<UUID> uuids, int address) {
        if (MeshAddress.isValidVirtualAddress(address)) {
            for (UUID uuid : uuids) {
                byte[] salt = SecureUtils.calculateSalt(VTAD);
                byte[] encryptedUuid = SecureUtils.calculateCMAC(MeshParserUtils.uuidToBytes(uuid), salt);
                ByteBuffer buffer = ByteBuffer.wrap(encryptedUuid);
                buffer.position(12);
                int hash = buffer.getInt() & 0x3FFF;
                if (hash != MeshAddress.getHash(address)) continue;
                return uuid;
            }
        }
        return null;
    }

    public static int getHash(int address) {
        if (MeshAddress.isValidVirtualAddress(address)) {
            return address & 0x3FFF;
        }
        return 0;
    }

    public static byte[] addressIntToBytes(int unicastAddress) {
        return new byte[]{(byte)(unicastAddress >> 8 & 0xFF), (byte)(unicastAddress & 0xFF)};
    }

    public static short addressBytesToInt(byte[] unicastAddress) {
        return ByteBuffer.wrap(unicastAddress).order(ByteOrder.BIG_ENDIAN).getShort();
    }

    public static boolean isValidHeartbeatPublicationDestination(int address) {
        return MeshAddress.isValidUnassignedAddress(address) || MeshAddress.isValidUnicastAddress(address) || MeshAddress.isValidGroupAddress(address);
    }

    public static boolean isValidHeartbeatSubscriptionSource(int address) {
        if (MeshAddress.isValidUnassignedAddress(address) || MeshAddress.isValidUnicastAddress(address)) {
            return true;
        }
        throw new IllegalArgumentException("Source address must be an unassigned address or a unicast address!");
    }

    public static boolean isValidHeartbeatSubscriptionDestination(int address) {
        if (MeshAddress.isValidUnassignedAddress(address) || MeshAddress.isValidUnicastAddress(address) || MeshAddress.isValidGroupAddress(address)) {
            return true;
        }
        throw new IllegalArgumentException("Destination address must be an unassigned address, a primary unicast address, or a group address!");
    }
}

