/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.data;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.List;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.data.ApplicationKeysDao;

public final class ApplicationKeysDao_Impl
implements ApplicationKeysDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ApplicationKey> __insertionAdapterOfApplicationKey;
    private final EntityDeletionOrUpdateAdapter<ApplicationKey> __updateAdapterOfApplicationKey;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public ApplicationKeysDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfApplicationKey = new EntityInsertionAdapter<ApplicationKey>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `application_key` (`id`,`mesh_uuid`,`index`,`name`,`key`,`old_key`,`bound_key_index`) VALUES (nullif(?, 0),?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ApplicationKey value) {
                stmt.bindLong(1, (long)value.getId());
                if (value.getMeshUuid() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMeshUuid());
                }
                stmt.bindLong(3, (long)value.getKeyIndex());
                if (value.getName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getName());
                }
                if (value.getKey() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindBlob(5, value.getKey());
                }
                if (value.getOldKey() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindBlob(6, value.getOldKey());
                }
                stmt.bindLong(7, (long)value.getBoundNetKeyIndex());
            }
        };
        this.__updateAdapterOfApplicationKey = new EntityDeletionOrUpdateAdapter<ApplicationKey>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `application_key` SET `id` = ?,`mesh_uuid` = ?,`index` = ?,`name` = ?,`key` = ?,`old_key` = ?,`bound_key_index` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ApplicationKey value) {
                stmt.bindLong(1, (long)value.getId());
                if (value.getMeshUuid() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMeshUuid());
                }
                stmt.bindLong(3, (long)value.getKeyIndex());
                if (value.getName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getName());
                }
                if (value.getKey() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindBlob(5, value.getKey());
                }
                if (value.getOldKey() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindBlob(6, value.getOldKey());
                }
                stmt.bindLong(7, (long)value.getBoundNetKeyIndex());
                stmt.bindLong(8, (long)value.getId());
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM application_key";
                return "DELETE FROM application_key";
            }
        };
    }

    @Override
    public void insert(List<ApplicationKey> applicationKeys) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfApplicationKey.insert(applicationKeys);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(List<ApplicationKey> appKeys) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfApplicationKey.handleMultiple(appKeys);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ApplicationKey> loadApplicationKeys(String meshUuid) {
        String _sql = "SELECT * from application_key WHERE mesh_uuid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from application_key WHERE mesh_uuid = ?", (int)1);
        int _argIndex = 1;
        if (meshUuid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, meshUuid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfMeshUuid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mesh_uuid");
            int _cursorIndexOfKeyIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"index");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"key");
            int _cursorIndexOfOldKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"old_key");
            int _cursorIndexOfBoundNetKeyIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bound_key_index");
            ArrayList<ApplicationKey> _result = new ArrayList<ApplicationKey>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                int _tmpKeyIndex = _cursor.getInt(_cursorIndexOfKeyIndex);
                byte[] _tmpKey = _cursor.getBlob(_cursorIndexOfKey);
                ApplicationKey _item = new ApplicationKey(_tmpKeyIndex, _tmpKey);
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpMeshUuid = _cursor.getString(_cursorIndexOfMeshUuid);
                _item.setMeshUuid(_tmpMeshUuid);
                String _tmpName = _cursor.getString(_cursorIndexOfName);
                _item.setName(_tmpName);
                byte[] _tmpOldKey = _cursor.getBlob(_cursorIndexOfOldKey);
                _item.setOldKey(_tmpOldKey);
                int _tmpBoundNetKeyIndex = _cursor.getInt(_cursorIndexOfBoundNetKeyIndex);
                _item.setBoundNetKeyIndex(_tmpBoundNetKeyIndex);
                _result.add(_item);
            }
            ArrayList<ApplicationKey> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

