/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.data;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.List;
import no.nordicsemi.android.mesh.AllocatedGroupRange;
import no.nordicsemi.android.mesh.AllocatedSceneRange;
import no.nordicsemi.android.mesh.AllocatedUnicastRange;
import no.nordicsemi.android.mesh.MeshTypeConverters;
import no.nordicsemi.android.mesh.Provisioner;
import no.nordicsemi.android.mesh.data.ProvisionerDao;

public final class ProvisionerDao_Impl
implements ProvisionerDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Provisioner> __insertionAdapterOfProvisioner;
    private final EntityDeletionOrUpdateAdapter<Provisioner> __deletionAdapterOfProvisioner;
    private final EntityDeletionOrUpdateAdapter<Provisioner> __updateAdapterOfProvisioner;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public ProvisionerDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfProvisioner = new EntityInsertionAdapter<Provisioner>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `provisioner` (`mesh_uuid`,`provisioner_uuid`,`name`,`allocated_unicast_ranges`,`allocated_group_ranges`,`allocated_scene_ranges`,`provisioner_address`,`global_ttl`,`last_selected`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Provisioner value) {
                if (value.getMeshUuid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMeshUuid());
                }
                if (value.getProvisionerUuid() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getProvisionerUuid());
                }
                if (value.getProvisionerName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getProvisionerName());
                }
                String _tmp = MeshTypeConverters.allocatedUnicastRangeToJson(value.getAllocatedUnicastRanges());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                String _tmp_1 = MeshTypeConverters.allocatedGroupRangeToJson(value.getAllocatedGroupRanges());
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_1);
                }
                String _tmp_2 = MeshTypeConverters.allocatedSceneRangeToJson(value.getAllocatedSceneRanges());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                if (value.getProvisionerAddress() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindLong(7, (long)value.getProvisionerAddress().intValue());
                }
                stmt.bindLong(8, (long)value.getGlobalTtl());
                int _tmp_3 = value.isLastSelected() ? 1 : 0;
                stmt.bindLong(9, (long)_tmp_3);
            }
        };
        this.__deletionAdapterOfProvisioner = new EntityDeletionOrUpdateAdapter<Provisioner>(__db){

            public String createQuery() {
                return "DELETE FROM `provisioner` WHERE `provisioner_uuid` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Provisioner value) {
                if (value.getProvisionerUuid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getProvisionerUuid());
                }
            }
        };
        this.__updateAdapterOfProvisioner = new EntityDeletionOrUpdateAdapter<Provisioner>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `provisioner` SET `mesh_uuid` = ?,`provisioner_uuid` = ?,`name` = ?,`allocated_unicast_ranges` = ?,`allocated_group_ranges` = ?,`allocated_scene_ranges` = ?,`provisioner_address` = ?,`global_ttl` = ?,`last_selected` = ? WHERE `provisioner_uuid` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Provisioner value) {
                if (value.getMeshUuid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMeshUuid());
                }
                if (value.getProvisionerUuid() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getProvisionerUuid());
                }
                if (value.getProvisionerName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getProvisionerName());
                }
                String _tmp = MeshTypeConverters.allocatedUnicastRangeToJson(value.getAllocatedUnicastRanges());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                String _tmp_1 = MeshTypeConverters.allocatedGroupRangeToJson(value.getAllocatedGroupRanges());
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_1);
                }
                String _tmp_2 = MeshTypeConverters.allocatedSceneRangeToJson(value.getAllocatedSceneRanges());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                if (value.getProvisionerAddress() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindLong(7, (long)value.getProvisionerAddress().intValue());
                }
                stmt.bindLong(8, (long)value.getGlobalTtl());
                int _tmp_3 = value.isLastSelected() ? 1 : 0;
                stmt.bindLong(9, (long)_tmp_3);
                if (value.getProvisionerUuid() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getProvisionerUuid());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM provisioner";
                return "DELETE FROM provisioner";
            }
        };
    }

    @Override
    public void insert(Provisioner provisioner) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfProvisioner.insert((Object)provisioner);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<Provisioner> provisioners) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfProvisioner.insert(provisioners);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(Provisioner provisioner) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfProvisioner.handle((Object)provisioner);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(Provisioner provisioner) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfProvisioner.handle((Object)provisioner);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(List<Provisioner> provisioners) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfProvisioner.handleMultiple(provisioners);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Provisioner> getProvisioners(String meshUuid) {
        String _sql = "SELECT * from provisioner WHERE mesh_uuid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from provisioner WHERE mesh_uuid = ?", (int)1);
        int _argIndex = 1;
        if (meshUuid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, meshUuid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfMeshUuid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mesh_uuid");
            int _cursorIndexOfProvisionerUuid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"provisioner_uuid");
            int _cursorIndexOfProvisionerName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfAllocatedUnicastRanges = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"allocated_unicast_ranges");
            int _cursorIndexOfAllocatedGroupRanges = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"allocated_group_ranges");
            int _cursorIndexOfAllocatedSceneRanges = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"allocated_scene_ranges");
            int _cursorIndexOfProvisionerAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"provisioner_address");
            int _cursorIndexOfGlobalTtl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"global_ttl");
            int _cursorIndexOfLastSelected = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_selected");
            ArrayList<Provisioner> _result = new ArrayList<Provisioner>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpMeshUuid = _cursor.getString(_cursorIndexOfMeshUuid);
                String _tmpProvisionerUuid = _cursor.getString(_cursorIndexOfProvisionerUuid);
                String _tmp = _cursor.getString(_cursorIndexOfAllocatedUnicastRanges);
                List<AllocatedUnicastRange> _tmpAllocatedUnicastRanges = MeshTypeConverters.fromJsonToAllocatedUnicastRanges(_tmp);
                String _tmp_1 = _cursor.getString(_cursorIndexOfAllocatedGroupRanges);
                List<AllocatedGroupRange> _tmpAllocatedGroupRanges = MeshTypeConverters.fromJsonToAllocatedGroupRanges(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfAllocatedSceneRanges);
                List<AllocatedSceneRange> _tmpAllocatedSceneRanges = MeshTypeConverters.fromJsonToAllocatedSceneRanges(_tmp_2);
                Provisioner _item = new Provisioner(_tmpProvisionerUuid, _tmpAllocatedUnicastRanges, _tmpAllocatedGroupRanges, _tmpAllocatedSceneRanges, _tmpMeshUuid);
                String _tmpProvisionerName = _cursor.getString(_cursorIndexOfProvisionerName);
                _item.setProvisionerName(_tmpProvisionerName);
                Integer _tmpProvisionerAddress = _cursor.isNull(_cursorIndexOfProvisionerAddress) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfProvisionerAddress));
                _item.setProvisionerAddress(_tmpProvisionerAddress);
                int _tmpGlobalTtl = _cursor.getInt(_cursorIndexOfGlobalTtl);
                _item.setGlobalTtl(_tmpGlobalTtl);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfLastSelected);
                boolean _tmpLastSelected = _tmp_3 != 0;
                _item.setLastSelected(_tmpLastSelected);
                _result.add(_item);
            }
            ArrayList<Provisioner> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Provisioner getProvisioner(String meshUuid, boolean lastSelected) {
        String _sql = "SELECT * from provisioner WHERE mesh_uuid IS ? AND last_selected IS ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from provisioner WHERE mesh_uuid IS ? AND last_selected IS ?", (int)2);
        int _argIndex = 1;
        if (meshUuid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, meshUuid);
        }
        _argIndex = 2;
        int _tmp = lastSelected ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            Provisioner _result;
            int _cursorIndexOfMeshUuid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mesh_uuid");
            int _cursorIndexOfProvisionerUuid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"provisioner_uuid");
            int _cursorIndexOfProvisionerName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfAllocatedUnicastRanges = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"allocated_unicast_ranges");
            int _cursorIndexOfAllocatedGroupRanges = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"allocated_group_ranges");
            int _cursorIndexOfAllocatedSceneRanges = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"allocated_scene_ranges");
            int _cursorIndexOfProvisionerAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"provisioner_address");
            int _cursorIndexOfGlobalTtl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"global_ttl");
            int _cursorIndexOfLastSelected = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_selected");
            if (_cursor.moveToFirst()) {
                String _tmpMeshUuid = _cursor.getString(_cursorIndexOfMeshUuid);
                String _tmpProvisionerUuid = _cursor.getString(_cursorIndexOfProvisionerUuid);
                String _tmp_1 = _cursor.getString(_cursorIndexOfAllocatedUnicastRanges);
                List<AllocatedUnicastRange> _tmpAllocatedUnicastRanges = MeshTypeConverters.fromJsonToAllocatedUnicastRanges(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfAllocatedGroupRanges);
                List<AllocatedGroupRange> _tmpAllocatedGroupRanges = MeshTypeConverters.fromJsonToAllocatedGroupRanges(_tmp_2);
                String _tmp_3 = _cursor.getString(_cursorIndexOfAllocatedSceneRanges);
                List<AllocatedSceneRange> _tmpAllocatedSceneRanges = MeshTypeConverters.fromJsonToAllocatedSceneRanges(_tmp_3);
                _result = new Provisioner(_tmpProvisionerUuid, _tmpAllocatedUnicastRanges, _tmpAllocatedGroupRanges, _tmpAllocatedSceneRanges, _tmpMeshUuid);
                String _tmpProvisionerName = _cursor.getString(_cursorIndexOfProvisionerName);
                _result.setProvisionerName(_tmpProvisionerName);
                Integer _tmpProvisionerAddress = _cursor.isNull(_cursorIndexOfProvisionerAddress) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfProvisionerAddress));
                _result.setProvisionerAddress(_tmpProvisionerAddress);
                int _tmpGlobalTtl = _cursor.getInt(_cursorIndexOfGlobalTtl);
                _result.setGlobalTtl(_tmpGlobalTtl);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfLastSelected);
                boolean _tmpLastSelected = _tmp_4 != 0;
                _result.setLastSelected(_tmpLastSelected);
            } else {
                _result = null;
            }
            Provisioner provisioner = _result;
            return provisioner;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

