/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import no.nordicsemi.android.mesh.models.SigModelParser;
import no.nordicsemi.android.mesh.models.VendorModel;
import no.nordicsemi.android.mesh.transport.MeshModel;
import no.nordicsemi.android.mesh.transport.PublicationSettings;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public final class MeshModelListDeserializer
implements JsonSerializer<List<MeshModel>>,
JsonDeserializer<List<MeshModel>> {
    public List<MeshModel> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ArrayList<MeshModel> meshModels = new ArrayList<MeshModel>();
        JsonArray jsonArray = json.getAsJsonArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject jsonObject = jsonArray.get(i).getAsJsonObject();
            int modelId = MeshParserUtils.hexToInt(jsonObject.get("modelId").getAsString());
            MeshModel meshModel = this.getMeshModel(modelId);
            if (meshModel == null) continue;
            meshModel.mPublicationSettings = this.deserializePublicationSettings(jsonObject);
            this.setSubscriptionAddresses(meshModel, jsonObject);
            List<Integer> boundKeyIndexes = this.getBoundAppKeyIndexes(jsonObject);
            meshModel.mBoundAppKeyIndexes.addAll(boundKeyIndexes);
            meshModels.add(meshModel);
        }
        return meshModels;
    }

    public JsonElement serialize(List<MeshModel> models, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray jsonArray = new JsonArray();
        for (MeshModel model : models) {
            JsonObject meshModelJson = new JsonObject();
            if (model instanceof VendorModel) {
                meshModelJson.addProperty("modelId", String.format(Locale.US, "%08X", model.getModelId()));
            } else {
                meshModelJson.addProperty("modelId", String.format(Locale.US, "%04X", model.getModelId()));
            }
            meshModelJson.add("bind", (JsonElement)this.serializeBoundAppKeys(model.getBoundAppKeyIndexes()));
            meshModelJson.add("subscribe", (JsonElement)this.serializeSubscriptionAddresses(model));
            if (model.getPublicationSettings() != null) {
                meshModelJson.add("publish", (JsonElement)this.serializePublicationSettings(model.getPublicationSettings()));
            }
            jsonArray.add((JsonElement)meshModelJson);
        }
        return jsonArray;
    }

    private PublicationSettings deserializePublicationSettings(JsonObject jsonObject) {
        int publicationSteps;
        int publicationResolution;
        int publishAddress;
        if (!jsonObject.has("publish")) {
            return null;
        }
        JsonObject publish = jsonObject.get("publish").getAsJsonObject();
        String hexAddress = publish.get("address").getAsString();
        UUID uuid = null;
        if (!TextUtils.isEmpty((CharSequence)hexAddress) && hexAddress.length() == 32) {
            uuid = UUID.fromString(MeshParserUtils.formatUuid(hexAddress));
            publishAddress = MeshAddress.generateVirtualAddress(uuid);
        } else {
            publishAddress = Integer.parseInt(hexAddress, 16);
        }
        int index = publish.get("index").getAsInt();
        byte ttl = publish.get("ttl").getAsByte();
        int period = publish.get("period").getAsInt();
        if (period % 600000 == 0) {
            publicationResolution = 3;
            publicationSteps = period / 600000;
        } else if (period % 10000 == 0) {
            publicationResolution = 2;
            publicationSteps = period / 10000;
        } else if (period % 1000 == 0) {
            publicationResolution = 1;
            publicationSteps = period / 1000;
        } else if (period % 100 == 0) {
            publicationResolution = 0;
            publicationSteps = period / 100;
        } else {
            publicationResolution = period & 3;
            publicationSteps = period >> 6;
        }
        int publishRetransmitCount = publish.get("retransmit").getAsJsonObject().get("count").getAsInt();
        int publishRetransmitIntervalSteps = publish.get("retransmit").getAsJsonObject().get("interval").getAsInt();
        if (publishRetransmitIntervalSteps >= 50) {
            publishRetransmitIntervalSteps = PublicationSettings.parseRetransmitIntervalSteps(publishRetransmitIntervalSteps);
        }
        boolean credentials = publish.get("credentials").getAsInt() == 1;
        PublicationSettings publicationSettings = new PublicationSettings();
        publicationSettings.setPublishAddress(publishAddress);
        publicationSettings.setLabelUUID(uuid);
        publicationSettings.setPublishTtl(ttl);
        publicationSettings.setPublicationSteps(publicationSteps);
        publicationSettings.setPublicationResolution(publicationResolution);
        publicationSettings.setPublishRetransmitCount(publishRetransmitCount);
        publicationSettings.setPublishRetransmitIntervalSteps(publishRetransmitIntervalSteps);
        publicationSettings.setCredentialFlag(credentials);
        return publicationSettings;
    }

    private void setSubscriptionAddresses(MeshModel meshModel, JsonObject jsonObject) {
        ArrayList<Integer> subscriptions = new ArrayList<Integer>();
        if (!jsonObject.has("subscribe")) {
            return;
        }
        JsonArray jsonArray = jsonObject.get("subscribe").getAsJsonArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            int address;
            String hexAddress = jsonArray.get(i).getAsString();
            if (hexAddress.length() == 32) {
                UUID uuid = UUID.fromString(MeshParserUtils.formatUuid(hexAddress));
                address = MeshAddress.generateVirtualAddress(uuid);
                meshModel.labelUuids.add(uuid);
            } else {
                address = Integer.parseInt(hexAddress, 16);
            }
            subscriptions.add(address);
        }
        meshModel.subscriptionAddresses.addAll(subscriptions);
    }

    private List<Integer> getBoundAppKeyIndexes(JsonObject jsonObject) {
        ArrayList<Integer> boundKeyIndexes = new ArrayList<Integer>();
        if (!jsonObject.has("bind")) {
            return boundKeyIndexes;
        }
        JsonArray jsonArray = jsonObject.get("bind").getAsJsonArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            int index = jsonArray.get(i).getAsInt();
            boundKeyIndexes.add(index);
        }
        return boundKeyIndexes;
    }

    private JsonArray serializeSubscriptionAddresses(@NonNull MeshModel model) {
        JsonArray subscriptionsJson = new JsonArray();
        for (Integer address : model.getSubscribedAddresses()) {
            if (MeshAddress.isValidVirtualAddress(address)) {
                UUID uuid = model.getLabelUUID(address);
                subscriptionsJson.add(MeshParserUtils.uuidToHex(uuid));
                continue;
            }
            subscriptionsJson.add(MeshAddress.formatAddress(address, false));
        }
        return subscriptionsJson;
    }

    private JsonObject serializePublicationSettings(PublicationSettings settings) {
        JsonObject publicationJson = new JsonObject();
        if (MeshAddress.isValidVirtualAddress(settings.getPublishAddress())) {
            publicationJson.addProperty("address", MeshParserUtils.uuidToHex(settings.getLabelUUID()));
        } else {
            publicationJson.addProperty("address", MeshAddress.formatAddress(settings.getPublishAddress(), false));
        }
        publicationJson.addProperty("index", (Number)settings.getAppKeyIndex());
        publicationJson.addProperty("ttl", (Number)settings.getPublishTtl());
        publicationJson.addProperty("period", (Number)settings.encodePublicationPeriod());
        JsonObject retransmitJson = new JsonObject();
        retransmitJson.addProperty("count", (Number)settings.getPublishRetransmitCount());
        retransmitJson.addProperty("interval", (Number)settings.getRetransmissionInterval());
        publicationJson.add("retransmit", (JsonElement)retransmitJson);
        publicationJson.addProperty("credentials", (Number)(settings.getCredentialFlag() ? 1 : 0));
        return publicationJson;
    }

    private JsonArray serializeBoundAppKeys(List<Integer> boundAppKeys) {
        JsonArray boundAppKeyIndexes = new JsonArray();
        for (Integer index : boundAppKeys) {
            boundAppKeyIndexes.add((Number)index);
        }
        return boundAppKeyIndexes;
    }

    private MeshModel getMeshModel(int modelId) {
        if (modelId < Short.MIN_VALUE || modelId > Short.MAX_VALUE) {
            return new VendorModel(modelId);
        }
        return SigModelParser.getSigModel(modelId);
    }
}

