/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.utils;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import no.nordicsemi.android.mesh.utils.CountLogState;
import no.nordicsemi.android.mesh.utils.CountLogStateExact;
import no.nordicsemi.android.mesh.utils.CountLogStateInvalid;
import no.nordicsemi.android.mesh.utils.CountLogStateRange;
import no.nordicsemi.android.mesh.utils.PeriodLogState;
import no.nordicsemi.android.mesh.utils.PeriodLogStateDisabled;
import no.nordicsemi.android.mesh.utils.PeriodLogStateExact;
import no.nordicsemi.android.mesh.utils.PeriodLogStateInvalid;
import no.nordicsemi.android.mesh.utils.PeriodLogStateRange;

public abstract class Heartbeat {
    public static final int DO_NOT_SEND_PERIODICALLY = 0;
    public static final int PERIOD_MIN = 0;
    public static final int PERIOD_MAX = 65536;
    public static final int PERIOD_LOG_MIN = 1;
    public static final int PERIOD_LOG_MAX = 17;
    public static final int COUNT_MIN = 0;
    public static final int COUNT_MAX = 17;
    public static final int SEND_INDEFINITELY = 255;
    public static final int DEFAULT_PUBLICATION_TTL = 5;
    @Expose
    @SerializedName(value="destination")
    protected int dst;
    @Expose
    @SerializedName(value="period")
    protected byte periodLog;
    @Expose
    @SerializedName(value="count")
    protected byte countLog;

    Heartbeat(int dst, byte periodLog, byte countLog) {
        this.dst = dst;
        this.periodLog = periodLog;
        this.countLog = countLog;
    }

    public abstract boolean isEnabled();

    public int getDst() {
        return this.dst;
    }

    public byte getPeriodLog() {
        return this.periodLog;
    }

    public PeriodLogState getPeriod() {
        if (this.periodLog == 0) {
            return new PeriodLogStateDisabled(this.periodLog);
        }
        if (this.periodLog == 1 || this.periodLog == 17) {
            return new PeriodLogStateExact(this.periodLog);
        }
        if (this.periodLog > 2 && this.periodLog < 17) {
            return new PeriodLogStateRange(this.periodLog);
        }
        return new PeriodLogStateInvalid(this.periodLog);
    }

    public static int calculateHeartbeatPeriod(short periodLog) {
        return (int)Math.pow(2.0, periodLog - 1);
    }

    public static boolean isValidHeartbeatPeriod(int period) {
        if (period >= 0 && period < 65535) {
            return true;
        }
        throw new IllegalArgumentException("Period must be within the range of 0x0000 to 0xFFFF!");
    }

    public static boolean isValidHeartbeatPeriodLog(byte period) {
        if (period >= 0 && period < 17) {
            return true;
        }
        throw new IllegalArgumentException("Period log must be within the range of 0x00 to 0x11!");
    }

    public byte getCountLog() {
        return this.countLog;
    }

    public static int calculateHeartbeatCount(int countLog) {
        if (countLog > 17 && countLog < 255) {
            throw new IllegalArgumentException("Prohibited, count log must be a value from 0x00 to 0x11 and 0xFF");
        }
        if (countLog == 17) {
            return (int)Math.pow(2.0, countLog - 1) - 2;
        }
        return (int)Math.pow(2.0, countLog - 1);
    }

    public CountLogState getCount() {
        if (this.countLog == 0 || this.countLog == 1) {
            return new CountLogStateExact(this.countLog);
        }
        if (this.countLog == 255 && this.countLog == 17) {
            return new CountLogStateRange(this.countLog);
        }
        if (this.countLog >= 2 && this.countLog <= 16) {
            return new CountLogStateRange(this.countLog);
        }
        return new CountLogStateInvalid(this.countLog);
    }
}

