/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.utils;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import no.nordicsemi.android.mesh.Features;
import no.nordicsemi.android.mesh.utils.Heartbeat;

public class HeartbeatPublication
extends Heartbeat
implements Parcelable {
    @Expose
    @SerializedName(value="ttl")
    private final int ttl;
    @Expose
    @SerializedName(value="features")
    private final Features features;
    @Expose
    @SerializedName(value="index")
    private final int netKeyIndex;
    public static final Parcelable.Creator<HeartbeatPublication> CREATOR = new Parcelable.Creator<HeartbeatPublication>(){

        public HeartbeatPublication createFromParcel(Parcel in) {
            return new HeartbeatPublication(in.readInt(), in.readByte(), in.readByte(), in.readInt(), (Features)in.readParcelable(Features.class.getClassLoader()), in.readInt());
        }

        public HeartbeatPublication[] newArray(int size) {
            return new HeartbeatPublication[size];
        }
    };

    public HeartbeatPublication(int dst, byte countLog, byte periodLog, int ttl, Features features, int netKeyIndex) {
        super(dst, periodLog, countLog);
        this.ttl = ttl;
        this.features = features;
        this.netKeyIndex = netKeyIndex;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.dst);
        dest.writeByte(this.countLog);
        dest.writeByte(this.periodLog);
        dest.writeInt(this.ttl);
        dest.writeParcelable((Parcelable)this.features, flags);
        dest.writeInt(this.netKeyIndex);
    }

    public int describeContents() {
        return 0;
    }

    @NonNull
    public String toString() {
        return "Destination address: " + Integer.toHexString(this.dst) + "\nCount Log: " + Integer.toHexString(this.countLog) + "\nPeriod Log: " + Integer.toHexString(this.periodLog) + "\nTTL: " + this.ttl + "\nFeatures: " + this.features.toString() + "\nNet key index: " + Integer.toHexString(this.netKeyIndex);
    }

    public int getDstAddress() {
        return this.dst;
    }

    public int getTtl() {
        return this.ttl;
    }

    public Features getFeatures() {
        return this.features;
    }

    public int getNetKeyIndex() {
        return this.netKeyIndex;
    }

    @Override
    public boolean isEnabled() {
        return this.dst != 0;
    }
}

