/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.List;
import no.nordicsemi.android.mesh.AllocatedGroupRange;
import no.nordicsemi.android.mesh.AllocatedGroupRangeDeserializer;
import no.nordicsemi.android.mesh.AllocatedSceneRange;
import no.nordicsemi.android.mesh.AllocatedSceneRangeDeserializer;
import no.nordicsemi.android.mesh.AllocatedUnicastRange;
import no.nordicsemi.android.mesh.AllocatedUnicastRangeDeserializer;
import no.nordicsemi.android.mesh.AppKeyDeserializer;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.LoadNetworkCallbacks;
import no.nordicsemi.android.mesh.MeshNetwork;
import no.nordicsemi.android.mesh.MeshNetworkDeserializer;
import no.nordicsemi.android.mesh.NetKeyDeserializer;
import no.nordicsemi.android.mesh.NetworkKey;
import no.nordicsemi.android.mesh.transport.Element;
import no.nordicsemi.android.mesh.transport.InternalElementListDeserializer;
import no.nordicsemi.android.mesh.transport.MeshModel;
import no.nordicsemi.android.mesh.transport.MeshModelListDeserializer;
import no.nordicsemi.android.mesh.transport.NodeDeserializer;
import no.nordicsemi.android.mesh.transport.ProvisionedMeshNode;

class NetworkImportExportUtils {
    private static final String TAG = NetworkImportExportUtils.class.getSimpleName();

    NetworkImportExportUtils() {
    }

    static void importMeshNetwork(@NonNull Context context, @NonNull Uri uri, @NonNull LoadNetworkCallbacks callbacks) throws JsonSyntaxException {
        new NetworkImportAsyncTask(context, uri, callbacks).execute(new Void[0]);
    }

    static void importMeshNetworkFromJson(@NonNull Context context, @NonNull String networkJson, @NonNull LoadNetworkCallbacks callbacks) {
        new NetworkImportAsyncTask(context, networkJson, callbacks).execute(new Void[0]);
    }

    @Nullable
    static String export(@NonNull MeshNetwork network) {
        try {
            Type netKeyList = new TypeToken<List<NetworkKey>>(){}.getType();
            Type appKeyList = new TypeToken<List<ApplicationKey>>(){}.getType();
            Type allocatedUnicastRange = new TypeToken<List<AllocatedUnicastRange>>(){}.getType();
            Type allocatedGroupRange = new TypeToken<List<AllocatedGroupRange>>(){}.getType();
            Type allocatedSceneRange = new TypeToken<List<AllocatedSceneRange>>(){}.getType();
            Type nodeList = new TypeToken<List<ProvisionedMeshNode>>(){}.getType();
            Type meshModelList = new TypeToken<List<MeshModel>>(){}.getType();
            Type elementList = new TypeToken<List<Element>>(){}.getType();
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeAdapter(netKeyList, (Object)new NetKeyDeserializer());
            gsonBuilder.registerTypeAdapter(appKeyList, (Object)new AppKeyDeserializer());
            gsonBuilder.registerTypeAdapter(allocatedUnicastRange, (Object)new AllocatedUnicastRangeDeserializer());
            gsonBuilder.registerTypeAdapter(allocatedGroupRange, (Object)new AllocatedGroupRangeDeserializer());
            gsonBuilder.registerTypeAdapter(allocatedSceneRange, (Object)new AllocatedSceneRangeDeserializer());
            gsonBuilder.registerTypeAdapter(nodeList, (Object)new NodeDeserializer());
            gsonBuilder.registerTypeAdapter(elementList, (Object)new InternalElementListDeserializer());
            gsonBuilder.registerTypeAdapter(meshModelList, (Object)new MeshModelListDeserializer());
            gsonBuilder.registerTypeAdapter(MeshNetwork.class, (Object)new MeshNetworkDeserializer());
            Gson gson = gsonBuilder.serializeNulls().setPrettyPrinting().create();
            return gson.toJson((Object)network);
        }
        catch (JsonSyntaxException ex) {
            Log.e((String)TAG, (String)("Error: " + ex.getMessage()));
            return null;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error: " + e.getMessage()));
            return null;
        }
    }

    private static class NetworkImportAsyncTask
    extends AsyncTask<Void, Void, Void> {
        private WeakReference<Context> context;
        private final Uri uri;
        private final LoadNetworkCallbacks callbacks;
        private MeshNetwork network;
        private String error;
        private final String networkJson;

        NetworkImportAsyncTask(@NonNull Context context, @NonNull Uri uri, @NonNull LoadNetworkCallbacks callbacks) {
            this.context = new WeakReference<Context>(context);
            this.uri = uri;
            this.networkJson = null;
            this.callbacks = callbacks;
        }

        NetworkImportAsyncTask(@NonNull Context context, @NonNull String networkJson, @NonNull LoadNetworkCallbacks callbacks) {
            this.context = new WeakReference<Context>(context);
            this.networkJson = networkJson;
            this.uri = null;
            this.callbacks = callbacks;
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected Void doInBackground(Void ... voids) {
            try {
                this.importNetwork();
            }
            catch (Exception ex) {
                this.error = ex.getMessage() + "\n\nP.S. If the json file was exported using an older version 2.0.0 (Mesh Library), please retry exporting the json file and importing again.";
            }
            return null;
        }

        protected void onPostExecute(Void aVoid) {
            super.onPostExecute((Object)aVoid);
            if (this.network != null) {
                this.callbacks.onNetworkImportedFromJson(this.network);
            } else {
                this.callbacks.onNetworkImportFailed(this.error);
            }
        }

        private void importNetwork() throws JsonSyntaxException {
            try {
                Type netKeyList = new TypeToken<List<NetworkKey>>(){}.getType();
                Type appKeyList = new TypeToken<List<ApplicationKey>>(){}.getType();
                Type allocatedUnicastRange = new TypeToken<List<AllocatedUnicastRange>>(){}.getType();
                Type allocatedGroupRange = new TypeToken<List<AllocatedGroupRange>>(){}.getType();
                Type allocatedSceneRange = new TypeToken<List<AllocatedSceneRange>>(){}.getType();
                Type nodeList = new TypeToken<List<ProvisionedMeshNode>>(){}.getType();
                Type meshModelList = new TypeToken<List<MeshModel>>(){}.getType();
                Type elementList = new TypeToken<List<Element>>(){}.getType();
                GsonBuilder gsonBuilder = new GsonBuilder();
                gsonBuilder.registerTypeAdapter(MeshNetwork.class, (Object)new MeshNetworkDeserializer());
                gsonBuilder.registerTypeAdapter(netKeyList, (Object)new NetKeyDeserializer());
                gsonBuilder.registerTypeAdapter(appKeyList, (Object)new AppKeyDeserializer());
                gsonBuilder.registerTypeAdapter(allocatedUnicastRange, (Object)new AllocatedUnicastRangeDeserializer());
                gsonBuilder.registerTypeAdapter(allocatedGroupRange, (Object)new AllocatedGroupRangeDeserializer());
                gsonBuilder.registerTypeAdapter(allocatedSceneRange, (Object)new AllocatedSceneRangeDeserializer());
                gsonBuilder.registerTypeAdapter(nodeList, (Object)new NodeDeserializer());
                gsonBuilder.registerTypeAdapter(elementList, (Object)new InternalElementListDeserializer());
                gsonBuilder.registerTypeAdapter(meshModelList, (Object)new MeshModelListDeserializer());
                Gson gson = gsonBuilder.serializeNulls().create();
                String json = this.networkJson != null ? this.networkJson : this.readJsonStringFromUri();
                MeshNetwork network = (MeshNetwork)gson.fromJson(json, MeshNetwork.class);
                if (network != null) {
                    this.network = network;
                }
            }
            catch (JsonSyntaxException ex) {
                this.error = ex.getMessage();
                Log.e((String)TAG, (String)(" " + this.error));
            }
            catch (IOException e) {
                this.error = e.getMessage();
                Log.e((String)TAG, (String)(" " + this.error));
            }
        }

        private String readJsonStringFromUri() throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            InputStream inputStream = ((Context)this.context.get()).getContentResolver().openInputStream(this.uri);
            if (inputStream != null) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = reader.readLine()) != null) {
                    stringBuilder.append(line);
                }
                reader.close();
                inputStream.close();
            }
            return stringBuilder.toString();
        }
    }
}

