/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.room.Ignore;
import java.util.ArrayList;
import java.util.List;
import no.nordicsemi.android.mesh.AllocatedGroupRange;
import no.nordicsemi.android.mesh.AllocatedSceneRange;
import no.nordicsemi.android.mesh.AllocatedUnicastRange;

public abstract class Range
implements Parcelable {
    @Ignore
    protected int lowerBound;
    @Ignore
    protected int upperBound;

    public abstract int getLowerBound();

    public abstract int getUpperBound();

    public abstract boolean overlaps(@NonNull Range var1);

    public abstract int range();

    protected boolean overlaps(int rLow, int rHigh, int oLow, int oHigh) {
        if (rLow == oLow && rHigh == oHigh) {
            return true;
        }
        if (rLow < oLow && rHigh > oHigh) {
            return true;
        }
        if (rLow > oLow && rHigh < oHigh) {
            return true;
        }
        if (rLow <= oLow && rHigh >= oLow && rHigh <= oHigh) {
            return true;
        }
        return rHigh >= oHigh && rLow >= oLow && rLow <= oHigh;
    }

    public static List<AllocatedUnicastRange> mergeUnicastRanges(@NonNull List<AllocatedUnicastRange> ranges) {
        AllocatedUnicastRange accumulator = new AllocatedUnicastRange();
        ArrayList<AllocatedUnicastRange> result = new ArrayList<AllocatedUnicastRange>();
        for (AllocatedUnicastRange range : ranges) {
            if (accumulator.getLowAddress() == 0 && accumulator.getHighAddress() == 0) {
                accumulator = range;
            }
            if (accumulator.getHighAddress() >= range.getHighAddress()) continue;
            if (accumulator.getHighAddress() + 1 >= range.getLowAddress()) {
                accumulator = new AllocatedUnicastRange(accumulator.getLowAddress(), range.getHighAddress());
                continue;
            }
            result.add(accumulator);
            accumulator = range;
        }
        if (accumulator.getLowAddress() != 0 && accumulator.getHighAddress() != 0) {
            result.add(accumulator);
        }
        return result;
    }

    public static List<AllocatedGroupRange> mergeGroupRanges(@NonNull List<AllocatedGroupRange> ranges) {
        AllocatedGroupRange accumulator = new AllocatedGroupRange();
        ArrayList<AllocatedGroupRange> results = new ArrayList<AllocatedGroupRange>();
        for (AllocatedGroupRange range : ranges) {
            if (accumulator.getLowAddress() == 0 && accumulator.getHighAddress() == 0) {
                accumulator = range;
            }
            if (accumulator.getHighAddress() >= range.getHighAddress()) continue;
            if (accumulator.getHighAddress() + 1 >= range.getLowAddress()) {
                accumulator = new AllocatedGroupRange(accumulator.getLowAddress(), range.getHighAddress());
                continue;
            }
            results.add(accumulator);
            accumulator = range;
        }
        if (accumulator.getLowAddress() != 0 && accumulator.getHighAddress() != 0) {
            results.add(accumulator);
        }
        return results;
    }

    public static List<AllocatedSceneRange> mergeSceneRanges(@NonNull List<AllocatedSceneRange> ranges) {
        AllocatedSceneRange accumulator = new AllocatedSceneRange();
        ArrayList<AllocatedSceneRange> result = new ArrayList<AllocatedSceneRange>();
        for (AllocatedSceneRange range : ranges) {
            if (accumulator.getFirstScene() == 0 && accumulator.getLastScene() == 0) {
                accumulator = range;
            }
            if (accumulator.getLastScene() >= range.getLastScene()) continue;
            if (accumulator.getLastScene() + 1 >= range.getFirstScene()) {
                accumulator = new AllocatedSceneRange(accumulator.getFirstScene(), range.getLastScene());
                continue;
            }
            result.add(accumulator);
            accumulator = range;
        }
        if (accumulator.getFirstScene() != 0 && accumulator.getLastScene() != 0) {
            result.add(accumulator);
        }
        return result;
    }
}

