/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ConfigStatusMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class ConfigModelPublicationStatus
extends ConfigStatusMessage
implements Parcelable {
    private static final String TAG = ConfigModelPublicationStatus.class.getSimpleName();
    private static final int OP_CODE = 32830;
    private static final int CONFIG_MODEL_PUBLICATION_STATUS_SIG_MODEL_PDU_LENGTH = 12;
    private static final int CONFIG_MODEL_APP_BIND_STATUS_VENDOR_MODEL_PDU_LENGTH = 14;
    private int mElementAddress;
    private int publishAddress;
    private int mAppKeyIndex;
    private boolean credentialFlag;
    private int publishTtl;
    private int publicationSteps;
    private int publicationResolution;
    private int publishRetransmitCount;
    private int publishRetransmitIntervalSteps;
    private int mModelIdentifier;
    private static final Parcelable.Creator<ConfigModelPublicationStatus> CREATOR = new Parcelable.Creator<ConfigModelPublicationStatus>(){

        public ConfigModelPublicationStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new ConfigModelPublicationStatus(message);
        }

        public ConfigModelPublicationStatus[] newArray(int size) {
            return new ConfigModelPublicationStatus[size];
        }
    };

    public ConfigModelPublicationStatus(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    final void parseStatusParameters() {
        AccessMessage message = (AccessMessage)this.mMessage;
        this.mStatusCode = this.mParameters[0];
        this.mStatusCodeName = this.getStatusCodeName(this.mStatusCode);
        this.mElementAddress = MeshParserUtils.unsignedBytesToInt(this.mParameters[1], this.mParameters[2]);
        this.publishAddress = MeshParserUtils.unsignedBytesToInt(this.mParameters[3], this.mParameters[4]);
        byte[] appKeyIndex = new byte[]{(byte)(this.mParameters[6] & 0xF), this.mParameters[5]};
        this.mAppKeyIndex = ByteBuffer.wrap(appKeyIndex).order(ByteOrder.BIG_ENDIAN).getShort();
        this.credentialFlag = (this.mParameters[6] & 0xF0) >> 4 == 1;
        this.publishTtl = MeshParserUtils.unsignedByteToInt(this.mParameters[7]);
        int publishPeriod = MeshParserUtils.unsignedByteToInt(this.mParameters[8]);
        this.publicationSteps = publishPeriod & 0x3F;
        this.publicationResolution = publishPeriod >> 6;
        int publishRetransmission = MeshParserUtils.unsignedByteToInt(this.mParameters[9]);
        this.publishRetransmitCount = publishRetransmission & 7;
        this.publishRetransmitIntervalSteps = publishRetransmission >> 3;
        if (this.mParameters.length == 12) {
            this.mModelIdentifier = MeshParserUtils.unsignedBytesToInt(this.mParameters[10], this.mParameters[11]);
        } else {
            byte[] modelIdentifier = new byte[]{this.mParameters[11], this.mParameters[10], this.mParameters[13], this.mParameters[12]};
            this.mModelIdentifier = ByteBuffer.wrap(modelIdentifier).order(ByteOrder.BIG_ENDIAN).getInt();
        }
        Log.v((String)TAG, (String)("Status code: " + this.mStatusCode));
        Log.v((String)TAG, (String)("Status message: " + this.mStatusCodeName));
        Log.v((String)TAG, (String)("Element address: " + MeshAddress.formatAddress(this.mElementAddress, false)));
        Log.v((String)TAG, (String)("Publish Address: " + MeshAddress.formatAddress(this.publishAddress, false)));
        Log.v((String)TAG, (String)("App key index: " + MeshParserUtils.bytesToHex(appKeyIndex, false)));
        Log.v((String)TAG, (String)("Credential Flag: " + this.credentialFlag));
        Log.v((String)TAG, (String)("Publish TTL: " + this.publishTtl));
        Log.v((String)TAG, (String)("Publish Period where steps: " + this.publicationSteps + " and resolution: " + this.publicationResolution));
        Log.v((String)TAG, (String)("Publish Retransmit Count: " + this.publishRetransmitCount));
        Log.v((String)TAG, (String)("Publish Retransmit Interval Steps: " + this.publishRetransmitIntervalSteps));
        Log.v((String)TAG, (String)("Model Identifier: " + Integer.toHexString(this.mModelIdentifier)));
        Log.v((String)TAG, (String)("Publication status: " + MeshParserUtils.bytesToHex(this.mParameters, false)));
    }

    @Override
    public int getOpCode() {
        return 32830;
    }

    public int getElementAddress() {
        return this.mElementAddress;
    }

    public final int getAppKeyIndex() {
        return this.mAppKeyIndex;
    }

    public boolean isSuccessful() {
        return this.mStatusCode == 0;
    }

    public int getPublishAddress() {
        return this.publishAddress;
    }

    public boolean getCredentialFlag() {
        return this.credentialFlag;
    }

    public int getPublishTtl() {
        return this.publishTtl;
    }

    public int getPublicationSteps() {
        return this.publicationSteps;
    }

    public int getPublicationResolution() {
        return this.publicationResolution;
    }

    public int getPublishRetransmitCount() {
        return this.publishRetransmitCount;
    }

    public int getPublishRetransmitIntervalSteps() {
        return this.publishRetransmitIntervalSteps;
    }

    public int getModelIdentifier() {
        return this.mModelIdentifier;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }
}

