/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import no.nordicsemi.android.mesh.transport.ConfigModelPublicationStatus;
import no.nordicsemi.android.mesh.transport.PublicationSettings;
import no.nordicsemi.android.mesh.utils.MeshAddress;

public abstract class MeshModel
implements Parcelable {
    @Expose
    protected int mModelId;
    @Expose
    final List<Integer> mBoundAppKeyIndexes = new ArrayList<Integer>();
    @Expose(serialize=false)
    final Map<Integer, String> mBoundAppKeys = new LinkedHashMap<Integer, String>();
    @Expose
    final List<Integer> subscriptionAddresses = new ArrayList<Integer>();
    @Expose
    final List<UUID> labelUuids = new ArrayList<UUID>();
    @Expose
    PublicationSettings mPublicationSettings;

    public MeshModel(int modelId) {
        this.mModelId = modelId;
    }

    MeshModel() {
    }

    protected MeshModel(Parcel in) {
        int modelId = in.readInt();
        this.mModelId = modelId < Short.MIN_VALUE || modelId > Short.MAX_VALUE ? modelId : (int)((short)modelId);
        in.readList(this.mBoundAppKeyIndexes, Integer.class.getClassLoader());
        this.mPublicationSettings = (PublicationSettings)in.readValue(PublicationSettings.class.getClassLoader());
        in.readList(this.subscriptionAddresses, Integer.class.getClassLoader());
        in.readList(this.labelUuids, UUID.class.getClassLoader());
    }

    protected final void parcelMeshModel(Parcel dest, int flags) {
        dest.writeInt(this.mModelId);
        dest.writeList(this.mBoundAppKeyIndexes);
        dest.writeValue((Object)this.mPublicationSettings);
        dest.writeList(this.subscriptionAddresses);
        dest.writeList(this.labelUuids);
    }

    public abstract int getModelId();

    public abstract String getModelName();

    public List<Integer> getBoundAppKeyIndexes() {
        return Collections.unmodifiableList(this.mBoundAppKeyIndexes);
    }

    protected void setBoundAppKeyIndex(int appKeyIndex) {
        if (!this.mBoundAppKeyIndexes.contains(appKeyIndex)) {
            this.mBoundAppKeyIndexes.add(appKeyIndex);
        }
    }

    protected void setBoundAppKeyIndexes(@NonNull List<Integer> indexes) {
        this.mBoundAppKeyIndexes.clear();
        this.mBoundAppKeyIndexes.addAll(indexes);
    }

    protected void removeBoundAppKeyIndex(int appKeyIndex) {
        if (this.mBoundAppKeyIndexes.contains(appKeyIndex)) {
            int position = this.mBoundAppKeyIndexes.indexOf(appKeyIndex);
            this.mBoundAppKeyIndexes.remove(position);
        }
    }

    public List<Integer> getSubscribedAddresses() {
        return Collections.unmodifiableList(this.subscriptionAddresses);
    }

    public List<UUID> getLabelUUID() {
        return Collections.unmodifiableList(this.labelUuids);
    }

    public UUID getLabelUUID(int address) {
        return MeshAddress.getLabelUuid(this.labelUuids, address);
    }

    protected void setPublicationStatus(@NonNull ConfigModelPublicationStatus status, @Nullable UUID labelUUID) {
        if (status.isSuccessful()) {
            this.mPublicationSettings = new PublicationSettings(status.getPublishAddress(), labelUUID, status.getAppKeyIndex(), status.getCredentialFlag(), status.getPublishTtl(), status.getPublicationSteps(), status.getPublicationResolution(), status.getPublishRetransmitCount(), status.getPublishRetransmitIntervalSteps());
        }
    }

    protected void updatePublicationStatus(@NonNull ConfigModelPublicationStatus status) {
        if (status.isSuccessful()) {
            if (this.mPublicationSettings != null) {
                this.mPublicationSettings.setPublishAddress(status.getPublishAddress());
                if (!MeshAddress.isValidVirtualAddress(status.getPublishAddress())) {
                    this.mPublicationSettings.setLabelUUID(null);
                }
                this.mPublicationSettings.setAppKeyIndex(status.getAppKeyIndex());
                this.mPublicationSettings.setCredentialFlag(status.getCredentialFlag());
                this.mPublicationSettings.setPublishTtl(status.getPublishTtl());
                this.mPublicationSettings.setPublicationSteps(status.getPublicationSteps());
                this.mPublicationSettings.setPublicationResolution(status.getPublicationResolution());
                this.mPublicationSettings.setPublishRetransmitCount(status.getPublishRetransmitCount());
                this.mPublicationSettings.setPublishRetransmitIntervalSteps(status.getPublishRetransmitIntervalSteps());
            } else {
                this.mPublicationSettings = new PublicationSettings(status.getPublishAddress(), null, status.getAppKeyIndex(), status.getCredentialFlag(), status.getPublishTtl(), status.getPublicationSteps(), status.getPublicationResolution(), status.getPublishRetransmitCount(), status.getPublishRetransmitIntervalSteps());
            }
        }
    }

    public PublicationSettings getPublicationSettings() {
        return this.mPublicationSettings;
    }

    protected void addSubscriptionAddress(int subscriptionAddress) {
        if (!this.subscriptionAddresses.contains(subscriptionAddress)) {
            this.subscriptionAddresses.add(subscriptionAddress);
        }
    }

    protected void addSubscriptionAddress(@NonNull UUID labelUuid, int address) {
        if (!this.labelUuids.contains(labelUuid)) {
            this.labelUuids.add(labelUuid);
        }
        if (!this.subscriptionAddresses.contains(address)) {
            this.subscriptionAddresses.add(address);
        }
    }

    protected void removeSubscriptionAddress(@NonNull Integer address) {
        this.subscriptionAddresses.remove(address);
    }

    protected void removeSubscriptionAddress(@NonNull UUID labelUuid, @NonNull Integer address) {
        this.labelUuids.remove(labelUuid);
        this.removeSubscriptionAddress(address);
    }

    protected void removeAllSubscriptionAddresses() {
        this.labelUuids.clear();
        this.subscriptionAddresses.clear();
    }

    protected void overwriteSubscriptionAddress(@NonNull Integer subscriptionAddress) {
        this.subscriptionAddresses.clear();
        this.addSubscriptionAddress(subscriptionAddress);
    }

    protected void overwriteSubscriptionAddress(@NonNull UUID labelUuid, @NonNull Integer address) {
        this.labelUuids.clear();
        this.addSubscriptionAddress(labelUuid, address);
        this.overwriteSubscriptionAddress(address);
    }

    protected void updateSubscriptionAddressesList(@NonNull List<Integer> addresses) {
        this.subscriptionAddresses.clear();
        this.subscriptionAddresses.addAll(addresses);
    }
}

