/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.utils;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import no.nordicsemi.android.mesh.utils.Heartbeat;

public class HeartbeatSubscription
extends Heartbeat
implements Parcelable {
    @Expose
    @SerializedName(value="source")
    private final int src;
    @Expose
    @SerializedName(value="minHops")
    private int minHops;
    @Expose
    @SerializedName(value="maxHops")
    private int maxHops;
    public static final Parcelable.Creator<HeartbeatSubscription> CREATOR = new Parcelable.Creator<HeartbeatSubscription>(){

        public HeartbeatSubscription createFromParcel(Parcel in) {
            return new HeartbeatSubscription(in.readInt(), in.readInt(), in.readByte(), in.readByte(), in.readInt(), in.readInt());
        }

        public HeartbeatSubscription[] newArray(int size) {
            return new HeartbeatSubscription[size];
        }
    };

    public HeartbeatSubscription(int src, int dst, byte periodLog, byte countLog, int minHops, int maxHops) {
        super(dst, periodLog, countLog);
        this.src = src;
        this.minHops = minHops;
        this.maxHops = maxHops;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.src);
        dest.writeInt(this.dst);
        dest.writeByte(this.periodLog);
        dest.writeByte(this.countLog);
        dest.writeInt(this.minHops);
        dest.writeInt(this.maxHops);
    }

    @NonNull
    public String toString() {
        return "Source address: " + Integer.toHexString(this.src) + "\nDestination address: " + Integer.toHexString(this.dst) + "\nPeriod Log: " + Integer.toHexString(this.periodLog) + "\nCount Log: " + Integer.toHexString(this.countLog) + "\nMin Hops: " + this.minHops + "\n Max Hops: " + this.maxHops;
    }

    public int getSrc() {
        return this.src;
    }

    public int getMinHops() {
        return this.minHops;
    }

    public int getMaxHops() {
        return this.maxHops;
    }

    @Override
    public boolean isEnabled() {
        return this.src != 0 && this.dst != 0 && this.periodLog != 0;
    }
}

