/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.utils;

import no.nordicsemi.android.mesh.utils.PeriodLogState;

public final class PeriodLogStateRange
extends PeriodLogState {
    public PeriodLogStateRange(int periodLog) {
        super(periodLog);
    }

    public int getLowerBound() {
        return (int)Math.pow(2.0, this.periodLog - 1);
    }

    public int getUpperBound() {
        return (int)Math.pow(2.0, this.periodLog) - 1;
    }

    @Override
    public String getPeriodDescription() {
        int lowerBound = this.getLowerBound();
        int upperBound = this.getUpperBound();
        return PeriodLogStateRange.periodToTime(lowerBound) + " ... " + PeriodLogStateRange.periodToTime(upperBound);
    }

    public static String periodToTime(int seconds) {
        if (seconds == 1) {
            return seconds + " second";
        }
        if (seconds > 1 && seconds < 60) {
            return seconds + " seconds";
        }
        if (seconds >= 60 && seconds < 3600) {
            return seconds / 60 + " min " + seconds % 60 + " sec";
        }
        if (seconds >= 3600 && seconds <= 65535) {
            return seconds / 3600 + " h " + seconds % 3600 / 60 + " min " + seconds % 3600 % 60 + " sec";
        }
        return seconds / 3600 + " h " + seconds % 3600 / 60 + " min " + (seconds % 3600 % 60 - 1) + " sec";
    }
}

