/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import no.nordicsemi.android.mesh.AllocatedGroupRange;
import no.nordicsemi.android.mesh.AllocatedSceneRange;
import no.nordicsemi.android.mesh.AllocatedUnicastRange;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.ApplicationKeysConfig;
import no.nordicsemi.android.mesh.Group;
import no.nordicsemi.android.mesh.GroupsConfig;
import no.nordicsemi.android.mesh.ImportExportUtils;
import no.nordicsemi.android.mesh.InternalMeshManagerCallbacks;
import no.nordicsemi.android.mesh.InternalTransportCallbacks;
import no.nordicsemi.android.mesh.IvIndex;
import no.nordicsemi.android.mesh.LoadNetworkCallbacks;
import no.nordicsemi.android.mesh.MeshBeacon;
import no.nordicsemi.android.mesh.MeshManagerCallbacks;
import no.nordicsemi.android.mesh.MeshMessageHandler;
import no.nordicsemi.android.mesh.MeshMngrApi;
import no.nordicsemi.android.mesh.MeshNetwork;
import no.nordicsemi.android.mesh.MeshNetworkCallbacks;
import no.nordicsemi.android.mesh.MeshNetworkDb;
import no.nordicsemi.android.mesh.MeshProvisioningHandler;
import no.nordicsemi.android.mesh.MeshProvisioningStatusCallbacks;
import no.nordicsemi.android.mesh.MeshStatusCallbacks;
import no.nordicsemi.android.mesh.NetworkKey;
import no.nordicsemi.android.mesh.NetworkKeysConfig;
import no.nordicsemi.android.mesh.NodesConfig;
import no.nordicsemi.android.mesh.Provisioner;
import no.nordicsemi.android.mesh.ProvisionersConfig;
import no.nordicsemi.android.mesh.Scene;
import no.nordicsemi.android.mesh.ScenesConfig;
import no.nordicsemi.android.mesh.SecureNetworkBeacon;
import no.nordicsemi.android.mesh.UnprovisionedBeacon;
import no.nordicsemi.android.mesh.data.ApplicationKeyDao;
import no.nordicsemi.android.mesh.data.ApplicationKeysDao;
import no.nordicsemi.android.mesh.data.GroupDao;
import no.nordicsemi.android.mesh.data.GroupsDao;
import no.nordicsemi.android.mesh.data.MeshNetworkDao;
import no.nordicsemi.android.mesh.data.NetworkKeyDao;
import no.nordicsemi.android.mesh.data.NetworkKeysDao;
import no.nordicsemi.android.mesh.data.ProvisionedMeshNodeDao;
import no.nordicsemi.android.mesh.data.ProvisionedMeshNodesDao;
import no.nordicsemi.android.mesh.data.ProvisionerDao;
import no.nordicsemi.android.mesh.data.ProvisionersDao;
import no.nordicsemi.android.mesh.data.SceneDao;
import no.nordicsemi.android.mesh.data.ScenesDao;
import no.nordicsemi.android.mesh.provisionerstates.UnprovisionedMeshNode;
import no.nordicsemi.android.mesh.transport.MeshMessage;
import no.nordicsemi.android.mesh.transport.NetworkLayerCallbacks;
import no.nordicsemi.android.mesh.transport.ProvisionedMeshNode;
import no.nordicsemi.android.mesh.transport.UpperTransportLayerCallbacks;
import no.nordicsemi.android.mesh.utils.ExtendedInvalidCipherTextException;
import no.nordicsemi.android.mesh.utils.InputOOBAction;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;
import no.nordicsemi.android.mesh.utils.OutputOOBAction;
import no.nordicsemi.android.mesh.utils.ProxyFilter;
import no.nordicsemi.android.mesh.utils.SecureUtils;
import org.spongycastle.jce.provider.BouncyCastleProvider;

public class MeshManagerApi
implements MeshMngrApi {
    private static final String TAG = MeshManagerApi.class.getSimpleName();
    public static final UUID MESH_PROVISIONING_UUID = UUID.fromString("00001827-0000-1000-8000-00805F9B34FB");
    public static final UUID MESH_PROXY_UUID = UUID.fromString("00001828-0000-1000-8000-00805F9B34FB");
    public static final byte PDU_TYPE_PROVISIONING = 3;
    public static final byte PDU_TYPE_NETWORK = 0;
    public static final byte PDU_TYPE_MESH_BEACON = 1;
    public static final byte PDU_TYPE_PROXY_CONFIGURATION = 2;
    private static final byte GATT_SAR_COMPLETE = 0;
    private static final byte GATT_SAR_START = 1;
    private static final byte GATT_SAR_CONTINUATION = 2;
    private static final byte GATT_SAR_END = 3;
    private static final int GATT_SAR_MASK = 192;
    private static final int GATT_SAR_UNMASK = 63;
    private static final int SAR_BIT_OFFSET = 6;
    private static final long PROXY_SAR_TRANSFER_TIME_OUT = 20000L;
    private static final int HASH_RANDOM_NUMBER_LENGTH = 64;
    private static final int ADVERTISEMENT_TYPE_NETWORK_ID = 0;
    private static final int ADVERTISEMENT_TYPE_NODE_IDENTITY = 1;
    private static final int ADVERTISED_HASH_OFFSET = 1;
    private static final int ADVERTISED_HASH_LENGTH = 8;
    private static final int ADVERTISED_RANDOM_OFFSET = 9;
    private static final int ADVERTISED_RANDOM_LENGTH = 8;
    private static final int ADVERTISED_NETWORK_ID_OFFSET = 1;
    private static final int ADVERTISED_NETWORK_ID_LENGTH = 8;
    private final Context mContext;
    private final Handler mHandler;
    private MeshManagerCallbacks mMeshManagerCallbacks;
    private final MeshProvisioningHandler mMeshProvisioningHandler;
    private final MeshMessageHandler mMeshMessageHandler;
    private final ImportExportUtils mImportExportUtils;
    private byte[] mIncomingBuffer;
    private int mIncomingBufferOffset;
    private byte[] mOutgoingBuffer;
    private int mOutgoingBufferOffset;
    private MeshNetwork mMeshNetwork;
    private boolean ivUpdateTestModeActive = false;
    private boolean allowIvIndexRecoveryOver42 = false;
    private MeshNetworkDb mMeshNetworkDb;
    private MeshNetworkDao mMeshNetworkDao;
    private NetworkKeyDao mNetworkKeyDao;
    private NetworkKeysDao mNetworkKeysDao;
    private ApplicationKeyDao mApplicationKeyDao;
    private ApplicationKeysDao mApplicationKeysDao;
    private ProvisionerDao mProvisionerDao;
    private ProvisionersDao mProvisionersDao;
    private ProvisionedMeshNodeDao mProvisionedNodeDao;
    private ProvisionedMeshNodesDao mProvisionedNodesDao;
    private GroupDao mGroupDao;
    private GroupsDao mGroupsDao;
    private SceneDao mSceneDao;
    private ScenesDao mScenesDao;
    private final Runnable mProxyProtocolTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            MeshManagerApi.this.mMeshMessageHandler.onIncompleteTimerExpired(0);
        }
    };
    private final InternalTransportCallbacks internalTransportCallbacks = new InternalTransportCallbacks(){

        @Override
        public List<ApplicationKey> getApplicationKeys(int boundNetKeyIndex) {
            return MeshManagerApi.this.mMeshNetwork.getAppKeys(boundNetKeyIndex);
        }

        @Override
        public ProvisionedMeshNode getNode(int unicast) {
            return MeshManagerApi.this.mMeshNetwork.getNode(unicast);
        }

        @Override
        public Provisioner getProvisioner(int unicast) {
            return null;
        }

        @Override
        public void sendProvisioningPdu(UnprovisionedMeshNode meshNode, byte[] pdu) {
            int mtu = MeshManagerApi.this.mMeshManagerCallbacks.getMtu();
            MeshManagerApi.this.mMeshManagerCallbacks.sendProvisioningPdu(meshNode, MeshManagerApi.this.applySegmentation(mtu, pdu));
        }

        @Override
        public void onMeshPduCreated(int dst, byte[] pdu) {
            ProvisionedMeshNode meshNode = MeshManagerApi.this.mMeshNetwork.getNode(dst);
            this.updateNetwork(meshNode);
            int mtu = MeshManagerApi.this.mMeshManagerCallbacks.getMtu();
            MeshManagerApi.this.mMeshManagerCallbacks.onMeshPduCreated(MeshManagerApi.this.applySegmentation(mtu, pdu));
        }

        @Override
        public ProxyFilter getProxyFilter() {
            return MeshManagerApi.this.mMeshNetwork.getProxyFilter();
        }

        @Override
        public void setProxyFilter(@NonNull ProxyFilter filter) {
            MeshManagerApi.this.mMeshNetwork.setProxyFilter(filter);
        }

        @Override
        public void updateMeshNetwork(MeshMessage message) {
            ProvisionedMeshNode meshNode = MeshManagerApi.this.mMeshNetwork.getNode(message.getSrc());
            this.updateNetwork(meshNode);
        }

        @Override
        public void onMeshNodeReset(ProvisionedMeshNode meshNode) {
            if (meshNode != null && MeshManagerApi.this.mMeshNetwork.deleteNode(meshNode)) {
                MeshManagerApi.this.deleteNode(meshNode);
            }
        }

        @Override
        public MeshNetwork getMeshNetwork() {
            return MeshManagerApi.this.mMeshNetwork;
        }

        @Override
        public void storeScene(int address, int currentScene, List<Integer> scenes) {
            Scene scene = MeshManagerApi.this.mMeshNetwork.getScene(currentScene);
            if (scene != null && !scene.getAddresses().contains(address)) {
                scene.addresses.add(address);
            }
        }

        @Override
        public void deleteScene(int address, int currentScene, List<Integer> scenes) {
            Scene scene = MeshManagerApi.this.mMeshNetwork.getScene(currentScene);
            if (scene != null && scene.getAddresses().contains(address)) {
                scene.addresses.remove((Object)address);
            }
        }

        private void updateNetwork(ProvisionedMeshNode meshNode) {
            if (meshNode != null) {
                for (int i = 0; i < ((MeshManagerApi)MeshManagerApi.this).mMeshNetwork.nodes.size(); ++i) {
                    if (meshNode.getUnicastAddress() != ((ProvisionedMeshNode)((MeshManagerApi)MeshManagerApi.this).mMeshNetwork.nodes.get(i)).getUnicastAddress()) continue;
                    ((MeshManagerApi)MeshManagerApi.this).mMeshNetwork.nodes.set(i, meshNode);
                    break;
                }
            }
            MeshManagerApi.this.mMeshNetwork.setTimestamp(System.currentTimeMillis());
            MeshManagerApi.this.mMeshNetworkDb.update(MeshManagerApi.this.mMeshNetwork, MeshManagerApi.this.mMeshNetworkDao, MeshManagerApi.this.mNetworkKeysDao, MeshManagerApi.this.mApplicationKeysDao, MeshManagerApi.this.mProvisionersDao, MeshManagerApi.this.mProvisionedNodesDao, MeshManagerApi.this.mGroupsDao, MeshManagerApi.this.mScenesDao);
            MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
        }
    };
    private final InternalMeshManagerCallbacks internalMeshMgrCallbacks = new InternalMeshManagerCallbacks(){

        @Override
        public void onNodeProvisioned(ProvisionedMeshNode meshNode) {
            this.updateProvisionedNodeList(meshNode);
            ((MeshManagerApi)MeshManagerApi.this).mMeshNetwork.sequenceNumbers.put(meshNode.getUnicastAddress(), meshNode.getSequenceNumber());
            ((MeshManagerApi)MeshManagerApi.this).mMeshNetwork.unicastAddress = MeshManagerApi.this.mMeshNetwork.nextAvailableUnicastAddress(meshNode.getNumberOfElements(), MeshManagerApi.this.mMeshNetwork.getSelectedProvisioner());
            meshNode.setMeshUuid(MeshManagerApi.this.mMeshNetwork.getMeshUUID());
            MeshManagerApi.this.mMeshNetworkDb.insert(MeshManagerApi.this.mProvisionedNodeDao, meshNode);
            MeshManagerApi.this.mMeshNetworkDb.update(MeshManagerApi.this.mProvisionerDao, MeshManagerApi.this.mMeshNetwork.getSelectedProvisioner());
            MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
        }

        private void updateProvisionedNodeList(ProvisionedMeshNode meshNode) {
            for (int i = 0; i < ((MeshManagerApi)MeshManagerApi.this).mMeshNetwork.nodes.size(); ++i) {
                ProvisionedMeshNode node = (ProvisionedMeshNode)((MeshManagerApi)MeshManagerApi.this).mMeshNetwork.nodes.get(i);
                if (!meshNode.getUuid().equals(node.getUuid())) continue;
                ((MeshManagerApi)MeshManagerApi.this).mMeshNetwork.nodes.remove(i);
                break;
            }
            ((MeshManagerApi)MeshManagerApi.this).mMeshNetwork.nodes.add(meshNode);
        }
    };
    private final NetworkLayerCallbacks networkLayerCallbacks = new NetworkLayerCallbacks(){

        @Override
        public Provisioner getProvisioner() {
            return MeshManagerApi.this.mMeshNetwork.getSelectedProvisioner();
        }

        @Override
        public Provisioner getProvisioner(int unicastAddress) {
            for (Provisioner provisioner : MeshManagerApi.this.mMeshNetwork.getProvisioners()) {
                if (!provisioner.isLastSelected()) continue;
                return provisioner;
            }
            return null;
        }

        @Override
        public NetworkKey getPrimaryNetworkKey() {
            return MeshManagerApi.this.mMeshNetwork.getPrimaryNetworkKey();
        }

        @Override
        public NetworkKey getNetworkKey(int keyIndex) {
            return MeshManagerApi.this.mMeshNetwork.getNetKey(keyIndex);
        }

        @Override
        public List<NetworkKey> getNetworkKeys() {
            return MeshManagerApi.this.mMeshNetwork.getNetKeys();
        }
    };
    private final UpperTransportLayerCallbacks upperTransportLayerCallbacks = new UpperTransportLayerCallbacks(){

        @Override
        public ProvisionedMeshNode getNode(int unicastAddress) {
            return MeshManagerApi.this.mMeshNetwork.getNode(unicastAddress);
        }

        @Override
        public byte[] getIvIndex() {
            int ivIndex = MeshManagerApi.this.mMeshNetwork.getIvIndex().getTransmitIvIndex();
            return ByteBuffer.allocate(4).putInt(ivIndex).array();
        }

        @Override
        public byte[] getApplicationKey(int aid) {
            for (ApplicationKey key : MeshManagerApi.this.mMeshNetwork.getAppKeys()) {
                byte[] k = key.getKey();
                if (aid != SecureUtils.calculateK4(k)) continue;
                return key.getKey();
            }
            return null;
        }

        @Override
        public List<ApplicationKey> getApplicationKeys(int boundNetKeyIndex) {
            ArrayList<ApplicationKey> keys = new ArrayList<ApplicationKey>();
            for (ApplicationKey key : MeshManagerApi.this.mMeshNetwork.getAppKeys()) {
                if (key.getBoundNetKeyIndex() != boundNetKeyIndex) continue;
                keys.add(key);
            }
            return keys;
        }

        @Override
        @Nullable
        public List<Group> gerVirtualGroups() {
            return MeshManagerApi.this.mMeshNetwork.getGroups();
        }
    };
    private final LoadNetworkCallbacks networkLoadCallbacks = new LoadNetworkCallbacks(){

        @Override
        public void onNetworkLoadedFromDb(MeshNetwork meshNetwork) {
            MeshNetwork network;
            if (meshNetwork == null) {
                network = MeshManagerApi.this.generateMeshNetwork();
                MeshManagerApi.this.insertNetwork(network);
            } else {
                network = meshNetwork;
                network.loadSequenceNumbers();
            }
            network.setCallbacks(MeshManagerApi.this.callbacks);
            MeshManagerApi.this.mMeshNetwork = network;
            MeshManagerApi.this.mMeshManagerCallbacks.onNetworkLoaded(network);
        }

        @Override
        public void onNetworkLoadFailed(String error) {
            MeshManagerApi.this.mMeshManagerCallbacks.onNetworkLoadFailed(error);
        }
    };
    private final MeshNetworkCallbacks callbacks = new MeshNetworkCallbacks(){

        @Override
        public void onMeshNetworkUpdated() {
            MeshManagerApi.this.mMeshNetwork.setTimestamp(System.currentTimeMillis());
            MeshManagerApi.this.mMeshNetworkDb.update(MeshManagerApi.this.mMeshNetworkDao, MeshManagerApi.this.mMeshNetwork);
            MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
        }

        @Override
        public void onNetworkKeyAdded(@NonNull NetworkKey networkKey) {
            MeshManagerApi.this.mMeshNetworkDb.insert(MeshManagerApi.this.mNetworkKeyDao, networkKey);
            MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
        }

        @Override
        public void onNetworkKeyUpdated(@NonNull NetworkKey networkKey) {
            MeshManagerApi.this.mMeshNetworkDb.update(MeshManagerApi.this.mNetworkKeyDao, networkKey);
            MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
        }

        @Override
        public void onNetworkKeyDeleted(@NonNull NetworkKey networkKey) {
            MeshManagerApi.this.mMeshNetworkDb.delete(MeshManagerApi.this.mNetworkKeyDao, networkKey);
            MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
        }

        @Override
        public void onApplicationKeyAdded(@NonNull ApplicationKey applicationKey) {
            MeshManagerApi.this.mMeshNetworkDb.insert(MeshManagerApi.this.mApplicationKeyDao, applicationKey);
            MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
        }

        @Override
        public void onApplicationKeyUpdated(@NonNull ApplicationKey applicationKey) {
            MeshManagerApi.this.mMeshNetworkDb.update(MeshManagerApi.this.mApplicationKeyDao, applicationKey);
            MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
        }

        @Override
        public void onApplicationKeyDeleted(@NonNull ApplicationKey applicationKey) {
            MeshManagerApi.this.mMeshNetworkDb.delete(MeshManagerApi.this.mApplicationKeyDao, applicationKey);
            MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
        }

        @Override
        public void onProvisionerAdded(@NonNull Provisioner provisioner) {
            MeshManagerApi.this.mMeshNetworkDb.insert(MeshManagerApi.this.mProvisionerDao, provisioner);
            MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
        }

        @Override
        public void onProvisionerUpdated(@NonNull Provisioner provisioner) {
            MeshManagerApi.this.mMeshNetworkDb.update(MeshManagerApi.this.mProvisionerDao, provisioner);
            MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
        }

        @Override
        public void onProvisionersUpdated(@NonNull List<Provisioner> provisioners) {
            MeshManagerApi.this.mMeshNetworkDb.update(MeshManagerApi.this.mProvisionerDao, provisioners);
            MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
        }

        @Override
        public void onProvisionerDeleted(@NonNull Provisioner provisioner) {
            MeshManagerApi.this.mMeshNetworkDb.delete(MeshManagerApi.this.mProvisionerDao, provisioner);
            MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
        }

        @Override
        public void onNodeDeleted(@NonNull ProvisionedMeshNode meshNode) {
            MeshManagerApi.this.deleteNode(meshNode);
        }

        @Override
        public void onNodeAdded(@NonNull ProvisionedMeshNode meshNode) {
            MeshManagerApi.this.mMeshNetworkDb.insert(MeshManagerApi.this.mProvisionedNodeDao, meshNode);
            MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
        }

        @Override
        public void onNodeUpdated(@NonNull ProvisionedMeshNode meshNode) {
            MeshManagerApi.this.mMeshNetworkDb.update(MeshManagerApi.this.mProvisionedNodeDao, meshNode);
            MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
        }

        @Override
        public void onNodesUpdated() {
            MeshManagerApi.this.mMeshNetworkDb.update(MeshManagerApi.this.mProvisionedNodesDao, ((MeshManagerApi)MeshManagerApi.this).mMeshNetwork.nodes);
            MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
        }

        @Override
        public void onGroupAdded(@NonNull Group group) {
            MeshManagerApi.this.mMeshNetworkDb.insert(MeshManagerApi.this.mGroupDao, group);
            MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
        }

        @Override
        public void onGroupUpdated(@NonNull Group group) {
            MeshManagerApi.this.mMeshNetworkDb.update(MeshManagerApi.this.mGroupDao, group);
            MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
        }

        @Override
        public void onGroupDeleted(@NonNull Group group) {
            MeshManagerApi.this.mMeshNetworkDb.delete(MeshManagerApi.this.mGroupDao, group);
            MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
        }

        @Override
        public void onSceneAdded(@NonNull Scene scene) {
            MeshManagerApi.this.mMeshNetworkDb.insert(MeshManagerApi.this.mSceneDao, scene);
            MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
        }

        @Override
        public void onSceneUpdated(@NonNull Scene scene) {
            MeshManagerApi.this.mMeshNetworkDb.update(MeshManagerApi.this.mSceneDao, scene);
            MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
        }

        @Override
        public void onSceneDeleted(@NonNull Scene scene) {
            MeshManagerApi.this.mMeshNetworkDb.delete(MeshManagerApi.this.mSceneDao, scene);
            MeshManagerApi.this.mMeshManagerCallbacks.onNetworkUpdated(MeshManagerApi.this.mMeshNetwork);
        }
    };

    public MeshManagerApi(@NonNull Context context) {
        this.mContext = context;
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mMeshProvisioningHandler = new MeshProvisioningHandler(context, this.internalTransportCallbacks, this.internalMeshMgrCallbacks);
        this.mMeshMessageHandler = new MeshMessageHandler(context, this.internalTransportCallbacks, this.networkLayerCallbacks, this.upperTransportLayerCallbacks);
        this.mImportExportUtils = new ImportExportUtils();
        this.initBouncyCastle();
        this.initDb(context);
    }

    @Override
    public void setMeshManagerCallbacks(@NonNull MeshManagerCallbacks callbacks) {
        this.mMeshManagerCallbacks = callbacks;
    }

    @Override
    public void setProvisioningStatusCallbacks(@NonNull MeshProvisioningStatusCallbacks callbacks) {
        this.mMeshProvisioningHandler.setProvisioningCallbacks(callbacks);
    }

    @Override
    public void setMeshStatusCallbacks(@NonNull MeshStatusCallbacks callbacks) {
        this.mMeshMessageHandler.setMeshStatusCallbacks(callbacks);
    }

    @Override
    public void loadMeshNetwork() {
        this.mMeshNetworkDb.loadNetwork(this.mMeshNetworkDao, this.mNetworkKeysDao, this.mApplicationKeysDao, this.mProvisionersDao, this.mProvisionedNodesDao, this.mGroupsDao, this.mScenesDao, this.networkLoadCallbacks);
    }

    @Override
    public MeshNetwork getMeshNetwork() {
        return this.mMeshNetwork;
    }

    private void initBouncyCastle() {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
    }

    public boolean isIvUpdateTestModeActive() {
        return this.ivUpdateTestModeActive;
    }

    public void setIvUpdateTestModeActive(boolean ivUpdateTestMode) {
        this.ivUpdateTestModeActive = ivUpdateTestMode;
    }

    public void allowIvIndexRecoveryOver42(boolean allowIvIndexRecoveryOver42) {
        this.allowIvIndexRecoveryOver42 = allowIvIndexRecoveryOver42;
    }

    private void initDb(Context context) {
        this.mMeshNetworkDb = MeshNetworkDb.getDatabase(context);
        this.mMeshNetworkDao = this.mMeshNetworkDb.meshNetworkDao();
        this.mNetworkKeyDao = this.mMeshNetworkDb.networkKeyDao();
        this.mNetworkKeysDao = this.mMeshNetworkDb.networkKeysDao();
        this.mApplicationKeyDao = this.mMeshNetworkDb.applicationKeyDao();
        this.mApplicationKeysDao = this.mMeshNetworkDb.applicationKeysDao();
        this.mProvisionerDao = this.mMeshNetworkDb.provisionerDao();
        this.mProvisionersDao = this.mMeshNetworkDb.provisionersDao();
        this.mProvisionedNodeDao = this.mMeshNetworkDb.provisionedMeshNodeDao();
        this.mProvisionedNodesDao = this.mMeshNetworkDb.provisionedMeshNodesDao();
        this.mGroupDao = this.mMeshNetworkDb.groupDao();
        this.mGroupsDao = this.mMeshNetworkDb.groupsDao();
        this.mSceneDao = this.mMeshNetworkDb.sceneDao();
        this.mScenesDao = this.mMeshNetworkDb.scenesDao();
    }

    private void insertNetwork(MeshNetwork meshNetwork) {
        meshNetwork.setLastSelected(true);
        if (meshNetwork.provisioners.size() == 1) {
            ((Provisioner)meshNetwork.provisioners.get(0)).setLastSelected(true);
        }
        this.mMeshNetworkDb.insertNetwork(this.mMeshNetworkDao, this.mNetworkKeysDao, this.mApplicationKeysDao, this.mProvisionersDao, this.mProvisionedNodesDao, this.mGroupsDao, this.mScenesDao, meshNetwork);
    }

    @Override
    public final void handleNotifications(int mtuSize, @NonNull byte[] data) {
        byte[] unsegmentedPdu;
        if (!this.shouldWaitForMoreData(data)) {
            unsegmentedPdu = data;
        } else {
            byte[] combinedPdu = this.appendPdu(mtuSize, data);
            if (combinedPdu == null) {
                this.toggleProxyProtocolSarTimeOut(data);
                return;
            }
            this.toggleProxyProtocolSarTimeOut(data);
            unsegmentedPdu = this.removeSegmentation(mtuSize, combinedPdu);
        }
        this.parseNotifications(unsegmentedPdu);
    }

    private void toggleProxyProtocolSarTimeOut(byte[] data) {
        int pduType = MeshParserUtils.unsignedByteToInt(data[0]);
        if (pduType == 66) {
            this.mHandler.postDelayed(this.mProxyProtocolTimeoutRunnable, 20000L);
        } else if (pduType == 194) {
            this.mHandler.removeCallbacks(this.mProxyProtocolTimeoutRunnable);
        }
    }

    private void parseNotifications(byte[] unsegmentedPdu) {
        try {
            switch (unsegmentedPdu[0]) {
                case 0: {
                    Log.v((String)TAG, (String)("Received network pdu: " + MeshParserUtils.bytesToHex(unsegmentedPdu, true)));
                    this.mMeshMessageHandler.parseMeshPduNotifications(unsegmentedPdu, this.mMeshNetwork);
                    break;
                }
                case 1: {
                    for (int i = 0; i < this.mMeshNetwork.getNetKeys().size(); ++i) {
                        NetworkKey networkKey = this.mMeshNetwork.getNetKeys().get(i);
                        byte[] receivedBeaconData = new byte[unsegmentedPdu.length - 1];
                        System.arraycopy(unsegmentedPdu, 1, receivedBeaconData, 0, receivedBeaconData.length);
                        SecureNetworkBeacon receivedBeacon = new SecureNetworkBeacon(receivedBeaconData);
                        byte[] n = networkKey.getTxNetworkKey();
                        int flags = receivedBeacon.getFlags();
                        byte[] networkId = SecureUtils.calculateK3(n);
                        int ivIndex = receivedBeacon.getIvIndex().getIvIndex();
                        Log.d((String)TAG, (String)("Received mesh beacon: " + receivedBeacon.toString()));
                        SecureNetworkBeacon localSecureNetworkBeacon = SecureUtils.createSecureNetworkBeacon(n, flags, networkId, ivIndex);
                        if (!Arrays.equals(receivedBeacon.getAuthenticationValue(), localSecureNetworkBeacon.getAuthenticationValue())) continue;
                        Log.d((String)TAG, (String)"Secure Network Beacon beacon authenticated.");
                        if (this.mMeshNetwork.getPrimaryNetworkKey() != null && networkKey.keyIndex != 0) {
                            Log.d((String)TAG, (String)("Discarding beacon for secondary subnet with network key index: " + networkKey.keyIndex));
                            return;
                        }
                        IvIndex lastIvIndex = this.mMeshNetwork.getIvIndex();
                        Log.d((String)TAG, (String)("Last IV Index: " + lastIvIndex.getIvIndex()));
                        Calendar lastTransitionDate = lastIvIndex.getTransitionDate();
                        boolean isIvRecoveryActive = lastIvIndex.getIvRecoveryFlag();
                        boolean isIvTestModeActive = this.ivUpdateTestModeActive;
                        boolean flag = this.allowIvIndexRecoveryOver42;
                        if (!receivedBeacon.canOverwrite(lastIvIndex, lastTransitionDate, isIvRecoveryActive, isIvTestModeActive, flag)) {
                            String numberOfHoursSinceDate = (Calendar.getInstance().getTimeInMillis() - lastTransitionDate.getTimeInMillis()) / 3600000L + "h";
                            Log.w((String)TAG, (String)("Discarding beacon " + receivedBeacon.getIvIndex() + ", last " + lastIvIndex.getIvIndex() + ", changed: " + numberOfHoursSinceDate + "ago, test mode: " + this.ivUpdateTestModeActive));
                            return;
                        }
                        IvIndex receivedIvIndex = receivedBeacon.getIvIndex();
                        this.mMeshNetwork.ivIndex = new IvIndex(receivedIvIndex.getIvIndex(), receivedIvIndex.isIvUpdateActive(), lastTransitionDate);
                        if (this.mMeshNetwork.ivIndex.getIvIndex() > lastIvIndex.getIvIndex()) {
                            Log.i((String)TAG, (String)("Applying: " + this.mMeshNetwork.ivIndex.getIvIndex()));
                        }
                        if (this.mMeshNetwork.ivIndex.getTransmitIvIndex() > lastIvIndex.getTransmitIvIndex()) {
                            Log.i((String)TAG, (String)"Resetting local sequence numbers to 0");
                            Provisioner provisioner = this.mMeshNetwork.getSelectedProvisioner();
                            ProvisionedMeshNode node = this.mMeshNetwork.getNode(provisioner.getProvisionerUuid());
                            node.setSequenceNumber(0);
                        }
                        if (lastIvIndex != this.mMeshNetwork.ivIndex) {
                            boolean ivRecovery = this.mMeshNetwork.getIvIndex().getIvIndex() > lastIvIndex.getIvIndex() + 1 && !receivedBeacon.getIvIndex().isIvUpdateActive();
                            this.mMeshNetwork.getIvIndex().setIvRecoveryFlag(ivRecovery);
                        }
                        if (this.mMeshNetwork.ivIndex.getIvRecoveryFlag()) continue;
                        Iterator iterator = this.mMeshNetwork.networkExclusions.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry exclusions = iterator.next();
                            int expectedIncrement = (Integer)exclusions.getKey() + 2;
                            if (this.mMeshNetwork.ivIndex.getIvIndex() < expectedIncrement) continue;
                            iterator.remove();
                        }
                    }
                    break;
                }
                case 2: {
                    Log.v((String)TAG, (String)("Received proxy configuration message: " + MeshParserUtils.bytesToHex(unsegmentedPdu, true)));
                    this.mMeshMessageHandler.parseMeshPduNotifications(unsegmentedPdu, this.mMeshNetwork);
                    break;
                }
                case 3: {
                    Log.v((String)TAG, (String)("Received provisioning message: " + MeshParserUtils.bytesToHex(unsegmentedPdu, true)));
                    this.mMeshProvisioningHandler.parseProvisioningNotifications(unsegmentedPdu);
                }
            }
        }
        catch (ExtendedInvalidCipherTextException networkKey) {
        }
        catch (IllegalArgumentException ex) {
            Log.e((String)TAG, (String)("Parsing notification failed: " + MeshParserUtils.bytesToHex(unsegmentedPdu, true) + " - " + ex.getMessage()));
        }
    }

    @Override
    public final void handleWriteCallbacks(int mtuSize, @NonNull byte[] data) {
        byte[] unsegmentedPdu;
        if (!this.shouldWaitForMoreData(data)) {
            unsegmentedPdu = data;
        } else {
            byte[] combinedPdu = this.appendWritePdu(mtuSize, data);
            if (combinedPdu == null) {
                return;
            }
            unsegmentedPdu = this.removeSegmentation(mtuSize, combinedPdu);
        }
        this.handleWriteCallbacks(unsegmentedPdu);
    }

    private void handleWriteCallbacks(byte[] data) {
        switch (data[0]) {
            case 0: {
                Log.v((String)TAG, (String)("MeshNetwork pdu sent: " + MeshParserUtils.bytesToHex(data, true)));
                break;
            }
            case 1: {
                Log.v((String)TAG, (String)("Mesh beacon pdu sent: " + MeshParserUtils.bytesToHex(data, true)));
                break;
            }
            case 2: {
                Log.v((String)TAG, (String)("Proxy configuration pdu sent: " + MeshParserUtils.bytesToHex(data, true)));
                break;
            }
            case 3: {
                Log.v((String)TAG, (String)("Provisioning pdu sent: " + MeshParserUtils.bytesToHex(data, true)));
                this.mMeshProvisioningHandler.handleProvisioningWriteCallbacks();
            }
        }
    }

    private boolean shouldWaitForMoreData(byte[] pdu) {
        int gattSar = (pdu[0] & 0xC0) >> 6;
        switch (gattSar) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private byte[] appendPdu(int mtuSize, byte[] pdu) {
        if (this.mIncomingBuffer == null) {
            int length = Math.min(pdu.length, mtuSize);
            this.mIncomingBufferOffset = 0;
            this.mIncomingBufferOffset += length;
            this.mIncomingBuffer = pdu;
        } else {
            int length = Math.min(pdu.length, mtuSize);
            byte[] buffer = new byte[this.mIncomingBuffer.length + length];
            System.arraycopy(this.mIncomingBuffer, 0, buffer, 0, this.mIncomingBufferOffset);
            System.arraycopy(pdu, 0, buffer, this.mIncomingBufferOffset, length);
            this.mIncomingBufferOffset += length;
            this.mIncomingBuffer = buffer;
            if (length < mtuSize) {
                byte[] packet = this.mIncomingBuffer;
                this.mIncomingBuffer = null;
                return packet;
            }
        }
        return null;
    }

    private byte[] appendWritePdu(int mtuSize, byte[] pdu) {
        if (this.mOutgoingBuffer == null) {
            int length = Math.min(pdu.length, mtuSize);
            this.mOutgoingBufferOffset = 0;
            this.mOutgoingBufferOffset += length;
            this.mOutgoingBuffer = pdu;
        } else {
            int length = Math.min(pdu.length, mtuSize);
            byte[] buffer = new byte[this.mOutgoingBuffer.length + length];
            System.arraycopy(this.mOutgoingBuffer, 0, buffer, 0, this.mOutgoingBufferOffset);
            System.arraycopy(pdu, 0, buffer, this.mOutgoingBufferOffset, length);
            this.mOutgoingBufferOffset += length;
            this.mOutgoingBuffer = buffer;
            if (length < mtuSize) {
                byte[] packet = this.mOutgoingBuffer;
                this.mOutgoingBuffer = null;
                return packet;
            }
        }
        return null;
    }

    private byte[] applySegmentation(int mtuSize, byte[] pdu) {
        int srcOffset = 0;
        int dstOffset = 0;
        int chunks = (pdu.length + (mtuSize - 1)) / mtuSize;
        byte pduType = pdu[0];
        if (chunks > 1) {
            byte[] segmentedBuffer = new byte[pdu.length + chunks - 1];
            for (int i = 0; i < chunks; ++i) {
                int length;
                if (i == 0) {
                    length = Math.min(pdu.length - srcOffset, mtuSize);
                    System.arraycopy(pdu, srcOffset, segmentedBuffer, dstOffset, length);
                    segmentedBuffer[0] = (byte)(0x40 | pduType);
                } else if (i == chunks - 1) {
                    length = Math.min(pdu.length - srcOffset, mtuSize);
                    segmentedBuffer[dstOffset] = (byte)(0xC0 | pduType);
                    System.arraycopy(pdu, srcOffset, segmentedBuffer, dstOffset + 1, length);
                } else {
                    length = Math.min(pdu.length - srcOffset, mtuSize - 1);
                    segmentedBuffer[dstOffset] = (byte)(0x80 | pduType);
                    System.arraycopy(pdu, srcOffset, segmentedBuffer, dstOffset + 1, length);
                }
                srcOffset += length;
                dstOffset += mtuSize;
            }
            return segmentedBuffer;
        }
        return pdu;
    }

    private byte[] removeSegmentation(int mtuSize, byte[] data) {
        int srcOffset = 0;
        int dstOffset = 0;
        int chunks = (data.length + (mtuSize - 1)) / mtuSize;
        if (chunks > 1) {
            byte[] buffer = new byte[data.length - (chunks - 1)];
            for (int i = 0; i < chunks; ++i) {
                int length = Math.min(buffer.length - dstOffset, mtuSize);
                if (i == 0) {
                    System.arraycopy(data, srcOffset, buffer, dstOffset, length);
                    buffer[0] = (byte)(buffer[0] & 0x3F);
                } else if (i == chunks - 1) {
                    System.arraycopy(data, srcOffset + 1, buffer, dstOffset, length);
                } else {
                    System.arraycopy(data, srcOffset + 1, buffer, dstOffset, --length);
                }
                srcOffset += mtuSize;
                dstOffset += length;
            }
            return buffer;
        }
        return data;
    }

    @Override
    public void identifyNode(@NonNull UUID deviceUUID) throws IllegalArgumentException {
        this.identifyNode(deviceUUID, 5);
    }

    @Override
    public void identifyNode(@NonNull UUID deviceUuid, int attentionTimer) throws IllegalArgumentException {
        NetworkKey networkKey = this.mMeshNetwork.getPrimaryNetworkKey();
        if (networkKey != null) {
            this.mMeshProvisioningHandler.identify(deviceUuid, networkKey, this.mMeshNetwork.getProvisioningFlags(), this.mMeshNetwork.getIvIndex().getIvIndex(), this.mMeshNetwork.getGlobalTtl(), attentionTimer);
        }
    }

    @Override
    public void startProvisioning(@NonNull UnprovisionedMeshNode unprovisionedMeshNode) throws IllegalArgumentException {
        if (this.isAddressValid(unprovisionedMeshNode)) {
            this.mMeshProvisioningHandler.startProvisioningNoOOB(unprovisionedMeshNode);
        }
    }

    @Override
    public void startProvisioningWithStaticOOB(@NonNull UnprovisionedMeshNode unprovisionedMeshNode) throws IllegalArgumentException {
        if (this.isAddressValid(unprovisionedMeshNode)) {
            this.mMeshProvisioningHandler.startProvisioningWithStaticOOB(unprovisionedMeshNode);
        }
    }

    @Override
    public void startProvisioningWithOutputOOB(@NonNull UnprovisionedMeshNode unprovisionedMeshNode, @NonNull OutputOOBAction oobAction) throws IllegalArgumentException {
        if (this.isAddressValid(unprovisionedMeshNode)) {
            this.mMeshProvisioningHandler.startProvisioningWithOutputOOB(unprovisionedMeshNode, oobAction);
        }
    }

    @Override
    public void startProvisioningWithInputOOB(@NonNull UnprovisionedMeshNode unprovisionedMeshNode, @NonNull InputOOBAction oobAction) throws IllegalArgumentException {
        if (this.isAddressValid(unprovisionedMeshNode)) {
            this.mMeshProvisioningHandler.startProvisioningWithInputOOB(unprovisionedMeshNode, oobAction);
        }
    }

    @Override
    public void setProvisioningAuthentication(@NonNull String authentication) {
        this.mMeshProvisioningHandler.sendProvisioningConfirmation(authentication);
    }

    @Override
    @NonNull
    public UUID getDeviceUuid(@NonNull byte[] serviceData) throws IllegalArgumentException {
        if (serviceData.length < 18) {
            throw new IllegalArgumentException("Service data cannot be null");
        }
        ByteBuffer buffer = ByteBuffer.wrap(serviceData);
        long msb = buffer.getLong();
        long lsb = buffer.getLong();
        return new UUID(msb, lsb);
    }

    @Override
    public boolean isMeshBeacon(@NonNull byte[] advertisementData) throws IllegalArgumentException {
        int length;
        for (int i = 0; i < advertisementData.length && (length = MeshParserUtils.unsignedByteToInt(advertisementData[i])) != 0; ++i) {
            int type = MeshParserUtils.unsignedByteToInt(advertisementData[i + 1]);
            if (type == 43) {
                return true;
            }
            i += length;
        }
        return false;
    }

    @Override
    @Nullable
    public byte[] getMeshBeaconData(@NonNull byte[] advertisementData) throws IllegalArgumentException {
        if (this.isMeshBeacon(advertisementData)) {
            for (int i = 0; i < advertisementData.length; ++i) {
                int length = MeshParserUtils.unsignedByteToInt(advertisementData[i]);
                int type = MeshParserUtils.unsignedByteToInt(advertisementData[i + 1]);
                if (type == 43) {
                    byte[] beaconData = new byte[length];
                    ByteBuffer buffer = ByteBuffer.wrap(advertisementData);
                    buffer.position(i + 2);
                    buffer.get(beaconData, 0, length);
                    return beaconData;
                }
                i += length;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public MeshBeacon getMeshBeacon(byte[] beaconData) {
        if (beaconData != null) {
            byte beaconType = beaconData[0];
            if (beaconType == 0) {
                return new UnprovisionedBeacon(beaconData);
            }
            if (beaconType == 1) {
                return new SecureNetworkBeacon(beaconData);
            }
        }
        return null;
    }

    @Override
    public String generateNetworkId(@NonNull byte[] networkKey) {
        return MeshParserUtils.bytesToHex(SecureUtils.calculateK3(networkKey), false);
    }

    @Override
    public boolean nodeIdentityMatches(@NonNull ProvisionedMeshNode meshNode, @NonNull byte[] serviceData) {
        byte[] advertisedHash = this.getAdvertisedHash(serviceData);
        if (advertisedHash == null) {
            return false;
        }
        byte[] random = this.getAdvertisedRandom(serviceData);
        if (random == null) {
            return false;
        }
        for (NetworkKey key : this.mMeshNetwork.netKeys) {
            if (!Arrays.equals(advertisedHash, SecureUtils.calculateHash(key.getIdentityKey(), random, MeshAddress.addressIntToBytes(meshNode.getUnicastAddress()))) && !Arrays.equals(advertisedHash, SecureUtils.calculateHash(key.getOldIdentityKey(), random, MeshAddress.addressIntToBytes(meshNode.getUnicastAddress())))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAdvertisedWithNodeIdentity(@Nullable byte[] serviceData) {
        return serviceData != null && serviceData.length == 17 && serviceData[0] == 1;
    }

    private byte[] getAdvertisedHash(byte[] serviceData) {
        if (serviceData == null) {
            return null;
        }
        ByteBuffer expectedBufferHash = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
        expectedBufferHash.put(serviceData, 1, 8);
        return expectedBufferHash.array();
    }

    private byte[] getAdvertisedRandom(byte[] serviceData) {
        if (serviceData == null || serviceData.length <= 8) {
            return null;
        }
        ByteBuffer expectedBufferHash = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
        expectedBufferHash.put(serviceData, 9, 8);
        return expectedBufferHash.array();
    }

    @Override
    public boolean networkIdMatches(@NonNull String networkId, @Nullable byte[] serviceData) {
        byte[] advertisedNetworkId = this.getAdvertisedNetworkId(serviceData);
        if (advertisedNetworkId != null) {
            String advertisedNetworkIdString = MeshParserUtils.bytesToHex(advertisedNetworkId, false).toUpperCase(Locale.US);
            return networkId.equals(advertisedNetworkIdString);
        }
        return false;
    }

    @Override
    public boolean networkIdMatches(@Nullable byte[] serviceData) {
        byte[] advertisedNetworkId = this.getAdvertisedNetworkId(serviceData);
        if (advertisedNetworkId != null) {
            for (NetworkKey key : this.mMeshNetwork.getNetKeys()) {
                if (!Arrays.equals(key.getNetworkId(), advertisedNetworkId) && !Arrays.equals(key.getOldNetworkId(), advertisedNetworkId)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAdvertisingWithNetworkIdentity(@Nullable byte[] serviceData) {
        return serviceData != null && serviceData.length == 9 && serviceData[0] == 0;
    }

    private byte[] getAdvertisedNetworkId(byte[] serviceData) {
        if (serviceData == null) {
            return null;
        }
        ByteBuffer advertisedNetworkID = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
        advertisedNetworkID.put(serviceData, 1, 8);
        return advertisedNetworkID.array();
    }

    public final void resetMeshNetwork() {
        this.ivUpdateTestModeActive = false;
        this.allowIvIndexRecoveryOver42 = false;
        MeshNetwork meshNet = this.mMeshNetwork;
        this.deleteMeshNetworkFromDb(meshNet);
        MeshNetwork newMeshNetwork = this.generateMeshNetwork();
        newMeshNetwork.setCallbacks(this.callbacks);
        this.insertNetwork(newMeshNetwork);
        this.mMeshNetwork = newMeshNetwork;
        this.mMeshManagerCallbacks.onNetworkLoaded(newMeshNetwork);
    }

    private MeshNetwork generateMeshNetwork() {
        String meshUuid = UUID.randomUUID().toString().toUpperCase(Locale.US);
        MeshNetwork network = new MeshNetwork(meshUuid);
        network.netKeys = this.generateNetKeys(meshUuid);
        network.appKeys = this.generateAppKeys(meshUuid);
        AllocatedUnicastRange unicastRange = new AllocatedUnicastRange(1, 6554);
        AllocatedGroupRange groupRange = new AllocatedGroupRange(49152, 52378);
        AllocatedSceneRange sceneRange = new AllocatedSceneRange(1, 13107);
        Provisioner provisioner = network.createProvisioner("nRF Mesh Provisioner", unicastRange, groupRange, sceneRange);
        int unicast = provisioner.getAllocatedUnicastRanges().get(0).getLowAddress();
        provisioner.assignProvisionerAddress(unicast);
        network.selectProvisioner(provisioner);
        network.addProvisioner(provisioner);
        ProvisionedMeshNode node = network.getNode(unicast);
        network.unicastAddress = node != null ? node.getUnicastAddress() + (node.getNumberOfElements() - 1) : 1;
        network.lastSelected = true;
        network.sequenceNumbers.clear();
        network.loadSequenceNumbers();
        this.ivUpdateTestModeActive = false;
        this.allowIvIndexRecoveryOver42 = false;
        return network;
    }

    private List<NetworkKey> generateNetKeys(String meshUuid) {
        ArrayList<NetworkKey> networkKeys = new ArrayList<NetworkKey>();
        NetworkKey networkKey = new NetworkKey(0, SecureUtils.generateRandomNumber());
        networkKey.setMeshUuid(meshUuid);
        networkKeys.add(networkKey);
        return networkKeys;
    }

    private List<ApplicationKey> generateAppKeys(String meshUuid) {
        ArrayList<ApplicationKey> appKeys = new ArrayList<ApplicationKey>();
        for (int i = 0; i < 3; ++i) {
            ApplicationKey appKey = new ApplicationKey(i, SecureUtils.generateRandomNumber());
            appKey.setMeshUuid(meshUuid);
            appKeys.add(appKey);
        }
        return appKeys;
    }

    public final void deleteMeshNetworkFromDb(MeshNetwork meshNetwork) {
        this.mMeshNetworkDb.delete(this.mMeshNetworkDao, meshNetwork);
    }

    @Override
    public void createMeshPdu(int dst, @NonNull MeshMessage meshMessage) {
        UUID label;
        if (!MeshAddress.isAddressInRange(dst)) {
            throw new IllegalArgumentException("Invalid address, destination address must be a valid 16-bit value.");
        }
        Provisioner provisioner = this.mMeshNetwork.getSelectedProvisioner();
        if (provisioner != null && provisioner.getProvisionerAddress() != null) {
            label = null;
            if (MeshAddress.isValidVirtualAddress(dst) && (label = this.mMeshNetwork.getLabelUuid(dst)) == null) {
                throw new IllegalArgumentException("Label UUID unavailable for the virtual address provided");
            }
        } else {
            throw new IllegalArgumentException("Provisioner address not set, please assign an address to the provisioner.");
        }
        this.mMeshMessageHandler.createMeshMessage(provisioner.getProvisionerAddress(), dst, label, meshMessage);
    }

    @Override
    public String exportMeshNetwork() {
        try {
            MeshNetwork meshNetwork = this.mMeshNetwork;
            return this.mImportExportUtils.export(meshNetwork, false);
        }
        catch (Exception ex) {
            this.mMeshManagerCallbacks.onNetworkImportFailed(ex.getMessage());
            return null;
        }
    }

    @Override
    public String exportMeshNetwork(@NonNull NetworkKeysConfig networkKeysConfig, @NonNull ApplicationKeysConfig applicationKeysConfig, @NonNull NodesConfig nodesConfig, @NonNull ProvisionersConfig provisionersConfig, @NonNull GroupsConfig groupsConfig, @NonNull ScenesConfig scenesConfig) {
        try {
            MeshNetwork network = this.mMeshNetwork;
            return this.mImportExportUtils.export(network, networkKeysConfig, applicationKeysConfig, nodesConfig, provisionersConfig, groupsConfig, scenesConfig);
        }
        catch (Exception ex) {
            this.mMeshManagerCallbacks.onNetworkImportFailed(ex.getMessage());
            return null;
        }
    }

    @Override
    public void importMeshNetwork(@NonNull Uri uri) {
        try {
            this.importMeshNetworkJson(this.mImportExportUtils.readJsonStringFromUri(this.mContext.getContentResolver(), uri));
        }
        catch (Exception ex) {
            this.mMeshManagerCallbacks.onNetworkImportFailed(ex.getMessage());
        }
    }

    @Override
    public void importMeshNetworkJson(@NonNull String networkJson) {
        try {
            MeshNetwork meshNetwork = this.mImportExportUtils.importNetwork(networkJson);
            meshNetwork.setCallbacks(this.callbacks);
            this.insertNetwork(meshNetwork);
            this.mMeshNetwork = meshNetwork;
            this.mMeshManagerCallbacks.onNetworkImported(meshNetwork);
        }
        catch (Exception ex) {
            this.mMeshManagerCallbacks.onNetworkImportFailed(ex.getMessage());
        }
    }

    private void deleteSceneAddress(int address) {
        for (Scene scene : this.mMeshNetwork.getScenes()) {
            if (!scene.addresses.remove((Object)address)) continue;
            Log.d((String)TAG, (String)("Node removed from " + scene.getName()));
        }
    }

    private void deleteNode(@NonNull ProvisionedMeshNode meshNode) {
        this.deleteSceneAddress(meshNode.getUnicastAddress());
        this.mMeshMessageHandler.resetState(meshNode.getUnicastAddress());
        this.mMeshNetworkDb.deleteNode(this.mProvisionedNodeDao, meshNode);
        this.mMeshManagerCallbacks.onNetworkUpdated(this.mMeshNetwork);
    }

    private boolean isAddressValid(@NonNull UnprovisionedMeshNode node) {
        int unicast = this.mMeshNetwork.nextAvailableUnicastAddress(node.getNumberOfElements(), this.mMeshNetwork.getSelectedProvisioner());
        if (!MeshAddress.isValidUnicastAddress(unicast)) {
            throw new IllegalArgumentException("Invalid address");
        }
        if (!this.mMeshNetwork.getSelectedProvisioner().isAddressWithinAllocatedRange(this.mMeshNetwork.getUnicastAddress())) {
            throw new IllegalArgumentException("Address assigned to node is outside of provisioner's allocated unicast range.");
        }
        node.setUnicastAddress(this.mMeshNetwork.getUnicastAddress());
        return true;
    }
}

