/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.data;

import android.database.Cursor;
import android.util.SparseIntArray;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import no.nordicsemi.android.mesh.IvIndex;
import no.nordicsemi.android.mesh.MeshNetwork;
import no.nordicsemi.android.mesh.MeshTypeConverters;
import no.nordicsemi.android.mesh.data.MeshNetworkDao;

public final class MeshNetworkDao_Impl
implements MeshNetworkDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<MeshNetwork> __insertionAdapterOfMeshNetwork;
    private final EntityDeletionOrUpdateAdapter<MeshNetwork> __deletionAdapterOfMeshNetwork;
    private final EntityDeletionOrUpdateAdapter<MeshNetwork> __updateAdapterOfMeshNetwork;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public MeshNetworkDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfMeshNetwork = new EntityInsertionAdapter<MeshNetwork>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `mesh_network` (`mesh_uuid`,`mesh_name`,`timestamp`,`partial`,`iv_index`,`last_selected`,`sequence_numbers`,`networkExclusions`) VALUES (?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, MeshNetwork value) {
                if (value.getMeshUUID() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMeshUUID());
                }
                if (value.getMeshName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMeshName());
                }
                stmt.bindLong(3, value.getTimestamp());
                int _tmp = value.isPartial() ? 1 : 0;
                stmt.bindLong(4, (long)_tmp);
                String _tmp_1 = MeshTypeConverters.ivIndexToJson(value.getIvIndex());
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_1);
                }
                int _tmp_2 = value.isLastSelected() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp_2);
                String _tmp_3 = MeshTypeConverters.sparseIntArrayToJson(value.getSequenceNumbers());
                if (_tmp_3 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_3);
                }
                String _tmp_4 = MeshTypeConverters.networkExclusionsToJson(value.getNetworkExclusions());
                if (_tmp_4 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_4);
                }
            }
        };
        this.__deletionAdapterOfMeshNetwork = new EntityDeletionOrUpdateAdapter<MeshNetwork>(__db){

            public String createQuery() {
                return "DELETE FROM `mesh_network` WHERE `mesh_uuid` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, MeshNetwork value) {
                if (value.getMeshUUID() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMeshUUID());
                }
            }
        };
        this.__updateAdapterOfMeshNetwork = new EntityDeletionOrUpdateAdapter<MeshNetwork>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `mesh_network` SET `mesh_uuid` = ?,`mesh_name` = ?,`timestamp` = ?,`partial` = ?,`iv_index` = ?,`last_selected` = ?,`sequence_numbers` = ?,`networkExclusions` = ? WHERE `mesh_uuid` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, MeshNetwork value) {
                if (value.getMeshUUID() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMeshUUID());
                }
                if (value.getMeshName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMeshName());
                }
                stmt.bindLong(3, value.getTimestamp());
                int _tmp = value.isPartial() ? 1 : 0;
                stmt.bindLong(4, (long)_tmp);
                String _tmp_1 = MeshTypeConverters.ivIndexToJson(value.getIvIndex());
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_1);
                }
                int _tmp_2 = value.isLastSelected() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp_2);
                String _tmp_3 = MeshTypeConverters.sparseIntArrayToJson(value.getSequenceNumbers());
                if (_tmp_3 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_3);
                }
                String _tmp_4 = MeshTypeConverters.networkExclusionsToJson(value.getNetworkExclusions());
                if (_tmp_4 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_4);
                }
                if (value.getMeshUUID() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getMeshUUID());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM mesh_network";
                return "DELETE FROM mesh_network";
            }
        };
    }

    @Override
    public void insert(MeshNetwork meshNetwork) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfMeshNetwork.insert((Object)meshNetwork);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(MeshNetwork meshNetwork) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfMeshNetwork.handle((Object)meshNetwork);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(MeshNetwork meshNetwork) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfMeshNetwork.handle((Object)meshNetwork);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MeshNetwork> getAllMeshNetworks() {
        String _sql = "SELECT * from mesh_network";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from mesh_network", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfMeshUUID = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mesh_uuid");
            int _cursorIndexOfMeshName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mesh_name");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            int _cursorIndexOfPartial = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"partial");
            int _cursorIndexOfIvIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iv_index");
            int _cursorIndexOfLastSelected = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_selected");
            int _cursorIndexOfSequenceNumbers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sequence_numbers");
            int _cursorIndexOfNetworkExclusions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"networkExclusions");
            ArrayList<MeshNetwork> _result = new ArrayList<MeshNetwork>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpMeshUUID = _cursor.isNull(_cursorIndexOfMeshUUID) ? null : _cursor.getString(_cursorIndexOfMeshUUID);
                MeshNetwork _item = new MeshNetwork(_tmpMeshUUID);
                String _tmpMeshName = _cursor.isNull(_cursorIndexOfMeshName) ? null : _cursor.getString(_cursorIndexOfMeshName);
                _item.setMeshName(_tmpMeshName);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                int _tmp = _cursor.getInt(_cursorIndexOfPartial);
                boolean _tmpPartial = _tmp != 0;
                _item.setPartial(_tmpPartial);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfIvIndex) ? null : _cursor.getString(_cursorIndexOfIvIndex);
                IvIndex _tmpIvIndex = MeshTypeConverters.fromJsonToIvIndex(_tmp_1);
                _item.setIvIndex(_tmpIvIndex);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfLastSelected);
                boolean _tmpLastSelected = _tmp_2 != 0;
                _item.setLastSelected(_tmpLastSelected);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfSequenceNumbers) ? null : _cursor.getString(_cursorIndexOfSequenceNumbers);
                SparseIntArray _tmpSequenceNumbers = MeshTypeConverters.fromJsonToSparseIntArray(_tmp_3);
                _item.setSequenceNumbers(_tmpSequenceNumbers);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfNetworkExclusions) ? null : _cursor.getString(_cursorIndexOfNetworkExclusions);
                Map<Integer, ArrayList<Integer>> _tmpNetworkExclusions = MeshTypeConverters.fromJsonToNetworkExclusions(_tmp_4);
                _item.setNetworkExclusions((Map)_tmpNetworkExclusions);
                _result.add(_item);
            }
            ArrayList<MeshNetwork> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MeshNetwork getMeshNetwork(boolean lastSelected) {
        String _sql = "SELECT * from mesh_network WHERE last_selected IS ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from mesh_network WHERE last_selected IS ?", (int)1);
        int _argIndex = 1;
        int _tmp = lastSelected ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            MeshNetwork _result;
            int _cursorIndexOfMeshUUID = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mesh_uuid");
            int _cursorIndexOfMeshName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mesh_name");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            int _cursorIndexOfPartial = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"partial");
            int _cursorIndexOfIvIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iv_index");
            int _cursorIndexOfLastSelected = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_selected");
            int _cursorIndexOfSequenceNumbers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sequence_numbers");
            int _cursorIndexOfNetworkExclusions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"networkExclusions");
            if (_cursor.moveToFirst()) {
                String _tmpMeshUUID = _cursor.isNull(_cursorIndexOfMeshUUID) ? null : _cursor.getString(_cursorIndexOfMeshUUID);
                _result = new MeshNetwork(_tmpMeshUUID);
                String _tmpMeshName = _cursor.isNull(_cursorIndexOfMeshName) ? null : _cursor.getString(_cursorIndexOfMeshName);
                _result.setMeshName(_tmpMeshName);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _result.setTimestamp(_tmpTimestamp);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfPartial);
                boolean _tmpPartial = _tmp_1 != 0;
                _result.setPartial(_tmpPartial);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfIvIndex) ? null : _cursor.getString(_cursorIndexOfIvIndex);
                IvIndex _tmpIvIndex = MeshTypeConverters.fromJsonToIvIndex(_tmp_2);
                _result.setIvIndex(_tmpIvIndex);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfLastSelected);
                boolean _tmpLastSelected = _tmp_3 != 0;
                _result.setLastSelected(_tmpLastSelected);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfSequenceNumbers) ? null : _cursor.getString(_cursorIndexOfSequenceNumbers);
                SparseIntArray _tmpSequenceNumbers = MeshTypeConverters.fromJsonToSparseIntArray(_tmp_4);
                _result.setSequenceNumbers(_tmpSequenceNumbers);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfNetworkExclusions) ? null : _cursor.getString(_cursorIndexOfNetworkExclusions);
                Map<Integer, ArrayList<Integer>> _tmpNetworkExclusions = MeshTypeConverters.fromJsonToNetworkExclusions(_tmp_5);
                _result.setNetworkExclusions((Map)_tmpNetworkExclusions);
            } else {
                _result = null;
            }
            MeshNetwork meshNetwork = _result;
            return meshNetwork;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

