/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.data;

import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.Collections;
import java.util.List;
import no.nordicsemi.android.mesh.Features;
import no.nordicsemi.android.mesh.MeshTypeConverters;
import no.nordicsemi.android.mesh.data.ProvisionedMeshNodeDao;
import no.nordicsemi.android.mesh.transport.ProvisionedMeshNode;
import no.nordicsemi.android.mesh.utils.NetworkTransmitSettings;
import no.nordicsemi.android.mesh.utils.RelaySettings;

public final class ProvisionedMeshNodeDao_Impl
implements ProvisionedMeshNodeDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ProvisionedMeshNode> __insertionAdapterOfProvisionedMeshNode;
    private final EntityDeletionOrUpdateAdapter<ProvisionedMeshNode> __deletionAdapterOfProvisionedMeshNode;
    private final EntityDeletionOrUpdateAdapter<ProvisionedMeshNode> __updateAdapterOfProvisionedMeshNode;

    public ProvisionedMeshNodeDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfProvisionedMeshNode = new EntityInsertionAdapter<ProvisionedMeshNode>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `nodes` (`timestamp`,`name`,`ttl`,`secureNetworkBeacon`,`mesh_uuid`,`uuid`,`security`,`unicast_address`,`configured`,`device_key`,`seq_number`,`cid`,`pid`,`vid`,`crpl`,`netKeys`,`appKeys`,`elements`,`excluded`,`networkTransmitCount`,`networkIntervalSteps`,`relayTransmitCount`,`relayIntervalSteps`,`friend`,`lowPower`,`proxy`,`relay`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ProvisionedMeshNode value) {
                Integer _tmp;
                stmt.bindLong(1, value.mTimeStampInMillis);
                if (value.getNodeName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getNodeName());
                }
                if (value.getTtl() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindLong(3, (long)value.getTtl().intValue());
                }
                Integer n = value.isSecureNetworkBeaconSupported() == null ? null : (_tmp = Integer.valueOf(value.isSecureNetworkBeaconSupported() != false ? 1 : 0));
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, (long)_tmp.intValue());
                }
                if (value.getMeshUuid() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getMeshUuid());
                }
                if (value.getUuid() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getUuid());
                }
                stmt.bindLong(7, (long)value.getSecurity());
                stmt.bindLong(8, (long)value.getUnicastAddress());
                int _tmp_1 = value.isConfigured() ? 1 : 0;
                stmt.bindLong(9, (long)_tmp_1);
                if (value.getDeviceKey() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindBlob(10, value.getDeviceKey());
                }
                stmt.bindLong(11, (long)value.getSequenceNumber());
                if (value.getCompanyIdentifier() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindLong(12, (long)value.getCompanyIdentifier().intValue());
                }
                if (value.getProductIdentifier() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindLong(13, (long)value.getProductIdentifier().intValue());
                }
                if (value.getVersionIdentifier() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindLong(14, (long)value.getVersionIdentifier().intValue());
                }
                if (value.getCrpl() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindLong(15, (long)value.getCrpl().intValue());
                }
                String _tmp_2 = MeshTypeConverters.nodeKeysToJson(value.getAddedNetKeys());
                if (_tmp_2 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_2);
                }
                String _tmp_3 = MeshTypeConverters.nodeKeysToJson(value.getAddedAppKeys());
                if (_tmp_3 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_3);
                }
                String _tmp_4 = MeshTypeConverters.elementsToJson(value.getElements());
                if (_tmp_4 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_4);
                }
                int _tmp_5 = value.isExcluded() ? 1 : 0;
                stmt.bindLong(19, (long)_tmp_5);
                NetworkTransmitSettings _tmpNetworkTransmitSettings = value.getNetworkTransmitSettings();
                if (_tmpNetworkTransmitSettings != null) {
                    stmt.bindLong(20, (long)_tmpNetworkTransmitSettings.getNetworkTransmitCount());
                    stmt.bindLong(21, (long)_tmpNetworkTransmitSettings.getNetworkIntervalSteps());
                } else {
                    stmt.bindNull(20);
                    stmt.bindNull(21);
                }
                RelaySettings _tmpRelaySettings = value.getRelaySettings();
                if (_tmpRelaySettings != null) {
                    stmt.bindLong(22, (long)_tmpRelaySettings.getRelayTransmitCount());
                    stmt.bindLong(23, (long)_tmpRelaySettings.getRelayIntervalSteps());
                } else {
                    stmt.bindNull(22);
                    stmt.bindNull(23);
                }
                Features _tmpNodeFeatures = value.getNodeFeatures();
                if (_tmpNodeFeatures != null) {
                    stmt.bindLong(24, (long)_tmpNodeFeatures.getFriend());
                    stmt.bindLong(25, (long)_tmpNodeFeatures.getLowPower());
                    stmt.bindLong(26, (long)_tmpNodeFeatures.getProxy());
                    stmt.bindLong(27, (long)_tmpNodeFeatures.getRelay());
                } else {
                    stmt.bindNull(24);
                    stmt.bindNull(25);
                    stmt.bindNull(26);
                    stmt.bindNull(27);
                }
            }
        };
        this.__deletionAdapterOfProvisionedMeshNode = new EntityDeletionOrUpdateAdapter<ProvisionedMeshNode>(__db){

            public String createQuery() {
                return "DELETE FROM `nodes` WHERE `uuid` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ProvisionedMeshNode value) {
                if (value.getUuid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUuid());
                }
            }
        };
        this.__updateAdapterOfProvisionedMeshNode = new EntityDeletionOrUpdateAdapter<ProvisionedMeshNode>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `nodes` SET `timestamp` = ?,`name` = ?,`ttl` = ?,`secureNetworkBeacon` = ?,`mesh_uuid` = ?,`uuid` = ?,`security` = ?,`unicast_address` = ?,`configured` = ?,`device_key` = ?,`seq_number` = ?,`cid` = ?,`pid` = ?,`vid` = ?,`crpl` = ?,`netKeys` = ?,`appKeys` = ?,`elements` = ?,`excluded` = ?,`networkTransmitCount` = ?,`networkIntervalSteps` = ?,`relayTransmitCount` = ?,`relayIntervalSteps` = ?,`friend` = ?,`lowPower` = ?,`proxy` = ?,`relay` = ? WHERE `uuid` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ProvisionedMeshNode value) {
                Integer _tmp;
                stmt.bindLong(1, value.mTimeStampInMillis);
                if (value.getNodeName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getNodeName());
                }
                if (value.getTtl() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindLong(3, (long)value.getTtl().intValue());
                }
                Integer n = value.isSecureNetworkBeaconSupported() == null ? null : (_tmp = Integer.valueOf(value.isSecureNetworkBeaconSupported() != false ? 1 : 0));
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, (long)_tmp.intValue());
                }
                if (value.getMeshUuid() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getMeshUuid());
                }
                if (value.getUuid() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getUuid());
                }
                stmt.bindLong(7, (long)value.getSecurity());
                stmt.bindLong(8, (long)value.getUnicastAddress());
                int _tmp_1 = value.isConfigured() ? 1 : 0;
                stmt.bindLong(9, (long)_tmp_1);
                if (value.getDeviceKey() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindBlob(10, value.getDeviceKey());
                }
                stmt.bindLong(11, (long)value.getSequenceNumber());
                if (value.getCompanyIdentifier() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindLong(12, (long)value.getCompanyIdentifier().intValue());
                }
                if (value.getProductIdentifier() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindLong(13, (long)value.getProductIdentifier().intValue());
                }
                if (value.getVersionIdentifier() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindLong(14, (long)value.getVersionIdentifier().intValue());
                }
                if (value.getCrpl() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindLong(15, (long)value.getCrpl().intValue());
                }
                String _tmp_2 = MeshTypeConverters.nodeKeysToJson(value.getAddedNetKeys());
                if (_tmp_2 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_2);
                }
                String _tmp_3 = MeshTypeConverters.nodeKeysToJson(value.getAddedAppKeys());
                if (_tmp_3 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_3);
                }
                String _tmp_4 = MeshTypeConverters.elementsToJson(value.getElements());
                if (_tmp_4 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_4);
                }
                int _tmp_5 = value.isExcluded() ? 1 : 0;
                stmt.bindLong(19, (long)_tmp_5);
                NetworkTransmitSettings _tmpNetworkTransmitSettings = value.getNetworkTransmitSettings();
                if (_tmpNetworkTransmitSettings != null) {
                    stmt.bindLong(20, (long)_tmpNetworkTransmitSettings.getNetworkTransmitCount());
                    stmt.bindLong(21, (long)_tmpNetworkTransmitSettings.getNetworkIntervalSteps());
                } else {
                    stmt.bindNull(20);
                    stmt.bindNull(21);
                }
                RelaySettings _tmpRelaySettings = value.getRelaySettings();
                if (_tmpRelaySettings != null) {
                    stmt.bindLong(22, (long)_tmpRelaySettings.getRelayTransmitCount());
                    stmt.bindLong(23, (long)_tmpRelaySettings.getRelayIntervalSteps());
                } else {
                    stmt.bindNull(22);
                    stmt.bindNull(23);
                }
                Features _tmpNodeFeatures = value.getNodeFeatures();
                if (_tmpNodeFeatures != null) {
                    stmt.bindLong(24, (long)_tmpNodeFeatures.getFriend());
                    stmt.bindLong(25, (long)_tmpNodeFeatures.getLowPower());
                    stmt.bindLong(26, (long)_tmpNodeFeatures.getProxy());
                    stmt.bindLong(27, (long)_tmpNodeFeatures.getRelay());
                } else {
                    stmt.bindNull(24);
                    stmt.bindNull(25);
                    stmt.bindNull(26);
                    stmt.bindNull(27);
                }
                if (value.getUuid() == null) {
                    stmt.bindNull(28);
                } else {
                    stmt.bindString(28, value.getUuid());
                }
            }
        };
    }

    @Override
    public void insert(ProvisionedMeshNode provisionedMeshNode) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfProvisionedMeshNode.insert((Object)provisionedMeshNode);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(ProvisionedMeshNode meshNode) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfProvisionedMeshNode.handle((Object)meshNode);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(ProvisionedMeshNode meshNode) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfProvisionedMeshNode.handle((Object)meshNode);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

