/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.provisionerstates;

import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.InternalTransportCallbacks;
import no.nordicsemi.android.mesh.MeshProvisioningStatusCallbacks;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningState;
import no.nordicsemi.android.mesh.provisionerstates.UnprovisionedMeshNode;

public class ProvisioningInviteState
extends ProvisioningState {
    private final String TAG = ProvisioningInviteState.class.getSimpleName();
    private final UnprovisionedMeshNode mUnprovisionedMeshNode;
    private final int attentionTimer;
    private final MeshProvisioningStatusCallbacks mStatusCallbacks;
    private final InternalTransportCallbacks mInternalTransportCallbacks;

    public ProvisioningInviteState(UnprovisionedMeshNode unprovisionedMeshNode, int attentionTimer, InternalTransportCallbacks mInternalTransportCallbacks, MeshProvisioningStatusCallbacks meshProvisioningStatusCallbacks) {
        this.mUnprovisionedMeshNode = unprovisionedMeshNode;
        this.attentionTimer = attentionTimer;
        this.mStatusCallbacks = meshProvisioningStatusCallbacks;
        this.mInternalTransportCallbacks = mInternalTransportCallbacks;
    }

    @Override
    public ProvisioningState.State getState() {
        return ProvisioningState.State.PROVISIONING_INVITE;
    }

    @Override
    public void executeSend() {
        byte[] invitePDU = this.createInvitePDU();
        this.mUnprovisionedMeshNode.setProvisioningInvitePdu(invitePDU);
        this.mStatusCallbacks.onProvisioningStateChanged(this.mUnprovisionedMeshNode, ProvisioningState.States.PROVISIONING_INVITE, invitePDU);
        this.mInternalTransportCallbacks.sendProvisioningPdu(this.mUnprovisionedMeshNode, invitePDU);
    }

    @Override
    public boolean parseData(@NonNull byte[] data) {
        return true;
    }

    private byte[] createInvitePDU() {
        byte[] data = new byte[]{3, 0, (byte)this.attentionTimer};
        return data;
    }
}

