/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.util.Log;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.Scene;
import no.nordicsemi.android.mesh.transport.GenericMessage;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public class SceneStore
extends GenericMessage {
    private static final String TAG = SceneStore.class.getSimpleName();
    private static final int OP_CODE = 33350;
    private static final int SCENE_STORE_PARAMS_LENGTH = 2;
    private int mSceneNumber;

    public SceneStore(@NonNull ApplicationKey appKey, int sceneNumber) {
        super(appKey);
        if (Scene.isValidSceneNumber(sceneNumber)) {
            this.mSceneNumber = sceneNumber;
        }
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 33350;
    }

    @Override
    void assembleMessageParameters() {
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        Log.v((String)TAG, (String)("Scene Number: " + this.mSceneNumber));
        ByteBuffer paramsBuffer = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
        paramsBuffer.putShort((short)this.mSceneNumber);
        this.mParameters = paramsBuffer.array();
    }
}

