/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.room.ColumnInfo;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;
import com.google.gson.annotations.Expose;
import java.util.Arrays;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.NetworkKey;

abstract class MeshKey
implements Parcelable,
Cloneable {
    @PrimaryKey(autoGenerate=true)
    protected int id;
    @Expose
    @ColumnInfo(name="mesh_uuid")
    protected String meshUuid;
    @Expose
    @ColumnInfo(name="index")
    protected int keyIndex;
    @Expose
    @ColumnInfo(name="name")
    protected String name;
    @Expose
    @ColumnInfo(name="key")
    protected byte[] key;
    @Expose
    @ColumnInfo(name="old_key")
    protected byte[] oldKey;

    @Ignore
    MeshKey() {
    }

    @Ignore
    MeshKey(int keyIndex, @NonNull byte[] key) {
        this.keyIndex = keyIndex;
        if (key.length != 16) {
            throw new IllegalArgumentException("Application key must be 16-bytes");
        }
        this.key = key;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int getId() {
        return this.id;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setId(int id) {
        this.id = id;
    }

    public String getMeshUuid() {
        return this.meshUuid;
    }

    public void setMeshUuid(String meshUuid) {
        this.meshUuid = meshUuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(@NonNull String name) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Name cannot be empty!");
        }
        this.name = name;
    }

    public byte[] getKey() {
        return this.key;
    }

    public void setKey(@NonNull byte[] key) {
        if (this.valid(key)) {
            this.key = key;
        }
    }

    public int getKeyIndex() {
        return this.keyIndex;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setKeyIndex(int keyIndex) {
        this.keyIndex = keyIndex;
    }

    public byte[] getOldKey() {
        return this.oldKey;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setOldKey(byte[] oldKey) {
        this.oldKey = oldKey;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ApplicationKey) {
            ApplicationKey appKey = (ApplicationKey)obj;
            return Arrays.equals(this.key, appKey.key) && this.keyIndex == appKey.keyIndex;
        }
        if (obj instanceof NetworkKey) {
            NetworkKey netKey = (NetworkKey)obj;
            return Arrays.equals(this.key, netKey.key) && this.keyIndex == netKey.keyIndex;
        }
        return false;
    }

    @NonNull
    public MeshKey clone() throws CloneNotSupportedException {
        return (MeshKey)super.clone();
    }

    protected boolean valid(@NonNull byte[] key) {
        if (key.length != 16) {
            throw new IllegalArgumentException("Key must be of length 16!");
        }
        return true;
    }

    protected boolean distributeKey(@NonNull byte[] key) {
        if (!Arrays.equals(this.key, this.oldKey)) {
            this.setOldKey(this.key);
        }
        this.setKey(key);
        return true;
    }
}

