/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.data;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import no.nordicsemi.android.mesh.NetworkKey;
import no.nordicsemi.android.mesh.data.NetworkKeysDao;

public final class NetworkKeysDao_Impl
implements NetworkKeysDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<NetworkKey> __insertionAdapterOfNetworkKey;
    private final EntityDeletionOrUpdateAdapter<NetworkKey> __updateAdapterOfNetworkKey;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public NetworkKeysDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfNetworkKey = new EntityInsertionAdapter<NetworkKey>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `network_key` (`id`,`mesh_uuid`,`index`,`name`,`key`,`old_key`,`phase`,`security`,`timestamp`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, NetworkKey value) {
                stmt.bindLong(1, (long)value.getId());
                if (value.getMeshUuid() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMeshUuid());
                }
                stmt.bindLong(3, (long)value.getKeyIndex());
                if (value.getName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getName());
                }
                if (value.getKey() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindBlob(5, value.getKey());
                }
                if (value.getOldKey() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindBlob(6, value.getOldKey());
                }
                stmt.bindLong(7, (long)value.getPhase());
                int _tmp = value.isMinSecurity() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp);
                stmt.bindLong(9, value.getTimestamp());
            }
        };
        this.__updateAdapterOfNetworkKey = new EntityDeletionOrUpdateAdapter<NetworkKey>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `network_key` SET `id` = ?,`mesh_uuid` = ?,`index` = ?,`name` = ?,`key` = ?,`old_key` = ?,`phase` = ?,`security` = ?,`timestamp` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, NetworkKey value) {
                stmt.bindLong(1, (long)value.getId());
                if (value.getMeshUuid() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMeshUuid());
                }
                stmt.bindLong(3, (long)value.getKeyIndex());
                if (value.getName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getName());
                }
                if (value.getKey() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindBlob(5, value.getKey());
                }
                if (value.getOldKey() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindBlob(6, value.getOldKey());
                }
                stmt.bindLong(7, (long)value.getPhase());
                int _tmp = value.isMinSecurity() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp);
                stmt.bindLong(9, value.getTimestamp());
                stmt.bindLong(10, (long)value.getId());
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM network_key";
                return "DELETE FROM network_key";
            }
        };
    }

    @Override
    public void insert(NetworkKey ... networkKeys) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfNetworkKey.insert((Object[])networkKeys);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<NetworkKey> networkKeys) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfNetworkKey.insert(networkKeys);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(List<NetworkKey> netKeys) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfNetworkKey.handleMultiple(netKeys);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NetworkKey> loadNetworkKeys(String meshUuid) {
        String _sql = "SELECT * from network_key WHERE mesh_uuid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from network_key WHERE mesh_uuid = ?", (int)1);
        int _argIndex = 1;
        if (meshUuid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, meshUuid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfMeshUuid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mesh_uuid");
            int _cursorIndexOfKeyIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"index");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"key");
            int _cursorIndexOfOldKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"old_key");
            int _cursorIndexOfPhase = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phase");
            int _cursorIndexOfMinSecurity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"security");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<NetworkKey> _result = new ArrayList<NetworkKey>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                int _tmpKeyIndex = _cursor.getInt(_cursorIndexOfKeyIndex);
                byte[] _tmpKey = _cursor.isNull(_cursorIndexOfKey) ? null : _cursor.getBlob(_cursorIndexOfKey);
                NetworkKey _item = new NetworkKey(_tmpKeyIndex, _tmpKey);
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpMeshUuid = _cursor.isNull(_cursorIndexOfMeshUuid) ? null : _cursor.getString(_cursorIndexOfMeshUuid);
                _item.setMeshUuid(_tmpMeshUuid);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                _item.setName(_tmpName);
                byte[] _tmpOldKey = _cursor.isNull(_cursorIndexOfOldKey) ? null : _cursor.getBlob(_cursorIndexOfOldKey);
                _item.setOldKey(_tmpOldKey);
                int _tmpPhase = _cursor.getInt(_cursorIndexOfPhase);
                _item.setPhase(_tmpPhase);
                int _tmp = _cursor.getInt(_cursorIndexOfMinSecurity);
                boolean _tmpMinSecurity = _tmp != 0;
                _item.setMinSecurity(_tmpMinSecurity);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<NetworkKey> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

