/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.provisionerstates;

import android.util.Log;
import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.InternalTransportCallbacks;
import no.nordicsemi.android.mesh.MeshProvisioningStatusCallbacks;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningState;
import no.nordicsemi.android.mesh.provisionerstates.UnprovisionedMeshNode;
import no.nordicsemi.android.mesh.utils.AlgorithmType;
import no.nordicsemi.android.mesh.utils.AuthenticationOOBMethods;
import no.nordicsemi.android.mesh.utils.InputOOBAction;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;
import no.nordicsemi.android.mesh.utils.OutputOOBAction;
import no.nordicsemi.android.mesh.utils.StaticOOBType;

public class ProvisioningStartState
extends ProvisioningState {
    private final String TAG = ProvisioningStartState.class.getSimpleName();
    private final UnprovisionedMeshNode mNode;
    private final MeshProvisioningStatusCallbacks mMeshProvisioningStatusCallbacks;
    private final InternalTransportCallbacks mInternalTransportCallbacks;
    private int numberOfElements;
    private int algorithm;
    private int publicKeyType;
    private int staticOOBType;
    private int outputOOBSize;
    private int outputOOBAction;
    private int inputOOBSize;
    private int inputOOBAction;
    private short outputActionType;
    private short inputActionType;

    public ProvisioningStartState(UnprovisionedMeshNode node, InternalTransportCallbacks internalTransportCallbacks, MeshProvisioningStatusCallbacks provisioningStatusCallbacks) {
        this.mNode = node;
        this.mInternalTransportCallbacks = internalTransportCallbacks;
        this.mMeshProvisioningStatusCallbacks = provisioningStatusCallbacks;
    }

    public void setUseStaticOOB(StaticOOBType actionType) {
        this.mNode.setAuthMethodUsed(AuthenticationOOBMethods.STATIC_OOB_AUTHENTICATION);
        this.mNode.setAuthActionUsed(actionType.getStaticOobType());
    }

    public void setUseOutputOOB(OutputOOBAction actionType) {
        this.mNode.setAuthMethodUsed(AuthenticationOOBMethods.OUTPUT_OOB_AUTHENTICATION);
        this.outputActionType = actionType.getOutputOOBAction();
        this.mNode.setAuthActionUsed(actionType.getOutputOOBAction());
    }

    public void setUseInputOOB(InputOOBAction actionType) {
        this.mNode.setAuthMethodUsed(AuthenticationOOBMethods.INPUT_OOB_AUTHENTICATION);
        this.inputActionType = actionType.getInputOOBAction();
        this.mNode.setAuthActionUsed(actionType.getInputOOBAction());
    }

    @Override
    public ProvisioningState.State getState() {
        return ProvisioningState.State.PROVISIONING_START;
    }

    @Override
    public void executeSend() {
        byte[] provisioningStartPDU = this.createProvisioningStartPDU();
        this.mNode.setProvisioningStartPdu(provisioningStartPDU);
        this.mMeshProvisioningStatusCallbacks.onProvisioningStateChanged(this.mNode, ProvisioningState.States.PROVISIONING_START, provisioningStartPDU);
        this.mInternalTransportCallbacks.sendProvisioningPdu(this.mNode, provisioningStartPDU);
    }

    @Override
    public boolean parseData(@NonNull byte[] data) {
        return true;
    }

    private byte[] createProvisioningStartPDU() {
        byte[] provisioningPDU = new byte[7];
        provisioningPDU[0] = 3;
        provisioningPDU[1] = 2;
        provisioningPDU[2] = AlgorithmType.getAlgorithmValue((short)this.algorithm);
        provisioningPDU[3] = 0;
        provisioningPDU[4] = (byte)this.mNode.getAuthMethodUsed().ordinal();
        switch (this.mNode.getAuthMethodUsed()) {
            case NO_OOB_AUTHENTICATION: {
                provisioningPDU[5] = 0;
                provisioningPDU[6] = 0;
                break;
            }
            case STATIC_OOB_AUTHENTICATION: {
                provisioningPDU[5] = 0;
                provisioningPDU[6] = 0;
                break;
            }
            case OUTPUT_OOB_AUTHENTICATION: {
                provisioningPDU[5] = (byte)OutputOOBAction.getOutputOOBActionValue(this.outputActionType);
                provisioningPDU[6] = (byte)this.outputOOBSize;
                break;
            }
            case INPUT_OOB_AUTHENTICATION: {
                provisioningPDU[5] = (byte)InputOOBAction.getInputOOBActionValue(this.inputActionType);
                provisioningPDU[6] = (byte)this.inputOOBSize;
                this.mNode.setInputAuthentication(InputOOBAction.getInputOOOBAuthenticationValue(this.inputActionType, (byte)this.inputOOBSize));
            }
        }
        Log.v((String)this.TAG, (String)("Provisioning start PDU: " + MeshParserUtils.bytesToHex(provisioningPDU, true)));
        return provisioningPDU;
    }

    public void setProvisioningCapabilities(int numberOfElements, int algorithm, int publicKeyType, int staticOOBType, int outputOOBSize, int outputOOBAction, int inputOOBSize, int inputOOBAction) {
        this.numberOfElements = numberOfElements;
        this.algorithm = algorithm;
        this.publicKeyType = publicKeyType;
        this.staticOOBType = staticOOBType;
        this.outputOOBSize = outputOOBSize;
        this.outputOOBAction = outputOOBAction;
        this.inputOOBSize = inputOOBSize;
        this.inputOOBAction = inputOOBAction;
    }
}

