/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.content.Context;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.UUID;
import no.nordicsemi.android.mesh.InternalTransportCallbacks;
import no.nordicsemi.android.mesh.MeshNetwork;
import no.nordicsemi.android.mesh.MeshStatusCallbacks;
import no.nordicsemi.android.mesh.NetworkKey;
import no.nordicsemi.android.mesh.transport.ConfigMessage;
import no.nordicsemi.android.mesh.transport.ConfigMessageState;
import no.nordicsemi.android.mesh.transport.DefaultNoOperationMessageState;
import no.nordicsemi.android.mesh.transport.GenericMessage;
import no.nordicsemi.android.mesh.transport.GenericMessageState;
import no.nordicsemi.android.mesh.transport.InternalMeshMsgHandlerCallbacks;
import no.nordicsemi.android.mesh.transport.MeshMessage;
import no.nordicsemi.android.mesh.transport.MeshMessageHandlerApi;
import no.nordicsemi.android.mesh.transport.MeshMessageState;
import no.nordicsemi.android.mesh.transport.MeshTransport;
import no.nordicsemi.android.mesh.transport.NetworkLayer;
import no.nordicsemi.android.mesh.transport.NetworkLayerCallbacks;
import no.nordicsemi.android.mesh.transport.ProvisionedMeshNode;
import no.nordicsemi.android.mesh.transport.ProxyConfigMessage;
import no.nordicsemi.android.mesh.transport.ProxyConfigMessageState;
import no.nordicsemi.android.mesh.transport.UpperTransportLayerCallbacks;
import no.nordicsemi.android.mesh.transport.VendorModelMessageAcked;
import no.nordicsemi.android.mesh.transport.VendorModelMessageAckedState;
import no.nordicsemi.android.mesh.transport.VendorModelMessageUnacked;
import no.nordicsemi.android.mesh.transport.VendorModelMessageUnackedState;
import no.nordicsemi.android.mesh.utils.ExtendedInvalidCipherTextException;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;
import no.nordicsemi.android.mesh.utils.SecureUtils;
import org.spongycastle.crypto.InvalidCipherTextException;

public abstract class BaseMeshMessageHandler
implements MeshMessageHandlerApi,
InternalMeshMsgHandlerCallbacks {
    private static final String TAG = BaseMeshMessageHandler.class.getSimpleName();
    protected final Context mContext;
    protected final InternalTransportCallbacks mInternalTransportCallbacks;
    private final NetworkLayerCallbacks networkLayerCallbacks;
    private final UpperTransportLayerCallbacks upperTransportLayerCallbacks;
    protected MeshStatusCallbacks mStatusCallbacks;
    private final SparseArray<MeshTransport> transportSparseArray = new SparseArray();
    private final SparseArray<MeshMessageState> stateSparseArray = new SparseArray();

    protected BaseMeshMessageHandler(@NonNull Context context, @NonNull InternalTransportCallbacks internalTransportCallbacks, @NonNull NetworkLayerCallbacks networkLayerCallbacks, @NonNull UpperTransportLayerCallbacks upperTransportLayerCallbacks) {
        this.mContext = context;
        this.mInternalTransportCallbacks = internalTransportCallbacks;
        this.networkLayerCallbacks = networkLayerCallbacks;
        this.upperTransportLayerCallbacks = upperTransportLayerCallbacks;
    }

    protected abstract void setMeshStatusCallbacks(@NonNull MeshStatusCallbacks var1);

    protected void parseMeshPduNotifications(@NonNull byte[] pdu, @NonNull MeshNetwork network) throws ExtendedInvalidCipherTextException {
        int ivIndex;
        List<NetworkKey> networkKeys = network.getNetKeys();
        int ivi = (pdu[1] & 0xFF) >>> 7 & 1;
        int nid = pdu[1] & 0x7F;
        int acceptedIvIndex = network.getIvIndex().getIvIndex();
        int n = ivIndex = acceptedIvIndex == 0 ? 0 : acceptedIvIndex - 1;
        while (ivIndex <= ivIndex + 1) {
            for (int i = 0; i < networkKeys.size(); ++i) {
                NetworkKey networkKey = networkKeys.get(i);
                SecureUtils.K2Output k2Output = this.getMatchingK2Output(networkKey, nid);
                if (k2Output == null) continue;
                byte[] networkHeader = NetworkLayer.deObfuscateNetworkHeader(pdu, MeshParserUtils.intToBytes(ivIndex), k2Output.getPrivacyKey());
                byte ctlTtl = networkHeader[0];
                int ctl = ctlTtl >> 7 & 1;
                int ttl = ctlTtl & 0x7F;
                Log.v((String)TAG, (String)("TTL for received message: " + ttl));
                int src = MeshParserUtils.unsignedBytesToInt(networkHeader[5], networkHeader[4]);
                ProvisionedMeshNode node = network.getNode(src);
                if (node == null) continue;
                byte[] sequenceNumber = ByteBuffer.allocate(3).order(ByteOrder.BIG_ENDIAN).put(networkHeader, 1, 3).array();
                Log.v((String)TAG, (String)("Sequence number of received access message: " + MeshParserUtils.convert24BitsToInt(sequenceNumber)));
                try {
                    MeshMessageState state;
                    byte[] decryptedPayload;
                    byte[] nonce;
                    int networkPayloadLength = pdu.length - (2 + networkHeader.length);
                    byte[] transportPdu = new byte[networkPayloadLength];
                    System.arraycopy(pdu, 8, transportPdu, 0, networkPayloadLength);
                    if (pdu[0] == 0) {
                        nonce = NetworkLayer.createNetworkNonce(ctlTtl, sequenceNumber, src, MeshParserUtils.intToBytes(ivIndex));
                        decryptedPayload = SecureUtils.decryptCCM(transportPdu, k2Output.getEncryptionKey(), nonce, SecureUtils.getNetMicLength(ctl));
                        state = this.getState(src);
                    } else {
                        nonce = NetworkLayer.createProxyNonce(sequenceNumber, src, MeshParserUtils.intToBytes(ivIndex));
                        decryptedPayload = SecureUtils.decryptCCM(transportPdu, k2Output.getEncryptionKey(), nonce, SecureUtils.getNetMicLength(ctl));
                        state = this.getState(0);
                    }
                    if (state == null) continue;
                    ((DefaultNoOperationMessageState)state).parseMeshPdu(networkKey, node, pdu, networkHeader, decryptedPayload, ivIndex, sequenceNumber);
                    return;
                }
                catch (InvalidCipherTextException ex) {
                    if (i != networkKeys.size() - 1) continue;
                    throw new ExtendedInvalidCipherTextException(ex.getMessage(), ex.getCause(), TAG);
                }
            }
            ++ivIndex;
        }
    }

    private SecureUtils.K2Output getMatchingK2Output(@NonNull NetworkKey networkKey, int nid) {
        if (nid == networkKey.getDerivatives().getNid()) {
            return networkKey.getDerivatives();
        }
        if (networkKey.getOldDerivatives() != null && nid == networkKey.getOldDerivatives().getNid()) {
            return networkKey.getOldDerivatives();
        }
        return null;
    }

    @Override
    public final void onIncompleteTimerExpired(int address) {
        this.stateSparseArray.put(address, (Object)this.toggleState(this.getTransport(address), this.getState(address).getMeshMessage()));
    }

    private DefaultNoOperationMessageState toggleState(@NonNull MeshTransport transport, @Nullable MeshMessage meshMessage) {
        DefaultNoOperationMessageState state = new DefaultNoOperationMessageState(meshMessage, transport, this);
        state.setTransportCallbacks(this.mInternalTransportCallbacks);
        state.setStatusCallbacks(this.mStatusCallbacks);
        return state;
    }

    protected MeshMessageState getState(int address) {
        MeshMessageState state = (MeshMessageState)this.stateSparseArray.get(address);
        if (state == null) {
            state = new DefaultNoOperationMessageState(null, this.getTransport(address), this);
            state.setTransportCallbacks(this.mInternalTransportCallbacks);
            state.setStatusCallbacks(this.mStatusCallbacks);
            this.stateSparseArray.put(address, (Object)state);
        }
        return state;
    }

    private MeshTransport getTransport(int address) {
        MeshTransport transport = (MeshTransport)this.transportSparseArray.get(address);
        if (transport == null) {
            transport = new MeshTransport(this.mContext);
            transport.setNetworkLayerCallbacks(this.networkLayerCallbacks);
            transport.setUpperTransportLayerCallbacks(this.upperTransportLayerCallbacks);
            this.transportSparseArray.put(address, (Object)transport);
        }
        return transport;
    }

    public void resetState(int address) {
        this.stateSparseArray.remove(address);
        this.transportSparseArray.remove(address);
    }

    @Override
    public void createMeshMessage(int src, int dst, @Nullable UUID label, @NonNull MeshMessage meshMessage) {
        if (meshMessage instanceof ProxyConfigMessage) {
            this.createProxyConfigMeshMessage(src, dst, (ProxyConfigMessage)meshMessage);
        } else if (meshMessage instanceof ConfigMessage) {
            this.createConfigMeshMessage(src, dst, (ConfigMessage)meshMessage);
        } else if (meshMessage instanceof GenericMessage) {
            if (label == null) {
                this.createAppMeshMessage(src, dst, (GenericMessage)meshMessage);
            } else {
                this.createAppMeshMessage(src, dst, label, (GenericMessage)meshMessage);
            }
        }
    }

    private void createProxyConfigMeshMessage(int src, int dst, @NonNull ProxyConfigMessage configurationMessage) {
        ProxyConfigMessageState currentState = new ProxyConfigMessageState(src, dst, configurationMessage, this.getTransport(dst), this);
        currentState.setTransportCallbacks(this.mInternalTransportCallbacks);
        currentState.setStatusCallbacks(this.mStatusCallbacks);
        this.stateSparseArray.put(dst, (Object)this.toggleState(currentState.getMeshTransport(), configurationMessage));
        currentState.executeSend();
    }

    private void createConfigMeshMessage(int src, int dst, @NonNull ConfigMessage configurationMessage) {
        ProvisionedMeshNode node = this.mInternalTransportCallbacks.getNode(dst);
        if (node == null) {
            return;
        }
        ConfigMessageState currentState = new ConfigMessageState(src, dst, node.getDeviceKey(), configurationMessage, this.getTransport(dst), this);
        currentState.setTransportCallbacks(this.mInternalTransportCallbacks);
        currentState.setStatusCallbacks(this.mStatusCallbacks);
        if (MeshAddress.isValidUnicastAddress(dst)) {
            this.stateSparseArray.put(dst, (Object)this.toggleState(this.getTransport(dst), configurationMessage));
        }
        currentState.executeSend();
    }

    private void createAppMeshMessage(int src, int dst, @NonNull GenericMessage genericMessage) {
        GenericMessageState currentState = genericMessage instanceof VendorModelMessageAcked ? new VendorModelMessageAckedState(src, dst, (VendorModelMessageAcked)genericMessage, this.getTransport(dst), (InternalMeshMsgHandlerCallbacks)this) : (genericMessage instanceof VendorModelMessageUnacked ? new VendorModelMessageUnackedState(src, dst, (VendorModelMessageUnacked)genericMessage, this.getTransport(dst), (InternalMeshMsgHandlerCallbacks)this) : new GenericMessageState(src, dst, genericMessage, this.getTransport(dst), this));
        currentState.setTransportCallbacks(this.mInternalTransportCallbacks);
        currentState.setStatusCallbacks(this.mStatusCallbacks);
        if (MeshAddress.isValidUnicastAddress(dst)) {
            this.stateSparseArray.put(dst, (Object)this.toggleState(this.getTransport(dst), genericMessage));
        }
        currentState.executeSend();
    }

    private void createAppMeshMessage(int src, int dst, @NonNull UUID label, @NonNull GenericMessage genericMessage) {
        GenericMessageState currentState = genericMessage instanceof VendorModelMessageAcked ? new VendorModelMessageAckedState(src, dst, label, (VendorModelMessageAcked)genericMessage, this.getTransport(dst), (InternalMeshMsgHandlerCallbacks)this) : (genericMessage instanceof VendorModelMessageUnacked ? new VendorModelMessageUnackedState(src, dst, label, (VendorModelMessageUnacked)genericMessage, this.getTransport(dst), (InternalMeshMsgHandlerCallbacks)this) : new GenericMessageState(src, dst, label, genericMessage, this.getTransport(dst), this));
        currentState.setTransportCallbacks(this.mInternalTransportCallbacks);
        currentState.setStatusCallbacks(this.mStatusCallbacks);
        if (MeshAddress.isValidUnicastAddress(dst)) {
            this.stateSparseArray.put(dst, (Object)this.toggleState(this.getTransport(dst), genericMessage));
        }
        currentState.executeSend();
    }
}

