/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ConfigStatusMessage;
import no.nordicsemi.android.mesh.utils.CompositionDataParser;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class ConfigSigModelAppList
extends ConfigStatusMessage
implements Parcelable {
    private static final String TAG = ConfigSigModelAppList.class.getSimpleName();
    private static final int OP_CODE = 32844;
    private int mElementAddress;
    private int mModelIdentifier;
    private final List<Integer> mKeyIndexes = new ArrayList<Integer>();
    public static final Parcelable.Creator<ConfigSigModelAppList> CREATOR = new Parcelable.Creator<ConfigSigModelAppList>(){

        public ConfigSigModelAppList createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new ConfigSigModelAppList(message);
        }

        public ConfigSigModelAppList[] newArray(int size) {
            return new ConfigSigModelAppList[size];
        }
    };

    public ConfigSigModelAppList(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    final void parseStatusParameters() {
        this.mStatusCode = this.mParameters[0];
        this.mStatusCodeName = this.getStatusCodeName(this.mStatusCode);
        this.mElementAddress = MeshParserUtils.unsignedBytesToInt(this.mParameters[1], this.mParameters[2]);
        this.mModelIdentifier = MeshParserUtils.unsignedBytesToInt(this.mParameters[3], this.mParameters[4]);
        Log.v((String)TAG, (String)("Status code: " + this.mStatusCode));
        Log.v((String)TAG, (String)("Status message: " + this.mStatusCodeName));
        Log.v((String)TAG, (String)("Element address: " + MeshAddress.formatAddress(this.mElementAddress, false)));
        Log.v((String)TAG, (String)("Model identifier: " + CompositionDataParser.formatModelIdentifier(this.mModelIdentifier, false)));
        this.mKeyIndexes.addAll(this.decode(this.mParameters.length, 5));
        for (Integer keyIndex : this.mKeyIndexes) {
            Log.v((String)TAG, (String)("AppKey Index: " + Integer.toHexString(keyIndex)));
        }
    }

    @Override
    public final int getOpCode() {
        return 32844;
    }

    public final boolean isSuccessful() {
        return this.mStatusCode == 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }

    public int getElementAddress() {
        return this.mElementAddress;
    }

    public int getModelIdentifier() {
        return this.mModelIdentifier;
    }

    public List<Integer> getKeyIndexes() {
        return this.mKeyIndexes;
    }
}

