/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.transport.ConfigMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;

public final class ConfigSigModelSubscriptionGet
extends ConfigMessage {
    private static final String TAG = ConfigSigModelSubscriptionGet.class.getSimpleName();
    private static final int OP_CODE = 32809;
    private static final int SIG_MODEL_SUBSCRIPTION_GET_LENGTH = 4;
    private final int mElementAddress;
    private final int mModelIdentifier;

    public ConfigSigModelSubscriptionGet(int elementAddress, int modelIdentifier) throws IllegalArgumentException {
        if (!MeshAddress.isValidUnicastAddress(elementAddress)) {
            throw new IllegalArgumentException("Invalid unicast address, unicast address must be a 16-bit value, and must range from 0x0001 to 0x7FFF");
        }
        this.mElementAddress = elementAddress;
        this.mModelIdentifier = modelIdentifier;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 32809;
    }

    @Override
    void assembleMessageParameters() {
        byte[] elementAddress = MeshAddress.addressIntToBytes(this.mElementAddress);
        ByteBuffer paramsBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        paramsBuffer.putShort((short)this.mElementAddress);
        paramsBuffer.putShort((short)this.mModelIdentifier);
        this.mParameters = paramsBuffer.array();
    }
}

