/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.GenericStatusMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public final class LightHslStatus
extends GenericStatusMessage
implements Parcelable {
    private static final String TAG = LightHslStatus.class.getSimpleName();
    private static final int LIGHT_CTL_STATUS_MANDATORY_LENGTH = 6;
    private static final int OP_CODE = 33400;
    private int mPresentHslLightness;
    private int mPresentHslHue;
    private int mPresentHslSaturation;
    private int mTransitionSteps;
    private int mTransitionResolution;
    private static final Parcelable.Creator<LightHslStatus> CREATOR = new Parcelable.Creator<LightHslStatus>(){

        public LightHslStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new LightHslStatus(message);
        }

        public LightHslStatus[] newArray(int size) {
            return new LightHslStatus[size];
        }
    };

    public LightHslStatus(@NonNull AccessMessage message) {
        super(message);
        this.mMessage = message;
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        Log.v((String)TAG, (String)("Received light hsl status from: " + MeshAddress.formatAddress(this.mMessage.getSrc(), true)));
        ByteBuffer buffer = ByteBuffer.wrap(this.mParameters).order(ByteOrder.LITTLE_ENDIAN);
        this.mPresentHslLightness = buffer.getShort() & 0xFFFF;
        this.mPresentHslHue = buffer.getShort() & 0xFFFF;
        this.mPresentHslSaturation = buffer.getShort() & 0xFFFF;
        Log.v((String)TAG, (String)("Present lightness: " + this.mPresentHslLightness));
        Log.v((String)TAG, (String)("Present hue: " + this.mPresentHslHue));
        Log.v((String)TAG, (String)("Present saturation: " + this.mPresentHslSaturation));
        if (buffer.limit() > 6) {
            int remainingTime = buffer.get() & 0xFF;
            this.mTransitionSteps = remainingTime & 0x3F;
            this.mTransitionResolution = remainingTime >> 6;
            Log.v((String)TAG, (String)("Remaining time, transition number of steps: " + this.mTransitionSteps));
            Log.v((String)TAG, (String)("Remaining time, transition number of step resolution: " + this.mTransitionResolution));
            Log.v((String)TAG, (String)("Remaining time: " + MeshParserUtils.getRemainingTime(remainingTime)));
        }
    }

    @Override
    public int getOpCode() {
        return 33400;
    }

    public final int getPresentLightness() {
        return this.mPresentHslLightness;
    }

    public final int getPresentSaturation() {
        return this.mPresentHslSaturation;
    }

    public final int getPresentHue() {
        return this.mPresentHslHue;
    }

    public int getTransitionSteps() {
        return this.mTransitionSteps;
    }

    public int getTransitionResolution() {
        return this.mTransitionResolution;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }
}

