/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.utils;

import android.util.Log;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public enum InputOOBAction {
    NO_INPUT(0),
    PUSH(1),
    TWIST(2),
    INPUT_NUMERIC(4),
    INPUT_ALPHA_NUMERIC(8);

    private static final String TAG;
    private short inputOOBAction;

    private InputOOBAction(short outputOOBAction) {
        this.inputOOBAction = outputOOBAction;
    }

    public short getInputOOBAction() {
        return this.inputOOBAction;
    }

    public static InputOOBAction fromValue(short method) {
        switch (method) {
            default: {
                return NO_INPUT;
            }
            case 1: {
                return PUSH;
            }
            case 2: {
                return TWIST;
            }
            case 4: {
                return INPUT_NUMERIC;
            }
            case 8: 
        }
        return INPUT_ALPHA_NUMERIC;
    }

    public static String getInputOOBActionDescription(InputOOBAction type) {
        switch (type) {
            case NO_INPUT: {
                return "Not supported";
            }
            case PUSH: {
                return "Push";
            }
            case TWIST: {
                return "Twist";
            }
            case INPUT_NUMERIC: {
                return "Input Number";
            }
            case INPUT_ALPHA_NUMERIC: {
                return "Input Alpha Numeric";
            }
        }
        return "Unknown";
    }

    public static ArrayList<InputOOBAction> parseInputActionsFromBitMask(int inputAction) {
        InputOOBAction[] inputActions = new InputOOBAction[]{PUSH, TWIST, INPUT_NUMERIC, INPUT_ALPHA_NUMERIC};
        ArrayList<InputOOBAction> supportedActionValues = new ArrayList<InputOOBAction>();
        for (InputOOBAction action : inputActions) {
            if ((inputAction & action.inputOOBAction) != action.inputOOBAction) continue;
            supportedActionValues.add(action);
            Log.v((String)TAG, (String)("Input oob action type value: " + InputOOBAction.getInputOOBActionDescription(action)));
        }
        return supportedActionValues;
    }

    public static int getInputOOBActionValue(InputOOBAction type) {
        switch (type) {
            case PUSH: {
                return 0;
            }
            case TWIST: {
                return 1;
            }
            case INPUT_NUMERIC: {
                return 2;
            }
            case INPUT_ALPHA_NUMERIC: {
                return 3;
            }
        }
        return -1;
    }

    public static int getInputOOBActionValue(short type) {
        switch (InputOOBAction.fromValue(type)) {
            case PUSH: {
                return 0;
            }
            case TWIST: {
                return 1;
            }
            case INPUT_NUMERIC: {
                return 2;
            }
            case INPUT_ALPHA_NUMERIC: {
                return 3;
            }
        }
        return -1;
    }

    public static byte[] generateInputOOBAuthenticationValue(InputOOBAction inputOOBAction, byte[] input) {
        int authLength = 16;
        ByteBuffer buffer = ByteBuffer.allocate(16).order(ByteOrder.BIG_ENDIAN);
        switch (inputOOBAction) {
            case PUSH: 
            case TWIST: 
            case INPUT_NUMERIC: {
                buffer.position(8);
                long longValue = Long.valueOf(MeshParserUtils.bytesToHex(input, false), 16);
                buffer.putLong(longValue);
                return buffer.array();
            }
            case INPUT_ALPHA_NUMERIC: {
                buffer.put(input);
                return buffer.array();
            }
        }
        return null;
    }

    public static byte[] getInputOOOBAuthenticationValue(short inputOOBAction, byte size) {
        switch (InputOOBAction.fromValue(inputOOBAction)) {
            case PUSH: 
            case TWIST: {
                return MeshParserUtils.generateOOBCount(1);
            }
            case INPUT_NUMERIC: {
                return MeshParserUtils.generateOOBNumeric(size);
            }
            case INPUT_ALPHA_NUMERIC: {
                return MeshParserUtils.generateOOBAlphaNumeric(size);
            }
        }
        return null;
    }

    static {
        TAG = InputOOBAction.class.getSimpleName();
    }
}

