/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.utils;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import no.nordicsemi.android.mesh.NodeKey;
import no.nordicsemi.android.mesh.R;

public class MeshParserUtils {
    private static final String TAG = MeshParserUtils.class.getSimpleName();
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
    private static final String PATTERN_KEY = "[0-9a-fA-F]{32}";
    private static final String PATTERN_UUID_HEX = "[0-9a-fA-F]{32}";
    private static final int PROHIBITED_DEFAULT_TTL_STATE_MIN = 1;
    private static final int PROHIBITED_DEFAULT_TTL_STATE_MID = 128;
    private static final int PROHIBITED_DEFAULT_TTL_STATE_MAX = 255;
    public static final int USE_DEFAULT_TTL = 255;
    private static final int MIN_TTL = 0;
    private static final int MAX_TTL = 127;
    private static final int PROHIBITED_PUBLISH_TTL_MIN = 128;
    private static final int PROHIBITED_PUBLISH_TTL_MAX = 254;
    private static final int IV_ADDRESS_MIN = 0;
    private static final int IV_ADDRESS_MAX = 4096;
    private static final int UNICAST_ADDRESS_MIN = 0;
    private static final char[] HEX_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final byte[] ALPHANUMERIC = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
    private static final int[] M_NUMERIC_MAX = new int[]{0, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000};
    public static final int RESOLUTION_100_MS = 0;
    public static final int RESOLUTION_1_S = 1;
    public static final int RESOLUTION_10_S = 2;
    public static final int RESOLUTION_10_M = 3;
    public static final int GENERIC_ON_OFF_5_MS = 5;

    public static String bytesToHex(byte[] bytes, boolean add0x) {
        if (bytes == null) {
            return "";
        }
        return MeshParserUtils.bytesToHex(bytes, 0, bytes.length, add0x);
    }

    public static String bytesToHex(byte[] bytes, int start, int length, boolean add0x) {
        if (bytes == null || bytes.length <= start || length <= 0) {
            return "";
        }
        int maxLength = Math.min(length, bytes.length - start);
        char[] hexChars = new char[maxLength * 2];
        for (int j = 0; j < maxLength; ++j) {
            int v = bytes[start + j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        if (!add0x) {
            return new String(hexChars);
        }
        return "0x" + new String(hexChars);
    }

    public static byte[] toByteArray(String hexString) {
        int len = hexString.length();
        byte[] bytes = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            bytes[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return bytes;
    }

    private static boolean isValidKeyIndex(Integer value) {
        return value == null || value != (value & 0xFFF);
    }

    private static boolean isValidIvIndex(@NonNull Integer ivIndex) {
        return ivIndex == 0 || ivIndex > 0;
    }

    public static byte parseUpdateFlags(int keyRefreshFlag, int ivUpdateFlag) {
        byte flags = 0;
        flags = keyRefreshFlag == 1 ? (byte)((byte)(flags | 1)) : (byte)((byte)(flags & 0xFFFFFFFE));
        flags = ivUpdateFlag == 1 ? (byte)((byte)(flags | 2)) : (byte)((byte)(flags & 0xFFFFFFFE));
        return flags;
    }

    public static int getBitValue(int value, int position) {
        return value >> position & 1;
    }

    public static byte[] addKeyIndexPadding(Integer keyIndex) {
        return ByteBuffer.allocate(2).order(ByteOrder.BIG_ENDIAN).putShort((short)(keyIndex & 0xFFF)).array();
    }

    public static int removeKeyIndexPadding(byte[] keyIndex) {
        return keyIndex[0] & 0xF | keyIndex[1];
    }

    public static boolean validateNetworkKeyInput(@NonNull String networkKey) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)networkKey)) {
            throw new IllegalArgumentException("Network key cannot be empty!");
        }
        if (!networkKey.matches("[0-9a-fA-F]{32}")) {
            throw new IllegalArgumentException("Network key must be 16 bytes long!");
        }
        return true;
    }

    public static boolean validateKeyIndexInput(Context context, String input) throws IllegalArgumentException {
        int keyIndex;
        if (TextUtils.isEmpty((CharSequence)input)) {
            throw new IllegalArgumentException(context.getString(R.string.error_empty_key_index));
        }
        try {
            keyIndex = Integer.parseInt(input);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(context.getString(R.string.error_invalid_key_index));
        }
        if (MeshParserUtils.isValidKeyIndex(keyIndex)) {
            throw new IllegalArgumentException(context.getString(R.string.error_invalid_key_index));
        }
        return true;
    }

    public static boolean validateIvIndexInput(Context context, String input) throws IllegalArgumentException {
        int ivIndex;
        if (TextUtils.isEmpty((CharSequence)input)) {
            throw new IllegalArgumentException(context.getString(R.string.error_empty_iv_index));
        }
        try {
            ivIndex = Integer.parseInt(input, 16);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(context.getString(R.string.error_invalid_iv_index));
        }
        if (!MeshParserUtils.isValidIvIndex(ivIndex)) {
            throw new IllegalArgumentException(context.getString(R.string.error_invalid_iv_index));
        }
        return true;
    }

    public static boolean validateIvIndexInput(Context context, Integer ivIndex) throws IllegalArgumentException {
        if (ivIndex == null) {
            throw new IllegalArgumentException(context.getString(R.string.error_empty_iv_index));
        }
        if (!MeshParserUtils.isValidIvIndex(ivIndex)) {
            throw new IllegalArgumentException(context.getString(R.string.error_invalid_iv_index));
        }
        return true;
    }

    public static boolean validateKeyInput(@NonNull String key) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException("Key cannot be empty!");
        }
        if (!key.matches("[0-9a-fA-F]{32}")) {
            throw new IllegalArgumentException("key must be a 32-character hexadecimal string!");
        }
        return true;
    }

    public static boolean isValidSequenceNumber(int sequenceNumber) {
        boolean flag;
        boolean bl = flag = sequenceNumber == (sequenceNumber & 0xFFFFFF);
        if (sequenceNumber == 0xFFFFFF) {
            flag = false;
        }
        return flag;
    }

    public static byte[] getSequenceNumberBytes(int sequenceNumber) {
        if (MeshParserUtils.isValidSequenceNumber(sequenceNumber)) {
            return new byte[]{(byte)(sequenceNumber >> 16 & 0xFF), (byte)(sequenceNumber >> 8 & 0xFF), (byte)(sequenceNumber & 0xFF)};
        }
        return null;
    }

    public static int convert24BitsToInt(@NonNull byte[] byteArray) {
        if (byteArray.length != 3) {
            throw new IllegalArgumentException("Invalid length, byte array must be 3-bytes long.");
        }
        return (byteArray[0] & 0xFF) << 16 | (byteArray[1] & 0xFF) << 8 | byteArray[2] & 0xFF;
    }

    public static int getSequenceNumberFromPDU(byte[] pdu) {
        return MeshParserUtils.convert24BitsToInt(new byte[]{pdu[3], pdu[4], pdu[5]});
    }

    public static int calculateSeqZero(byte[] sequenceNumber) {
        return (sequenceNumber[1] & 0x1F) << 8 | sequenceNumber[2] & 0xFF;
    }

    public static byte[] getSrcAddress(byte[] pdu) {
        return ByteBuffer.allocate(2).put(pdu, 6, 2).array();
    }

    public static byte[] getDstAddress(byte[] pdu) {
        return ByteBuffer.allocate(2).put(pdu, 8, 2).array();
    }

    private static int getSegmentedMessageLength(SparseArray<byte[]> segmentedMessageMap) {
        int length = 0;
        for (int i = 0; i < segmentedMessageMap.size(); ++i) {
            length += ((byte[])segmentedMessageMap.get(i)).length;
        }
        return length;
    }

    public static byte[] concatenateSegmentedMessages(SparseArray<byte[]> segmentedMessages) {
        int length = MeshParserUtils.getSegmentedMessageLength(segmentedMessages);
        ByteBuffer completeBuffer = ByteBuffer.allocate(length);
        completeBuffer.order(ByteOrder.BIG_ENDIAN);
        for (int i = 0; i < segmentedMessages.size(); ++i) {
            completeBuffer.put((byte[])segmentedMessages.get(i));
        }
        return completeBuffer.array();
    }

    public static int getOpCode(byte[] accessPayload, int opCodeCount) {
        switch (opCodeCount) {
            case 1: {
                return accessPayload[0];
            }
            case 2: {
                return MeshParserUtils.unsignedBytesToInt(accessPayload[1], accessPayload[0]);
            }
        }
        return MeshParserUtils.unsignedByteToInt(accessPayload[1]) << 8 | MeshParserUtils.unsignedByteToInt(accessPayload[0]) << 16 | MeshParserUtils.unsignedByteToInt(accessPayload[2]);
    }

    public static byte[] getOpCode(int opCode) {
        if (opCode < 128) {
            return new byte[]{(byte)(opCode & 0xFF)};
        }
        if (opCode < 16384 || (opCode & 0xFFFC00) == 32768) {
            return new byte[]{(byte)(0x80 | opCode >> 8 & 0x3F), (byte)(opCode & 0xFF)};
        }
        return new byte[]{(byte)(0xC0 | opCode >> 16 & 0x3F), (byte)(opCode >> 8 & 0xFF), (byte)(opCode & 0xFF)};
    }

    public static int getOpCodeLength(int mostSignificantOpcodeByte) {
        if (mostSignificantOpcodeByte < 128) {
            return 1;
        }
        if (mostSignificantOpcodeByte <= 191) {
            return 2;
        }
        return 3;
    }

    public static byte[] createVendorOpCode(int opCode, int companyIdentifier) {
        byte[] opCodes = new byte[]{(byte)(opCode | 0xC0), (byte)(companyIdentifier & 0xFF), (byte)(companyIdentifier >> 8 & 0xFF)};
        return opCodes;
    }

    public static boolean isValidOpcode(int opCode) throws IllegalArgumentException {
        if (opCode != (opCode & 0xFFFFFF)) {
            throw new IllegalArgumentException("Invalid opcode, opcode must be 1-3 octets");
        }
        return true;
    }

    public static boolean isValidParameters(byte[] parameters) throws IllegalArgumentException {
        if (parameters != null && parameters.length > 379) {
            throw new IllegalArgumentException("Invalid parameters, parameters must be 0-379 octets");
        }
        return true;
    }

    public static boolean isValidTtl(int ttl) {
        return ttl >= 0 && ttl <= 127;
    }

    public static boolean isValidDefaultTtl(int ttl) {
        return ttl == 0 || ttl >= 2 && ttl <= 127;
    }

    public static boolean isDefaultPublishTtl(int publishTtl) {
        return publishTtl == 255;
    }

    public static boolean validateRetransmitCount(int retransmitCount) {
        return retransmitCount == (retransmitCount & 7);
    }

    public static boolean validatePublishRetransmitIntervalSteps(int intervalSteps) {
        return intervalSteps == (intervalSteps & 0x1F);
    }

    public static String getRemainingTime(int remainingTime) {
        int stepResolution = remainingTime >> 6;
        int numberOfSteps = remainingTime & 0x3F;
        switch (stepResolution) {
            case 0: {
                return numberOfSteps * 100 + " milliseconds";
            }
            case 1: {
                return numberOfSteps + " seconds";
            }
            case 2: {
                return numberOfSteps * 10 + " seconds";
            }
            case 3: {
                return numberOfSteps * 10 + " minutes";
            }
        }
        return "Unknown";
    }

    public static String getRemainingTransitionTime(int stepResolution, int numberOfSteps) {
        switch (stepResolution) {
            case 0: {
                return numberOfSteps * 100 + " ms";
            }
            case 1: {
                return numberOfSteps + " s";
            }
            case 2: {
                return numberOfSteps * 10 + " s";
            }
            case 3: {
                return numberOfSteps * 10 + " min.";
            }
        }
        return "Unknown";
    }

    public static int getRemainingTime(int resolution, int steps) {
        switch (resolution) {
            case 0: {
                return steps * 100;
            }
            case 1: {
                return steps * 1000;
            }
            case 2: {
                return steps * 10 * 1000;
            }
            case 3: {
                return steps * 10 * 1000 * 60;
            }
        }
        return 0;
    }

    public static int getValue(byte[] bytes) {
        if (bytes == null || bytes.length != 2) {
            return 0;
        }
        return MeshParserUtils.unsignedToSigned(MeshParserUtils.unsignedBytesToInt(bytes[0], bytes[1]), 16);
    }

    public static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public static int unsignedBytesToInt(byte b0, byte b1) {
        return MeshParserUtils.unsignedByteToInt(b0) + (MeshParserUtils.unsignedByteToInt(b1) << 8);
    }

    public static int bytesToInt(@NonNull byte[] b) {
        return b.length == 4 ? ByteBuffer.wrap(b).order(ByteOrder.BIG_ENDIAN).getInt() : (int)ByteBuffer.wrap(b).order(ByteOrder.BIG_ENDIAN).getShort();
    }

    public static int hexToInt(String hex) {
        return MeshParserUtils.bytesToInt(MeshParserUtils.toByteArray(hex));
    }

    public static byte[] intToBytes(int i) {
        return ByteBuffer.allocate(4).putInt(i).array();
    }

    private static int unsignedToSigned(int unsigned, int size) {
        if ((unsigned & 1 << size - 1) != 0) {
            unsigned = -1 * ((1 << size - 1) - (unsigned & (1 << size - 1) - 1));
        }
        return unsigned;
    }

    public static boolean isVendorModel(int modelId) {
        return modelId < Short.MIN_VALUE || modelId > Short.MAX_VALUE;
    }

    public static int getCompanyIdentifier(int modelId) {
        if (modelId >= Short.MIN_VALUE && modelId <= Short.MAX_VALUE) {
            throw new IllegalArgumentException("Not a valid vendor model ID");
        }
        ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
        buffer.putInt(modelId);
        return buffer.getShort(0);
    }

    static byte[] generateOOBCount(int oobSize) {
        Random random = new Random();
        int bound = (int)Math.pow(10.0, oobSize) - 1;
        byte randomByte = (byte)(random.nextInt(bound) + 1);
        Log.v((String)TAG, (String)("Random OOB count: " + randomByte));
        return new byte[]{randomByte};
    }

    static byte[] generateOOBNumeric(int oobSize) {
        Random random = new Random();
        int value = random.nextInt((int)Math.pow(10.0, oobSize));
        Log.v((String)TAG, (String)("Random OOB numeric: " + value));
        return MeshParserUtils.intToBytes(value);
    }

    static byte[] generateOOBAlphaNumeric(int oobSize) {
        Random random = new Random();
        byte[] value = new byte[oobSize];
        for (int i = 0; i < oobSize; ++i) {
            int index = random.nextInt(ALPHANUMERIC.length);
            value[i] = ALPHANUMERIC[index];
        }
        Log.v((String)TAG, (String)("Random OOB alpha numeric: " + new String(value)));
        return value;
    }

    public static String uuidToHex(@NonNull UUID uuid) {
        return uuid.toString().replace("-", "").toUpperCase(Locale.US);
    }

    public static String uuidToHex(@NonNull String uuid) {
        return uuid.replace("-", "").toUpperCase(Locale.US);
    }

    public static byte[] uuidToBytes(@NonNull UUID uuid) {
        return MeshParserUtils.toByteArray(uuid.toString().replace("-", ""));
    }

    public static String formatUuid(@NonNull String uuidHex) {
        if (MeshParserUtils.isUuidPattern(uuidHex)) {
            return new StringBuffer(uuidHex).insert(8, "-").insert(13, "-").insert(18, "-").insert(23, "-").toString().toUpperCase(Locale.US);
        }
        return uuidHex;
    }

    public static boolean isUuidPattern(@NonNull String uuidHex) {
        return uuidHex.matches("[0-9a-fA-F]{32}");
    }

    public static UUID getUuid(@NonNull String uuidHex) {
        if (uuidHex.matches("[0-9a-fA-F]{32}")) {
            return UUID.fromString(new StringBuffer(uuidHex).insert(8, "-").insert(4, "-").insert(4, "-").insert(4, "-").toString());
        }
        return null;
    }

    public static String formatTimeStamp(long timestamp) {
        return SDF.format(new Date(timestamp));
    }

    public static boolean isNodeKeyExists(@NonNull List<NodeKey> keys, int index) {
        for (NodeKey key : keys) {
            if (key.getIndex() != index) continue;
            return true;
        }
        return false;
    }

    public static NodeKey getNodeKey(@NonNull List<NodeKey> keys, int index) {
        for (NodeKey key : keys) {
            if (key.getIndex() != index) continue;
            return key;
        }
        return null;
    }

    public static boolean isValidHeartbeatCountLog(int countLog) {
        if (countLog >= 0 && countLog < 18 || countLog == 255) {
            return true;
        }
        throw new IllegalArgumentException("Count log must be 0 to 17 or 255!");
    }

    public static boolean isValidHeartbeatPublicationTtl(int ttl) {
        return ttl <= 127;
    }
}

