/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.utils;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import no.nordicsemi.android.mesh.utils.AddressArray;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.ProxyFilterType;

public class ProxyFilter
implements Parcelable {
    private final ProxyFilterType filterType;
    private final List<AddressArray> addresses = new ArrayList<AddressArray>();
    public static final Parcelable.Creator<ProxyFilter> CREATOR = new Parcelable.Creator<ProxyFilter>(){

        public ProxyFilter createFromParcel(Parcel in) {
            return new ProxyFilter(in);
        }

        public ProxyFilter[] newArray(int size) {
            return new ProxyFilter[size];
        }
    };

    public ProxyFilter(ProxyFilterType filterType) {
        this.filterType = filterType;
    }

    private ProxyFilter(Parcel in) {
        this.filterType = (ProxyFilterType)in.readParcelable(ProxyFilterType.class.getClassLoader());
        in.readList(this.addresses, AddressArray.class.getClassLoader());
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.filterType, flags);
        dest.writeList(this.addresses);
    }

    public int describeContents() {
        return 0;
    }

    public ProxyFilterType getFilterType() {
        return this.filterType;
    }

    public List<AddressArray> getAddresses() {
        return Collections.unmodifiableList(this.addresses);
    }

    public void addAddress(AddressArray addressArray) {
        if (!this.contains(addressArray)) {
            this.addresses.add(addressArray);
        }
    }

    private boolean contains(@NonNull AddressArray addressArray) {
        for (AddressArray arr : this.addresses) {
            if (!Arrays.equals(addressArray.getAddress(), arr.getAddress())) continue;
            return true;
        }
        return false;
    }

    public final boolean contains(@NonNull byte[] address) {
        if (MeshAddress.isValidUnicastAddress(address) || MeshAddress.isValidSubscriptionAddress(address)) {
            AddressArray addressArray = new AddressArray(address[0], address[1]);
            for (AddressArray arr : this.addresses) {
                if (!Arrays.equals(addressArray.getAddress(), arr.getAddress())) continue;
                return true;
            }
        }
        return false;
    }

    public void removeAddress(AddressArray addressArray) {
        this.addresses.remove(addressArray);
    }
}

