/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.room.Ignore;
import no.nordicsemi.android.mesh.AddressRange;
import no.nordicsemi.android.mesh.utils.MeshAddress;

public class AllocatedUnicastRange
extends AddressRange {
    public static final Parcelable.Creator<AllocatedUnicastRange> CREATOR = new Parcelable.Creator<AllocatedUnicastRange>(){

        public AllocatedUnicastRange createFromParcel(Parcel in) {
            return new AllocatedUnicastRange(in);
        }

        public AllocatedUnicastRange[] newArray(int size) {
            return new AllocatedUnicastRange[size];
        }
    };

    public AllocatedUnicastRange(int lowAddress, int highAddress) {
        this.lowerBound = 1;
        this.upperBound = Short.MAX_VALUE;
        if (!MeshAddress.isValidUnicastAddress(lowAddress)) {
            throw new IllegalArgumentException("Low address must range from 0x0001 to 0x7FFF");
        }
        if (!MeshAddress.isValidUnicastAddress(highAddress)) {
            throw new IllegalArgumentException("High address must range from 0x0001 to 0x7FFF");
        }
        this.lowAddress = lowAddress;
        this.highAddress = highAddress;
    }

    @Ignore
    AllocatedUnicastRange() {
    }

    @Override
    public final int getLowerBound() {
        return this.lowAddress;
    }

    @Override
    public final int getUpperBound() {
        return this.upperBound;
    }

    protected AllocatedUnicastRange(Parcel in) {
        this.lowerBound = in.readInt();
        this.upperBound = in.readInt();
        this.lowAddress = in.readInt();
        this.highAddress = in.readInt();
    }

    @Override
    public int getLowAddress() {
        return this.lowAddress;
    }

    public void setLowAddress(int lowAddress) {
        if (!MeshAddress.isValidUnicastAddress(lowAddress)) {
            throw new IllegalArgumentException("Low address must range from 0x0000 to 0x7FFF");
        }
        this.lowAddress = lowAddress;
    }

    @Override
    public int getHighAddress() {
        return this.highAddress;
    }

    public void setHighAddress(int highAddress) {
        if (!MeshAddress.isValidUnicastAddress(this.lowAddress)) {
            throw new IllegalArgumentException("High address must range from 0x0000 to 0x7FFF");
        }
        this.highAddress = highAddress;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.lowerBound);
        dest.writeInt(this.upperBound);
        dest.writeInt(this.lowAddress);
        dest.writeInt(this.highAddress);
    }
}

