/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.sensorutils;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import no.nordicsemi.android.mesh.sensorutils.DevicePropertyCharacteristic;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class TimeMillisecond24
extends DevicePropertyCharacteristic<Float> {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public TimeMillisecond24(@NonNull byte[] data, int offset) {
        super(data, offset);
        int tempValue = (data[offset + 2] & 0xFF) << 16 | (data[offset + 1] & 0xFF) << 8 | data[offset] & 0xFF;
        if (tempValue == 65535) {
            this.value = null;
        }
        this.value = Float.valueOf((float)tempValue / 1000.0f);
        if (((Float)this.value).floatValue() < 0.0f || (double)((Float)this.value).floatValue() > 16777.214) {
            this.value = null;
        }
    }

    public TimeMillisecond24(float seconds) {
        this.value = Float.valueOf(seconds);
    }

    @NonNull
    public String toString() {
        return this.value == null ? null : this.value + " seconds";
    }

    @Override
    public int getLength() {
        return 3;
    }

    @Override
    public byte[] getBytes() {
        return MeshParserUtils.convertIntTo24Bits((int)(((Float)this.value).floatValue() * 1000.0f));
    }
}

