/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.UUID;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.transport.ApplicationMessage;
import no.nordicsemi.android.mesh.transport.InternalMeshMsgHandlerCallbacks;
import no.nordicsemi.android.mesh.transport.MeshMessage;
import no.nordicsemi.android.mesh.transport.MeshMessageState;
import no.nordicsemi.android.mesh.transport.MeshTransport;
import no.nordicsemi.android.mesh.utils.MeshAddress;

class ApplicationMessageState
extends MeshMessageState {
    UUID mLabel;

    ApplicationMessageState(int src, int dst, @NonNull MeshMessage meshMessage, @NonNull MeshTransport meshTransport, @NonNull InternalMeshMsgHandlerCallbacks callbacks) throws IllegalArgumentException {
        this(src, dst, null, meshMessage, meshTransport, callbacks);
    }

    ApplicationMessageState(int src, int dst, @Nullable UUID label, @NonNull MeshMessage meshMessage, @NonNull MeshTransport meshTransport, @NonNull InternalMeshMsgHandlerCallbacks callbacks) throws IllegalArgumentException {
        super(meshMessage, meshTransport, callbacks);
        this.mSrc = src;
        if (!MeshAddress.isAddressInRange(src)) {
            throw new IllegalArgumentException("Invalid address, a source address must be a valid 16-bit value!");
        }
        this.mDst = dst;
        if (!MeshAddress.isAddressInRange(dst)) {
            throw new IllegalArgumentException("Invalid address, a destination address must be a valid 16-bit value");
        }
        this.mLabel = label;
        this.createAccessMessage();
    }

    protected void createAccessMessage() {
        ApplicationMessage applicationMessage = (ApplicationMessage)this.mMeshMessage;
        ApplicationKey key = applicationMessage.getAppKey();
        int akf = applicationMessage.getAkf();
        int aid = applicationMessage.getAid();
        int aszmic = applicationMessage.getAszmic();
        int opCode = applicationMessage.getOpCode();
        byte[] parameters = applicationMessage.getParameters();
        this.message = this.mMeshTransport.createMeshMessage(this.mSrc, this.mDst, this.mLabel, applicationMessage.messageTtl, key, akf, aid, aszmic, opCode, parameters);
        applicationMessage.setMessage(this.message);
    }

    @Override
    public MeshMessageState.MessageState getState() {
        return MeshMessageState.MessageState.APPLICATION_MESSAGE_STATE;
    }
}

