/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.util.Log;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.transport.ConfigMessage;
import no.nordicsemi.android.mesh.utils.CompositionDataParser;
import no.nordicsemi.android.mesh.utils.MeshAddress;

public class ConfigSigModelAppGet
extends ConfigMessage {
    private static final String TAG = ConfigSigModelAppGet.class.getSimpleName();
    private static final int OP_CODE = 32843;
    private static final int SIG_MODEL_APP_GET_PARAMS_LENGTH = 4;
    private final int elementAddress;
    private final int modelIdentifier;

    public ConfigSigModelAppGet(int elementAddress, int modelIdentifier) throws IllegalArgumentException {
        if (!MeshAddress.isValidUnicastAddress(elementAddress)) {
            throw new IllegalArgumentException("Invalid unicast address, unicast address must be a 16-bit value, and must range from 0x0001 to 0x7FFF");
        }
        this.elementAddress = elementAddress;
        this.modelIdentifier = modelIdentifier;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 32843;
    }

    @Override
    void assembleMessageParameters() {
        Log.v((String)TAG, (String)("Element address: " + MeshAddress.formatAddress(this.elementAddress, true)));
        Log.v((String)TAG, (String)("Model: " + CompositionDataParser.formatModelIdentifier(this.modelIdentifier, false)));
        ByteBuffer paramsBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        paramsBuffer.putShort((short)this.elementAddress);
        paramsBuffer.putShort((short)this.modelIdentifier);
        this.mParameters = paramsBuffer.array();
    }

    public int getElementAddress() {
        return this.elementAddress;
    }

    public int getModelIdentifier() {
        return this.modelIdentifier;
    }
}

