/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

final class AppKeyDeserializer
implements JsonSerializer<List<ApplicationKey>>,
JsonDeserializer<List<ApplicationKey>> {
    private static final String TAG = AppKeyDeserializer.class.getSimpleName();

    AppKeyDeserializer() {
    }

    public JsonElement serialize(List<ApplicationKey> applicationKeys, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray jsonArray = new JsonArray();
        for (ApplicationKey applicationKey : applicationKeys) {
            JsonObject appKeyObject = new JsonObject();
            appKeyObject.addProperty("name", applicationKey.getName());
            appKeyObject.addProperty("index", (Number)applicationKey.getKeyIndex());
            appKeyObject.addProperty("boundNetKey", (Number)applicationKey.getBoundNetKeyIndex());
            appKeyObject.addProperty("key", MeshParserUtils.bytesToHex(applicationKey.getKey(), false));
            if (applicationKey.getOldKey() != null) {
                appKeyObject.addProperty("oldKey", MeshParserUtils.bytesToHex(applicationKey.getOldKey(), false));
            }
            jsonArray.add((JsonElement)appKeyObject);
        }
        return jsonArray;
    }

    public List<ApplicationKey> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ArrayList<ApplicationKey> appKeys = new ArrayList<ApplicationKey>();
        JsonArray jsonArray = json.getAsJsonArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject jsonObject = jsonArray.get(i).getAsJsonObject();
            String name = jsonObject.get("name").getAsString();
            int index = jsonObject.get("index").getAsInt();
            int boundNetKeyIndex = jsonObject.get("boundNetKey").getAsInt();
            byte[] key = MeshParserUtils.toByteArray(jsonObject.get("key").getAsString());
            byte[] oldKey = this.getOldKey(jsonObject);
            ApplicationKey applicationKey = new ApplicationKey(index, key);
            applicationKey.setName(name);
            applicationKey.setBoundNetKeyIndex(boundNetKeyIndex);
            applicationKey.setOldKey(oldKey);
            appKeys.add(applicationKey);
        }
        return appKeys;
    }

    private byte[] getOldKey(JsonObject jsonObject) {
        if (jsonObject.has("oldKey")) {
            return MeshParserUtils.toByteArray(jsonObject.get("oldKey").getAsString());
        }
        return null;
    }
}

