/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import androidx.room.Ignore;
import androidx.room.Index;
import com.google.gson.annotations.Expose;
import no.nordicsemi.android.mesh.MeshKey;
import no.nordicsemi.android.mesh.MeshNetwork;
import no.nordicsemi.android.mesh.utils.SecureUtils;

@Entity(tableName="application_key", foreignKeys={@ForeignKey(entity=MeshNetwork.class, parentColumns={"mesh_uuid"}, childColumns={"mesh_uuid"}, onUpdate=5, onDelete=5)}, indices={@Index(value={"mesh_uuid"})})
public final class ApplicationKey
extends MeshKey {
    @Expose
    @ColumnInfo(name="bound_key_index")
    private int boundNetKeyIndex = 0;
    @Ignore
    private int aid;
    @Ignore
    private int oldAid;
    public static final Parcelable.Creator<ApplicationKey> CREATOR = new Parcelable.Creator<ApplicationKey>(){

        public ApplicationKey createFromParcel(Parcel in) {
            return new ApplicationKey(in);
        }

        public ApplicationKey[] newArray(int size) {
            return new ApplicationKey[size];
        }
    };

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public ApplicationKey(int keyIndex, @NonNull byte[] key) {
        super(keyIndex, key);
        this.name = "Application Key " + (keyIndex + 1);
        this.aid = SecureUtils.calculateK4(key);
    }

    protected ApplicationKey(Parcel in) {
        this.meshUuid = in.readString();
        this.keyIndex = in.readInt();
        this.name = in.readString();
        this.boundNetKeyIndex = in.readInt();
        this.key = in.createByteArray();
        this.aid = in.readInt();
        this.oldKey = in.createByteArray();
        this.oldAid = in.readInt();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.meshUuid);
        dest.writeInt(this.keyIndex);
        dest.writeString(this.name);
        dest.writeInt(this.boundNetKeyIndex);
        dest.writeByteArray(this.key);
        dest.writeInt(this.aid);
        dest.writeByteArray(this.oldKey);
        dest.writeInt(this.oldAid);
    }

    public int describeContents() {
        return 0;
    }

    public int getBoundNetKeyIndex() {
        return this.boundNetKeyIndex;
    }

    public void setBoundNetKeyIndex(int boundNetKeyIndex) {
        this.boundNetKeyIndex = boundNetKeyIndex;
    }

    @Override
    public void setKey(@NonNull byte[] key) {
        super.setKey(key);
        this.aid = SecureUtils.calculateK4(key);
    }

    @Override
    public void setOldKey(byte[] oldKey) {
        super.setOldKey(oldKey);
        if (oldKey != null) {
            this.oldAid = SecureUtils.calculateK4(oldKey);
        }
    }

    public int getAid() {
        return this.aid;
    }

    public int getOldAid() {
        return this.oldAid;
    }

    @Override
    @NonNull
    public ApplicationKey clone() throws CloneNotSupportedException {
        return (ApplicationKey)super.clone();
    }
}

