/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseIntArray;
import androidx.annotation.NonNull;

public final class ImmutableSparseIntArray
implements Parcelable {
    private static final String TAG = "ImmutableSparseIntArray";
    private SparseIntArray array;
    public static final Parcelable.Creator<ImmutableSparseIntArray> CREATOR = new Parcelable.Creator<ImmutableSparseIntArray>(){

        public ImmutableSparseIntArray createFromParcel(Parcel in) {
            return new ImmutableSparseIntArray(in);
        }

        public ImmutableSparseIntArray[] newArray(int size) {
            return new ImmutableSparseIntArray[size];
        }
    };

    public ImmutableSparseIntArray(@NonNull SparseIntArray array) {
        this.array = array;
    }

    protected ImmutableSparseIntArray(Parcel source) {
        this.array = new SparseIntArray();
        int size = source.readInt();
        int[] keys = new int[size];
        int[] values = new int[size];
        source.readIntArray(keys);
        source.readIntArray(values);
        for (int i = 0; i < size; ++i) {
            this.array.put(keys[i], values[i]);
        }
    }

    protected SparseIntArray getArray() {
        return this.array;
    }

    public int size() {
        return this.array.size();
    }

    public int get(int key) {
        return this.array.get(key);
    }

    public int get(int key, int valueIfKeyNotFound) {
        return this.array.get(key, valueIfKeyNotFound);
    }

    public int keyAt(int index) {
        return this.array.keyAt(index);
    }

    public int valueAt(int index) {
        return this.array.valueAt(index);
    }

    public int indexOfValue(int value) {
        return this.array.indexOfValue(value);
    }

    protected void put(int key, int value) {
        this.array.put(key, value);
    }

    protected void delete(int key) {
        this.array.delete(key);
    }

    protected void clear() {
        this.array.clear();
    }

    public String toString() {
        return this.array.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        int[] keys = new int[this.size()];
        int[] values = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            keys[i] = this.keyAt(i);
            values[i] = this.valueAt(i);
        }
        dest.writeInt(this.size());
        dest.writeIntArray(keys);
        dest.writeIntArray(values);
    }
}

