/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.content.ContentResolver;
import android.net.Uri;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import no.nordicsemi.android.mesh.AllocatedGroupRange;
import no.nordicsemi.android.mesh.AllocatedGroupRangeDeserializer;
import no.nordicsemi.android.mesh.AllocatedSceneRange;
import no.nordicsemi.android.mesh.AllocatedSceneRangeDeserializer;
import no.nordicsemi.android.mesh.AllocatedUnicastRange;
import no.nordicsemi.android.mesh.AllocatedUnicastRangeDeserializer;
import no.nordicsemi.android.mesh.AppKeyDeserializer;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.ApplicationKeysConfig;
import no.nordicsemi.android.mesh.Group;
import no.nordicsemi.android.mesh.GroupsConfig;
import no.nordicsemi.android.mesh.MeshNetwork;
import no.nordicsemi.android.mesh.MeshNetworkDeserializer;
import no.nordicsemi.android.mesh.NetKeyDeserializer;
import no.nordicsemi.android.mesh.NetworkKey;
import no.nordicsemi.android.mesh.NetworkKeysConfig;
import no.nordicsemi.android.mesh.NodeKey;
import no.nordicsemi.android.mesh.NodesConfig;
import no.nordicsemi.android.mesh.Provisioner;
import no.nordicsemi.android.mesh.ProvisionersConfig;
import no.nordicsemi.android.mesh.Scene;
import no.nordicsemi.android.mesh.ScenesConfig;
import no.nordicsemi.android.mesh.transport.Element;
import no.nordicsemi.android.mesh.transport.InternalElementListDeserializer;
import no.nordicsemi.android.mesh.transport.MeshModel;
import no.nordicsemi.android.mesh.transport.MeshModelListDeserializer;
import no.nordicsemi.android.mesh.transport.NodeDeserializer;
import no.nordicsemi.android.mesh.transport.ProvisionedMeshNode;
import no.nordicsemi.android.mesh.utils.MeshAddress;

class ImportExportUtils {
    private static final String TAG = ImportExportUtils.class.getSimpleName();
    private final Gson mGson = this.initGson();

    ImportExportUtils() {
    }

    private Gson initGson() {
        Type netKeyList = new TypeToken<List<NetworkKey>>(){}.getType();
        Type appKeyList = new TypeToken<List<ApplicationKey>>(){}.getType();
        Type allocatedUnicastRange = new TypeToken<List<AllocatedUnicastRange>>(){}.getType();
        Type allocatedGroupRange = new TypeToken<List<AllocatedGroupRange>>(){}.getType();
        Type allocatedSceneRange = new TypeToken<List<AllocatedSceneRange>>(){}.getType();
        Type nodeList = new TypeToken<List<ProvisionedMeshNode>>(){}.getType();
        Type meshModelList = new TypeToken<List<MeshModel>>(){}.getType();
        Type elementList = new TypeToken<List<Element>>(){}.getType();
        return new GsonBuilder().registerTypeAdapter(netKeyList, (Object)new NetKeyDeserializer()).registerTypeAdapter(appKeyList, (Object)new AppKeyDeserializer()).registerTypeAdapter(allocatedUnicastRange, (Object)new AllocatedUnicastRangeDeserializer()).registerTypeAdapter(allocatedGroupRange, (Object)new AllocatedGroupRangeDeserializer()).registerTypeAdapter(allocatedSceneRange, (Object)new AllocatedSceneRangeDeserializer()).registerTypeAdapter(nodeList, (Object)new NodeDeserializer()).registerTypeAdapter(elementList, (Object)new InternalElementListDeserializer()).registerTypeAdapter(meshModelList, (Object)new MeshModelListDeserializer()).registerTypeAdapter(MeshNetwork.class, (Object)new MeshNetworkDeserializer()).serializeNulls().setPrettyPrinting().create();
    }

    protected MeshNetwork importNetwork(@NonNull String networkJson) throws JsonSyntaxException {
        return (MeshNetwork)this.mGson.fromJson(networkJson, MeshNetwork.class);
    }

    protected String readJsonStringFromUri(@NonNull ContentResolver contentResolver, @NonNull Uri uri) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        InputStream inputStream = contentResolver.openInputStream(uri);
        if (inputStream != null) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
            reader.close();
            inputStream.close();
        }
        return stringBuilder.toString();
    }

    @Nullable
    protected String export(@NonNull MeshNetwork network, boolean partial) {
        try {
            network.setPartial(partial);
            return this.mGson.toJson((Object)network);
        }
        catch (JsonSyntaxException ex) {
            Log.e((String)TAG, (String)("Error: " + ex.getMessage()));
            return null;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error: " + e.getMessage()));
            return null;
        }
    }

    @Nullable
    protected String export(@NonNull MeshNetwork network, @NonNull NetworkKeysConfig networkKeysConfig, @NonNull ApplicationKeysConfig applicationKeysConfig, @NonNull NodesConfig nodesConfig, @NonNull ProvisionersConfig provisionersConfig, @NonNull GroupsConfig groupsConfig, @NonNull ScenesConfig scenesConfig) {
        MeshNetwork temp = (MeshNetwork)this.mGson.fromJson(this.mGson.toJson((Object)network), MeshNetwork.class);
        return this.export(this.prepareNetwork(temp, networkKeysConfig, applicationKeysConfig, nodesConfig, provisionersConfig, groupsConfig, scenesConfig), true);
    }

    private MeshNetwork prepareNetwork(@NonNull MeshNetwork network, @NonNull NetworkKeysConfig networkKeysConfig, @NonNull ApplicationKeysConfig applicationKeysConfig, @NonNull NodesConfig nodesConfig, @NonNull ProvisionersConfig provisionersConfig, @NonNull GroupsConfig groupsConfig, @NonNull ScenesConfig scenesConfig) {
        if (nodesConfig.getConfig() instanceof NodesConfig.ExportWithoutDeviceKey) {
            for (ProvisionedMeshNode node : network.nodes) {
                node.setDeviceKey(null);
            }
        } else if (nodesConfig.getConfig() instanceof NodesConfig.ExportSome) {
            network.nodes.clear();
            List<ProvisionedMeshNode> withDeviceKey = ((NodesConfig.ExportSome)nodesConfig.getConfig()).getWithDeviceKey();
            List<ProvisionedMeshNode> withoutDeviceKey = ((NodesConfig.ExportSome)nodesConfig.getConfig()).getWithoutDeviceKey();
            for (ProvisionedMeshNode node : withoutDeviceKey) {
                node.setDeviceKey(null);
            }
            network.nodes.addAll(withDeviceKey);
            network.nodes.addAll(withoutDeviceKey);
            for (Provisioner provisioner : network.provisioners) {
                if (this.isProvisionerExistsInNodes(provisioner, network.nodes)) continue;
                network.nodes.add(new ProvisionedMeshNode(provisioner, network.netKeys, network.appKeys));
            }
        }
        if (provisionersConfig.getConfig() instanceof ProvisionersConfig.ExportSome) {
            ListIterator provisionerListIterator = network.provisioners.listIterator();
            while (provisionerListIterator.hasNext()) {
                Provisioner provisioner = (Provisioner)provisionerListIterator.next();
                if (this.isProvisionerExistsInNodes(provisioner, network.nodes)) continue;
                provisionerListIterator.remove();
            }
            List<Provisioner> selectedProvisioners = ((ProvisionersConfig.ExportSome)provisionersConfig.getConfig()).getProvisioners();
            Iterator<Object> iterator = selectedProvisioners.iterator();
            while (iterator.hasNext()) {
                Provisioner provisioner;
                provisioner = (Provisioner)iterator.next();
                if (network.isProvisionerUuidInUse(provisioner.getProvisionerUuid())) continue;
                network.provisioners.add(provisioner);
            }
        }
        if (networkKeysConfig.getConfig() instanceof NetworkKeysConfig.ExportSome) {
            network.setNetKeys(((NetworkKeysConfig.ExportSome)networkKeysConfig.getConfig()).getKeys());
        }
        if (applicationKeysConfig.getConfig() instanceof ApplicationKeysConfig.ExportSome) {
            network.appKeys.clear();
            List<ApplicationKey> keys = ((ApplicationKeysConfig.ExportSome)applicationKeysConfig.getConfig()).getKeys();
            for (ApplicationKey key : keys) {
                if (!this.isApplicationKeyBound(network.getNetKeys(), key)) continue;
                network.appKeys.add(key);
            }
        }
        ListIterator nodeListIterator = network.nodes.listIterator();
        while (nodeListIterator.hasNext()) {
            ProvisionedMeshNode node;
            node = (ProvisionedMeshNode)nodeListIterator.next();
            if (!this.isNetworkKeyAdded(node, network.getNetKeys())) {
                nodeListIterator.remove();
                continue;
            }
            this.excludeAppKeys(node, network.appKeys);
        }
        if (groupsConfig.getConfig() instanceof GroupsConfig.ExportRelated) {
            this.excludeNonRelatedGroups(network);
        } else if (groupsConfig.getConfig() instanceof GroupsConfig.ExportSome) {
            network.groups = ((GroupsConfig.ExportSome)groupsConfig.getConfig()).getGroups();
            for (ProvisionedMeshNode node : network.getNodes()) {
                for (Element element : node.getElements().values()) {
                    for (MeshModel model : element.getMeshModels().values()) {
                        for (Group group : network.groups) {
                            if (model.getPublicationSettings() != null && MeshAddress.isValidGroupAddress(model.getPublicationSettings().getPublishAddress()) && model.getPublicationSettings().getPublishAddress() != group.getAddress()) {
                                model.setPublicationSettings(null);
                            }
                            model.getSubscribedAddresses().remove((Object)group.getAddress());
                        }
                    }
                }
            }
        }
        if (scenesConfig.getConfig() instanceof ScenesConfig.ExportSome) {
            network.scenes = ((ScenesConfig.ExportSome)scenesConfig.getConfig()).getScenes();
        }
        this.removeExcludedNodesFromScenes(network.nodes, network.scenes);
        return network;
    }

    private boolean isProvisionerExistsInNodes(@NonNull Provisioner provisioner, @NonNull List<ProvisionedMeshNode> nodes) {
        if (provisioner.getProvisionerAddress() != null) {
            for (ProvisionedMeshNode node : nodes) {
                if (!node.getUuid().equalsIgnoreCase(provisioner.getProvisionerUuid())) continue;
                return true;
            }
        }
        return false;
    }

    private void excludeNonRelatedGroups(@NonNull MeshNetwork network) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Group group : network.getGroups()) {
            for (ProvisionedMeshNode node : network.getNodes()) {
                if (!this.isGroupInUse(node, group)) continue;
                groups.add(group);
            }
        }
        network.groups = groups;
    }

    private boolean isGroupInUse(@NonNull ProvisionedMeshNode node, @NonNull Group group) {
        for (Element element : node.getElements().values()) {
            for (MeshModel model : element.getMeshModels().values()) {
                if (model.getPublicationSettings().getPublishAddress() != group.getAddress() && !model.getSubscribedAddresses().contains(group.getAddress())) continue;
                return true;
            }
        }
        return false;
    }

    private void removeExcludedNodesFromScenes(@NonNull List<ProvisionedMeshNode> nodes, @NonNull List<Scene> scenes) {
        for (Scene scene : scenes) {
            ListIterator<Integer> addresses = scene.getAddresses().listIterator();
            while (addresses.hasNext()) {
                Integer address = addresses.next();
                if (this.isNodeAddressExistsInScene(nodes, address)) continue;
                addresses.remove();
            }
        }
    }

    private boolean isNodeAddressExistsInScene(@NonNull List<ProvisionedMeshNode> nodes, @NonNull Integer address) {
        for (ProvisionedMeshNode node : nodes) {
            if (address.intValue() != node.getUnicastAddress()) continue;
            return true;
        }
        return false;
    }

    private void excludeAppKeys(@NonNull ProvisionedMeshNode node, @NonNull List<ApplicationKey> applicationKeys) {
        for (Element element : node.getElements().values()) {
            for (MeshModel model : element.getMeshModels().values()) {
                ListIterator<Integer> boundKeyIndexes = model.getBoundAppKeyIndexes().listIterator();
                while (boundKeyIndexes.hasNext()) {
                    int index = boundKeyIndexes.next();
                    if (this.isApplicationKeyBound(index, applicationKeys)) continue;
                    boundKeyIndexes.remove();
                    if (model.getPublicationSettings() == null || model.getPublicationSettings().getAppKeyIndex() != index) continue;
                    model.setPublicationSettings(null);
                }
            }
        }
    }

    private boolean isApplicationKeyBound(@NonNull List<NetworkKey> networkKeys, @NonNull ApplicationKey applicationKey) {
        for (NetworkKey networkKey : networkKeys) {
            if (networkKey.keyIndex != applicationKey.keyIndex) continue;
            return true;
        }
        return false;
    }

    private boolean isApplicationKeyBound(@NonNull Integer index, @NonNull List<ApplicationKey> keys) {
        for (ApplicationKey key : keys) {
            if (index.intValue() != key.getKeyIndex()) continue;
            return true;
        }
        return false;
    }

    private boolean isNetworkKeyAdded(@NonNull ProvisionedMeshNode node, @NonNull List<NetworkKey> networkKeys) {
        for (NetworkKey networkKey : networkKeys) {
            for (NodeKey nodeKey : node.getAddedNetKeys()) {
                if (nodeKey.getIndex() != networkKey.getKeyIndex()) continue;
                return true;
            }
        }
        return false;
    }
}

