/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import no.nordicsemi.android.mesh.NetworkKey;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

final class NetKeyDeserializer
implements JsonSerializer<List<NetworkKey>>,
JsonDeserializer<List<NetworkKey>> {
    private static final String TAG = NetKeyDeserializer.class.getSimpleName();

    NetKeyDeserializer() {
    }

    public JsonElement serialize(List<NetworkKey> networkKeys, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray jsonArray = new JsonArray();
        for (NetworkKey networkKey : networkKeys) {
            JsonObject networkKeyObject = new JsonObject();
            networkKeyObject.addProperty("name", networkKey.getName());
            networkKeyObject.addProperty("index", (Number)networkKey.getKeyIndex());
            networkKeyObject.addProperty("key", MeshParserUtils.bytesToHex(networkKey.getKey(), false));
            if (networkKey.getOldKey() != null) {
                networkKeyObject.addProperty("oldKey", MeshParserUtils.bytesToHex(networkKey.getOldKey(), false));
            }
            networkKeyObject.addProperty("phase", (Number)networkKey.getPhase());
            networkKeyObject.addProperty("minSecurity", networkKey.isMinSecurity() ? "secure" : "insecure");
            networkKeyObject.addProperty("timestamp", MeshParserUtils.formatTimeStamp(networkKey.getTimestamp()));
            jsonArray.add((JsonElement)networkKeyObject);
        }
        return jsonArray;
    }

    public List<NetworkKey> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ArrayList<NetworkKey> networkKeys = new ArrayList<NetworkKey>();
        JsonArray jsonArray = json.getAsJsonArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            long timestamp;
            JsonObject jsonObject = jsonArray.get(i).getAsJsonObject();
            String name = jsonObject.get("name").getAsString();
            int index = jsonObject.get("index").getAsInt();
            byte[] key = MeshParserUtils.toByteArray(jsonObject.get("key").getAsString());
            byte[] oldKey = this.getOldKey(jsonObject);
            int phase = jsonObject.get("phase").getAsInt();
            String minSec = jsonObject.get("minSecurity").getAsString();
            boolean minSecurity = true;
            if (!minSec.equalsIgnoreCase("low") && minSec.equalsIgnoreCase("insecure")) {
                minSecurity = false;
            }
            try {
                timestamp = 0L;
            }
            catch (Exception e) {
                throw new JsonSyntaxException("Invalid Mesh Provisioning/Configuration Database, mesh network timestamp must follow the Mesh Provisioning/Configuration Database format.");
            }
            NetworkKey networkKey = new NetworkKey(index, key);
            networkKey.setName(name);
            networkKey.setPhase(phase);
            networkKey.setMinSecurity(minSecurity);
            networkKey.setOldKey(oldKey);
            networkKey.setTimestamp(timestamp);
            networkKeys.add(networkKey);
        }
        return networkKeys;
    }

    private byte[] getOldKey(JsonObject jsonObject) {
        if (jsonObject.has("oldKey")) {
            return MeshParserUtils.toByteArray(jsonObject.get("oldKey").getAsString());
        }
        return null;
    }
}

