/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import androidx.room.Ignore;
import androidx.room.Index;
import com.google.gson.annotations.Expose;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import no.nordicsemi.android.mesh.MeshKey;
import no.nordicsemi.android.mesh.MeshNetwork;
import no.nordicsemi.android.mesh.utils.SecureUtils;

@Entity(tableName="network_key", foreignKeys={@ForeignKey(entity=MeshNetwork.class, parentColumns={"mesh_uuid"}, childColumns={"mesh_uuid"}, onUpdate=5, onDelete=5)}, indices={@Index(value={"mesh_uuid"})})
public final class NetworkKey
extends MeshKey {
    public static final int NORMAL_OPERATION = 0;
    public static final int KEY_DISTRIBUTION = 1;
    public static final int USING_NEW_KEYS = 2;
    public static final int USE_NEW_KEYS = 2;
    public static final int REVOKE_OLD_KEYS = 3;
    @Expose
    @ColumnInfo(name="phase")
    private int phase = 0;
    @Expose
    @ColumnInfo(name="security")
    private boolean minSecurity;
    @Expose
    @ColumnInfo(name="timestamp")
    private long timestamp;
    @Ignore
    private byte[] identityKey;
    @Ignore
    private byte[] oldIdentityKey;
    @Ignore
    private SecureUtils.K2Output derivatives;
    @Ignore
    private SecureUtils.K2Output oldDerivatives;
    public static final Parcelable.Creator<NetworkKey> CREATOR = new Parcelable.Creator<NetworkKey>(){

        public NetworkKey createFromParcel(Parcel in) {
            return new NetworkKey(in);
        }

        public NetworkKey[] newArray(int size) {
            return new NetworkKey[size];
        }
    };

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public NetworkKey(int keyIndex, @NonNull byte[] key) {
        super(keyIndex, key);
        this.name = "Network Key " + (keyIndex + 1);
        this.identityKey = SecureUtils.calculateIdentityKey(key);
        this.derivatives = SecureUtils.calculateK2(key, SecureUtils.K2_MASTER_INPUT);
        this.timestamp = System.currentTimeMillis();
    }

    protected NetworkKey(Parcel in) {
        this.meshUuid = in.readString();
        this.keyIndex = in.readInt();
        this.name = in.readString();
        this.key = in.createByteArray();
        this.phase = in.readInt();
        this.minSecurity = in.readByte() != 0;
        this.oldKey = in.createByteArray();
        this.identityKey = in.createByteArray();
        this.oldIdentityKey = in.createByteArray();
        this.derivatives = (SecureUtils.K2Output)in.readParcelable(SecureUtils.K2Output.class.getClassLoader());
        this.oldDerivatives = (SecureUtils.K2Output)in.readParcelable(SecureUtils.K2Output.class.getClassLoader());
        this.timestamp = in.readLong();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.meshUuid);
        dest.writeInt(this.keyIndex);
        dest.writeString(this.name);
        dest.writeByteArray(this.key);
        dest.writeInt(this.phase);
        dest.writeByte((byte)(this.minSecurity ? 1 : 0));
        dest.writeByteArray(this.oldKey);
        dest.writeByteArray(this.identityKey);
        dest.writeByteArray(this.oldIdentityKey);
        dest.writeParcelable((Parcelable)this.derivatives, flags);
        dest.writeParcelable((Parcelable)this.oldDerivatives, flags);
        dest.writeLong(this.timestamp);
    }

    public int describeContents() {
        return 0;
    }

    public int getPhase() {
        return this.phase;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setPhase(int phase) {
        this.phase = phase;
    }

    @Override
    public void setKey(@NonNull byte[] key) {
        super.setKey(key);
        this.identityKey = SecureUtils.calculateIdentityKey(key);
        this.derivatives = SecureUtils.calculateK2(key, SecureUtils.K2_MASTER_INPUT);
    }

    @Override
    public void setOldKey(byte[] oldKey) {
        super.setOldKey(oldKey);
        this.oldIdentityKey = SecureUtils.calculateIdentityKey(oldKey);
        this.oldDerivatives = SecureUtils.calculateK2(oldKey, SecureUtils.K2_MASTER_INPUT);
    }

    public byte[] getTxNetworkKey() {
        switch (this.phase) {
            case 1: {
                return this.oldKey;
            }
        }
        return this.key;
    }

    public SecureUtils.K2Output getTxDerivatives() {
        switch (this.phase) {
            case 1: {
                return this.oldDerivatives;
            }
        }
        return this.derivatives;
    }

    public boolean isMinSecurity() {
        return this.minSecurity;
    }

    public void setMinSecurity(boolean minSecurity) {
        this.minSecurity = minSecurity;
    }

    public byte[] getIdentityKey() {
        return this.identityKey;
    }

    public byte[] getOldIdentityKey() {
        return this.oldIdentityKey;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getPhaseDescription() {
        switch (this.phase) {
            default: {
                return "Normal Operation";
            }
            case 1: {
                return "Key Distribution";
            }
            case 2: 
        }
        return "Using New Keys";
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    @NonNull
    public NetworkKey clone() throws CloneNotSupportedException {
        return (NetworkKey)super.clone();
    }

    @Override
    protected boolean distributeKey(@NonNull byte[] newKey) throws IllegalArgumentException {
        if (this.valid(newKey)) {
            if (this.phase == 0 || this.phase == 1) {
                this.phase = 1;
                this.timestamp = System.currentTimeMillis();
                return super.distributeKey(newKey);
            }
            throw new IllegalArgumentException("A NetworkKey can only be updated once during a Key Refresh Procedure.");
        }
        return false;
    }

    protected boolean switchToNewKey() {
        if (this.phase == 1) {
            this.setPhase(2);
            this.timestamp = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    protected boolean revokeOldKey() {
        if (this.phase == 1 || this.phase == 2) {
            this.phase = 0;
            this.timestamp = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    protected byte[] getNetworkId() {
        return SecureUtils.calculateK3(this.key);
    }

    @Nullable
    protected byte[] getOldNetworkId() {
        return SecureUtils.calculateK3(this.oldKey);
    }

    public SecureUtils.K2Output getDerivatives() {
        return this.derivatives;
    }

    @Nullable
    public SecureUtils.K2Output getOldDerivatives() {
        return this.oldDerivatives;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface KeyRefreshPhaseTransition {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface KeyRefreshPhase {
    }
}

