/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import androidx.room.Ignore;
import androidx.room.Index;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import no.nordicsemi.android.mesh.AddressRange;
import no.nordicsemi.android.mesh.AllocatedGroupRange;
import no.nordicsemi.android.mesh.AllocatedSceneRange;
import no.nordicsemi.android.mesh.AllocatedUnicastRange;
import no.nordicsemi.android.mesh.MeshNetwork;
import no.nordicsemi.android.mesh.MeshTypeConverters;
import no.nordicsemi.android.mesh.Range;
import no.nordicsemi.android.mesh.transport.ProvisionedMeshNode;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

@Entity(tableName="provisioner", foreignKeys={@ForeignKey(entity=MeshNetwork.class, parentColumns={"mesh_uuid"}, childColumns={"mesh_uuid"}, onUpdate=5, onDelete=5)}, indices={@Index(value={"mesh_uuid"})})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class Provisioner
implements Parcelable {
    @Expose
    @ColumnInfo(name="mesh_uuid")
    @NonNull
    private String meshUuid;
    @Expose
    @PrimaryKey
    @NonNull
    @ColumnInfo(name="provisioner_uuid")
    private String provisionerUuid;
    @Expose
    @ColumnInfo(name="name")
    private String provisionerName = "nRF Mesh Provisioner";
    @Expose
    @ColumnInfo(name="allocated_unicast_ranges")
    @TypeConverters(value={MeshTypeConverters.class})
    @NonNull
    List<AllocatedUnicastRange> allocatedUnicastRanges = new ArrayList<AllocatedUnicastRange>();
    @Expose
    @ColumnInfo(name="allocated_group_ranges")
    @TypeConverters(value={MeshTypeConverters.class})
    @NonNull
    List<AllocatedGroupRange> allocatedGroupRanges = new ArrayList<AllocatedGroupRange>();
    @Expose
    @ColumnInfo(name="allocated_scene_ranges")
    @TypeConverters(value={MeshTypeConverters.class})
    @NonNull
    List<AllocatedSceneRange> allocatedSceneRanges = new ArrayList<AllocatedSceneRange>();
    @Expose
    @ColumnInfo(name="provisioner_address")
    private Integer provisionerAddress = null;
    @Expose
    @ColumnInfo(name="global_ttl")
    private int globalTtl = 5;
    @Expose
    @ColumnInfo(name="last_selected")
    private boolean lastSelected;
    @Ignore
    private final Comparator<AddressRange> addressRangeComparator = (addressRange1, addressRange2) -> Integer.compare(addressRange1.getLowAddress(), addressRange2.getLowAddress());
    @Ignore
    private final Comparator<AllocatedSceneRange> sceneRangeComparator = (sceneRange1, sceneRange2) -> Integer.compare(sceneRange1.getFirstScene(), sceneRange2.getFirstScene());
    public static final Parcelable.Creator<Provisioner> CREATOR = new Parcelable.Creator<Provisioner>(){

        public Provisioner createFromParcel(Parcel in) {
            return new Provisioner(in);
        }

        public Provisioner[] newArray(int size) {
            return new Provisioner[size];
        }
    };

    public Provisioner(@NonNull String provisionerUuid, @NonNull List<AllocatedUnicastRange> allocatedUnicastRanges, @NonNull List<AllocatedGroupRange> allocatedGroupRanges, @NonNull List<AllocatedSceneRange> allocatedSceneRanges, @NonNull String meshUuid) {
        this.provisionerUuid = provisionerUuid.toUpperCase(Locale.US);
        this.allocatedUnicastRanges = allocatedUnicastRanges;
        this.allocatedGroupRanges = allocatedGroupRanges;
        this.allocatedSceneRanges = allocatedSceneRanges;
        this.meshUuid = meshUuid;
    }

    protected Provisioner(Parcel in) {
        this.meshUuid = in.readString();
        this.provisionerUuid = in.readString();
        this.provisionerName = in.readString();
        in.readTypedList(this.allocatedUnicastRanges, AllocatedUnicastRange.CREATOR);
        in.readTypedList(this.allocatedGroupRanges, AllocatedGroupRange.CREATOR);
        in.readTypedList(this.allocatedSceneRanges, AllocatedSceneRange.CREATOR);
        this.provisionerAddress = in.readInt();
        this.globalTtl = in.readInt();
        this.lastSelected = in.readByte() != 0;
    }

    @NonNull
    public String getMeshUuid() {
        return this.meshUuid;
    }

    public void setMeshUuid(@NonNull String uuid) {
        this.meshUuid = uuid;
    }

    public String getProvisionerName() {
        return this.provisionerName;
    }

    public void setProvisionerName(@NonNull String provisionerName) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)provisionerName)) {
            throw new IllegalArgumentException("Name cannot be empty");
        }
        this.provisionerName = provisionerName;
    }

    @NonNull
    public String getProvisionerUuid() {
        return this.provisionerUuid;
    }

    public void setProvisionerUuid(@NonNull String provisionerUuid) {
        this.provisionerUuid = provisionerUuid;
    }

    public List<AllocatedGroupRange> getAllocatedGroupRanges() {
        return Collections.unmodifiableList(this.allocatedGroupRanges);
    }

    public void setAllocatedGroupRanges(@NonNull List<AllocatedGroupRange> allocatedGroupRanges) {
        this.allocatedGroupRanges = allocatedGroupRanges;
    }

    public List<AllocatedUnicastRange> getAllocatedUnicastRanges() {
        return Collections.unmodifiableList(this.allocatedUnicastRanges);
    }

    public void setAllocatedUnicastRanges(@NonNull List<AllocatedUnicastRange> allocatedUnicastRanges) {
        this.allocatedUnicastRanges = allocatedUnicastRanges;
    }

    public List<AllocatedSceneRange> getAllocatedSceneRanges() {
        return Collections.unmodifiableList(this.allocatedSceneRanges);
    }

    public void setAllocatedSceneRanges(@NonNull List<AllocatedSceneRange> allocatedSceneRanges) {
        this.allocatedSceneRanges = allocatedSceneRanges;
    }

    @Nullable
    public Integer getProvisionerAddress() {
        return this.provisionerAddress;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setProvisionerAddress(@Nullable Integer address) throws IllegalArgumentException {
        if (address != null && !MeshAddress.isValidUnicastAddress(address)) {
            throw new IllegalArgumentException("Unicast address must range between 0x0001 to 0x7FFF.");
        }
        this.provisionerAddress = address;
    }

    public boolean assignProvisionerAddress(@Nullable Integer address) throws IllegalArgumentException {
        if (address != null && !MeshAddress.isValidUnicastAddress(address)) {
            throw new IllegalArgumentException("Unicast address must range between 0x0001 to 0x7FFF.");
        }
        if (this.isAddressWithinAllocatedRange(address)) {
            this.provisionerAddress = address;
            return true;
        }
        throw new IllegalArgumentException("Address must be within the allocated address range.");
    }

    public int getGlobalTtl() {
        return this.globalTtl;
    }

    public boolean supportsConfiguration() {
        return this.provisionerAddress != null;
    }

    public void setGlobalTtl(int ttl) throws IllegalArgumentException {
        if (!MeshParserUtils.isValidTtl(ttl)) {
            throw new IllegalArgumentException("Invalid ttl, ttl must range from 0 - 127");
        }
        this.globalTtl = ttl;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean isLastSelected() {
        return this.lastSelected;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setLastSelected(boolean lastSelected) {
        this.lastSelected = lastSelected;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.meshUuid);
        parcel.writeString(this.provisionerUuid);
        parcel.writeString(this.provisionerName);
        parcel.writeTypedList(this.allocatedUnicastRanges);
        parcel.writeTypedList(this.allocatedGroupRanges);
        parcel.writeTypedList(this.allocatedSceneRanges);
        parcel.writeInt(this.provisionerAddress.intValue());
        parcel.writeInt(this.globalTtl);
        parcel.writeByte((byte)(this.lastSelected ? 1 : 0));
    }

    public boolean addRange(@NonNull Range allocatedRange) {
        if (allocatedRange instanceof AllocatedUnicastRange) {
            this.allocatedUnicastRanges.add((AllocatedUnicastRange)allocatedRange);
            ArrayList<AllocatedUnicastRange> ranges = new ArrayList<AllocatedUnicastRange>(this.allocatedUnicastRanges);
            Collections.sort(ranges, this.addressRangeComparator);
            this.allocatedUnicastRanges.clear();
            this.allocatedUnicastRanges.addAll(Range.mergeUnicastRanges(ranges));
            return true;
        }
        if (allocatedRange instanceof AllocatedGroupRange) {
            this.allocatedGroupRanges.add((AllocatedGroupRange)allocatedRange);
            ArrayList<AllocatedGroupRange> ranges = new ArrayList<AllocatedGroupRange>(this.allocatedGroupRanges);
            Collections.sort(ranges, this.addressRangeComparator);
            this.allocatedGroupRanges.clear();
            this.allocatedGroupRanges.addAll(Range.mergeGroupRanges(ranges));
            return true;
        }
        if (allocatedRange instanceof AllocatedSceneRange) {
            this.allocatedSceneRanges.add((AllocatedSceneRange)allocatedRange);
            ArrayList<AllocatedSceneRange> ranges = new ArrayList<AllocatedSceneRange>(this.allocatedSceneRanges);
            Collections.sort(this.allocatedSceneRanges, this.sceneRangeComparator);
            this.allocatedSceneRanges.clear();
            this.allocatedSceneRanges.addAll(Range.mergeSceneRanges(ranges));
            return true;
        }
        return false;
    }

    public boolean removeRange(@NonNull Range range) {
        if (range instanceof AllocatedUnicastRange) {
            return this.allocatedUnicastRanges.remove(range);
        }
        if (range instanceof AllocatedGroupRange) {
            return this.allocatedGroupRanges.remove(range);
        }
        if (range instanceof AllocatedSceneRange) {
            return this.allocatedSceneRanges.remove(range);
        }
        return false;
    }

    boolean isAddressWithinAllocatedRange(Integer address) throws IllegalArgumentException {
        if (address == null) {
            return true;
        }
        if (!MeshAddress.isValidUnicastAddress(address)) {
            throw new IllegalArgumentException("Unicast address must range from 0x0001 - 0x7FFF");
        }
        for (AllocatedUnicastRange range : this.allocatedUnicastRanges) {
            if (address < range.getLowAddress() || address > range.getHighAddress()) continue;
            return true;
        }
        return false;
    }

    public boolean hasOverlappingUnicastRanges(@NonNull List<AllocatedUnicastRange> otherRanges) {
        for (AllocatedUnicastRange range : this.allocatedUnicastRanges) {
            for (AllocatedUnicastRange other : otherRanges) {
                if (!range.overlaps(other)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasOverlappingGroupRanges(@NonNull List<AllocatedGroupRange> otherRanges) {
        for (AllocatedGroupRange range : this.allocatedGroupRanges) {
            for (AllocatedGroupRange other : otherRanges) {
                if (!range.overlaps(other)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasOverlappingSceneRanges(@NonNull List<AllocatedSceneRange> otherRanges) {
        for (AllocatedSceneRange range : this.allocatedSceneRanges) {
            for (AllocatedSceneRange other : otherRanges) {
                if (!range.overlaps(other)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isNodeAddressInUse(@NonNull List<ProvisionedMeshNode> nodes) {
        if (this.provisionerAddress == null) {
            return false;
        }
        for (ProvisionedMeshNode node : nodes) {
            if (node.getUuid().equalsIgnoreCase(this.provisionerUuid) || node.getUnicastAddress() != this.provisionerAddress.intValue()) continue;
            return true;
        }
        return false;
    }
}

