/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.util.UUID;
import no.nordicsemi.android.mesh.MeshBeacon;

public class UnprovisionedBeacon
extends MeshBeacon {
    private static final int BEACON_DATA_LENGTH = 19;
    private static final int OOB_INDEX = 17;
    private static final int URI_HASH_INDEX = 19;
    private final UUID uuid;
    private final byte[] oobInformation = new byte[2];
    private final byte[] uriHash = new byte[4];
    public static final Parcelable.Creator<UnprovisionedBeacon> CREATOR = new Parcelable.Creator<UnprovisionedBeacon>(){

        public UnprovisionedBeacon createFromParcel(Parcel source) {
            return new UnprovisionedBeacon(source.createByteArray());
        }

        public UnprovisionedBeacon[] newArray(int size) {
            return new UnprovisionedBeacon[size];
        }
    };

    UnprovisionedBeacon(@NonNull byte[] beaconData) {
        super(beaconData);
        if (beaconData.length < 19) {
            throw new IllegalArgumentException("Invalid unprovisioned beacon data");
        }
        ByteBuffer buffer = ByteBuffer.wrap(beaconData);
        buffer.position(1);
        long msb = buffer.getLong();
        long lsb = buffer.getLong();
        this.uuid = new UUID(msb, lsb);
        buffer.get(this.oobInformation, 0, 2);
        if (buffer.remaining() == 4) {
            buffer.get(this.uriHash, 0, 4);
        }
    }

    @Override
    public int getBeaconType() {
        return this.beaconType;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public byte[] getOobInformation() {
        return this.oobInformation;
    }

    public byte[] getUriHash() {
        return this.uriHash;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByteArray(this.beaconData);
    }
}

