/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.data;

import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.SharedSQLiteStatement;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.Collections;
import java.util.List;
import no.nordicsemi.android.mesh.Group;
import no.nordicsemi.android.mesh.MeshTypeConverters;
import no.nordicsemi.android.mesh.data.GroupDao;

public final class GroupDao_Impl
implements GroupDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Group> __insertionAdapterOfGroup;
    private final MeshTypeConverters __meshTypeConverters = new MeshTypeConverters();
    private final EntityDeletionOrUpdateAdapter<Group> __updateAdapterOfGroup;
    private final SharedSQLiteStatement __preparedStmtOfDelete;

    public GroupDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfGroup = new EntityInsertionAdapter<Group>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `groups` (`id`,`name`,`group_address`,`group_address_label`,`parent_address`,`parent_address_label`,`mesh_uuid`) VALUES (nullif(?, 0),?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Group value) {
                stmt.bindLong(1, (long)value.id);
                if (value.getName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getName());
                }
                stmt.bindLong(3, (long)value.getAddress());
                String _tmp = GroupDao_Impl.this.__meshTypeConverters.uuidToJson(value.getAddressLabel());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                stmt.bindLong(5, (long)value.getParentAddress());
                String _tmp_1 = GroupDao_Impl.this.__meshTypeConverters.uuidToJson(value.getParentAddressLabel());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_1);
                }
                if (value.getMeshUuid() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getMeshUuid());
                }
            }
        };
        this.__updateAdapterOfGroup = new EntityDeletionOrUpdateAdapter<Group>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `groups` SET `id` = ?,`name` = ?,`group_address` = ?,`group_address_label` = ?,`parent_address` = ?,`parent_address_label` = ?,`mesh_uuid` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Group value) {
                stmt.bindLong(1, (long)value.id);
                if (value.getName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getName());
                }
                stmt.bindLong(3, (long)value.getAddress());
                String _tmp = GroupDao_Impl.this.__meshTypeConverters.uuidToJson(value.getAddressLabel());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                stmt.bindLong(5, (long)value.getParentAddress());
                String _tmp_1 = GroupDao_Impl.this.__meshTypeConverters.uuidToJson(value.getParentAddressLabel());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_1);
                }
                if (value.getMeshUuid() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getMeshUuid());
                }
                stmt.bindLong(8, (long)value.id);
            }
        };
        this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM groups WHERE `group_address` = ?";
                return "DELETE FROM groups WHERE `group_address` = ?";
            }
        };
    }

    @Override
    public void insert(Group group) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfGroup.insert((Object)group);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(Group group) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfGroup.handle((Object)group);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(int groupAddress) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDelete.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)groupAddress);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDelete.release(_stmt);
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

