/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.data;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import no.nordicsemi.android.mesh.Group;
import no.nordicsemi.android.mesh.MeshTypeConverters;
import no.nordicsemi.android.mesh.data.GroupsDao;

public final class GroupsDao_Impl
implements GroupsDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Group> __insertionAdapterOfGroup;
    private final MeshTypeConverters __meshTypeConverters = new MeshTypeConverters();
    private final EntityDeletionOrUpdateAdapter<Group> __updateAdapterOfGroup;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public GroupsDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfGroup = new EntityInsertionAdapter<Group>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `groups` (`id`,`name`,`group_address`,`group_address_label`,`parent_address`,`parent_address_label`,`mesh_uuid`) VALUES (nullif(?, 0),?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Group value) {
                stmt.bindLong(1, (long)value.id);
                if (value.getName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getName());
                }
                stmt.bindLong(3, (long)value.getAddress());
                String _tmp = GroupsDao_Impl.this.__meshTypeConverters.uuidToJson(value.getAddressLabel());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                stmt.bindLong(5, (long)value.getParentAddress());
                String _tmp_1 = GroupsDao_Impl.this.__meshTypeConverters.uuidToJson(value.getParentAddressLabel());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_1);
                }
                if (value.getMeshUuid() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getMeshUuid());
                }
            }
        };
        this.__updateAdapterOfGroup = new EntityDeletionOrUpdateAdapter<Group>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `groups` SET `id` = ?,`name` = ?,`group_address` = ?,`group_address_label` = ?,`parent_address` = ?,`parent_address_label` = ?,`mesh_uuid` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Group value) {
                stmt.bindLong(1, (long)value.id);
                if (value.getName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getName());
                }
                stmt.bindLong(3, (long)value.getAddress());
                String _tmp = GroupsDao_Impl.this.__meshTypeConverters.uuidToJson(value.getAddressLabel());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                stmt.bindLong(5, (long)value.getParentAddress());
                String _tmp_1 = GroupsDao_Impl.this.__meshTypeConverters.uuidToJson(value.getParentAddressLabel());
                if (_tmp_1 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_1);
                }
                if (value.getMeshUuid() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getMeshUuid());
                }
                stmt.bindLong(8, (long)value.id);
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM groups";
                return "DELETE FROM groups";
            }
        };
    }

    @Override
    public void insert(List<Group> groups) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfGroup.insert(groups);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(List<Group> groups) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfGroup.handleMultiple(groups);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Group> loadGroups(String uuid) {
        String _sql = "SELECT * from groups WHERE mesh_uuid == ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from groups WHERE mesh_uuid == ?", (int)1);
        int _argIndex = 1;
        if (uuid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, uuid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"group_address");
            int _cursorIndexOfAddressLabel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"group_address_label");
            int _cursorIndexOfParentAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parent_address");
            int _cursorIndexOfParentAddressLabel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"parent_address_label");
            int _cursorIndexOfMeshUuid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mesh_uuid");
            ArrayList<Group> _result = new ArrayList<Group>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                int _tmpAddress = _cursor.getInt(_cursorIndexOfAddress);
                String _tmp = _cursor.isNull(_cursorIndexOfAddressLabel) ? null : _cursor.getString(_cursorIndexOfAddressLabel);
                UUID _tmpAddressLabel = this.__meshTypeConverters.fromJsonToUuid(_tmp);
                int _tmpParentAddress = _cursor.getInt(_cursorIndexOfParentAddress);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfParentAddressLabel) ? null : _cursor.getString(_cursorIndexOfParentAddressLabel);
                UUID _tmpParentAddressLabel = this.__meshTypeConverters.fromJsonToUuid(_tmp_1);
                String _tmpMeshUuid = _cursor.isNull(_cursorIndexOfMeshUuid) ? null : _cursor.getString(_cursorIndexOfMeshUuid);
                Group _item = new Group(_tmpId, _tmpAddress, _tmpAddressLabel, _tmpParentAddress, _tmpParentAddressLabel, _tmpMeshUuid);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                _item.setName(_tmpName);
                _result.add(_item);
            }
            ArrayList<Group> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

