/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.sensorutils;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.sensorutils.DevicePropertyCharacteristic;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class Count
extends DevicePropertyCharacteristic<Integer> {
    private static final String TAG = Count.class.getSimpleName();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Count(@NonNull byte[] data, int offset, int length) {
        super(data, offset, length);
        switch (length) {
            case 2: {
                this.value = MeshParserUtils.unsignedBytesToInt(data[offset], data[offset + 1]);
                if (!this.isNotValid(65534, 65535)) break;
                this.value = null;
                break;
            }
            case 3: {
                this.value = MeshParserUtils.convert24BitsToInt(data, offset);
                if (!this.isNotValid(0xFFFFFE, 0xFFFFFF)) break;
                this.value = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid length");
            }
        }
    }

    public Count(int count) {
        this.value = count;
    }

    @NonNull
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int getLength() {
        return Integer.bitCount((Integer)this.value) / 8;
    }

    @Override
    public byte[] getBytes() {
        if (this.getLength() == 2) {
            return ByteBuffer.allocate(this.getLength()).order(ByteOrder.LITTLE_ENDIAN).putShort(((Integer)this.value).shortValue()).array();
        }
        return MeshParserUtils.convertIntTo24Bits((Integer)this.value);
    }

    private boolean isNotValid(int max, int unknownValue) {
        return (Integer)this.value == unknownValue || (Integer)this.value < 0 || (Integer)this.value > max;
    }
}

