/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.sensorutils;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.sensorutils.DevicePropertyCharacteristic;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class PerceivedLightness
extends DevicePropertyCharacteristic<Integer> {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public PerceivedLightness(@NonNull byte[] data, int offset) {
        super(data, offset);
        int perceivedLightness = MeshParserUtils.unsignedBytesToInt(data[offset], data[offset + 1]);
        if (perceivedLightness < 0 && perceivedLightness > 65535) {
            throw new IllegalArgumentException("Value " + perceivedLightness + " is Prohibited!");
        }
        this.value = perceivedLightness;
    }

    public PerceivedLightness(int perceivedLightness) {
        this.value = perceivedLightness;
    }

    @NonNull
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public byte[] getBytes() {
        return ByteBuffer.allocate(this.getLength()).order(ByteOrder.LITTLE_ENDIAN).putShort(((Integer)this.value).shortValue()).array();
    }
}

