/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.sensorutils;

public enum SensorSettingAccess {
    READ_ONLY(1),
    READ_WRITE(3);

    private static final String TAG;
    private final int sensorSetting;

    private SensorSettingAccess(int sensorSetting) {
        this.sensorSetting = sensorSetting;
    }

    public static String getDescription(SensorSettingAccess type) {
        switch (type) {
            case READ_ONLY: {
                return "The device property can be read.";
            }
            case READ_WRITE: {
                return "The device property can be read and written.";
            }
        }
        throw new IllegalArgumentException("Prohibited");
    }

    public static SensorSettingAccess from(int sensorSetting) {
        switch (sensorSetting) {
            case 1: {
                return READ_ONLY;
            }
            case 3: {
                return READ_WRITE;
            }
        }
        return null;
    }

    public int getSensorSetting() {
        return this.sensorSetting;
    }

    static {
        TAG = SensorSettingAccess.class.getSimpleName();
    }
}

