/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.sensorutils;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import no.nordicsemi.android.mesh.sensorutils.DevicePropertyCharacteristic;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class TimeSecond
extends DevicePropertyCharacteristic<Integer> {
    private final int length;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public TimeSecond(@NonNull byte[] data, int offset, int length) {
        super(data, offset, length);
        this.length = length;
        switch (length) {
            case 1: {
                this.value = data[offset] & 0xFF;
                if (!this.isNotValid(254L, 255)) break;
                this.value = null;
                break;
            }
            case 2: {
                this.value = MeshParserUtils.unsignedBytesToInt(data[offset], data[offset + 1]);
                if (!this.isNotValid(65534L, 65535)) break;
                this.value = null;
                break;
            }
            case 4: {
                this.value = MeshParserUtils.bytesToInt(Arrays.copyOfRange(data, offset, offset + length), ByteOrder.LITTLE_ENDIAN);
                if (!this.isNotValid(0xFFFFFFFEL, -1)) break;
                this.value = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid length");
            }
        }
    }

    public TimeSecond(int timeSecond) {
        this.value = timeSecond;
        this.length = Integer.bitCount(timeSecond) / 8;
    }

    @NonNull
    public String toString() {
        return this.value == null ? null : this.value + " seconds";
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public byte[] getBytes() {
        switch (this.length) {
            case 1: {
                return new byte[]{((Integer)this.value).byteValue()};
            }
            case 2: {
                return ByteBuffer.allocate(this.getLength()).order(ByteOrder.LITTLE_ENDIAN).putShort(((Integer)this.value).shortValue()).array();
            }
            case 4: {
                return ByteBuffer.allocate(this.getLength()).order(ByteOrder.LITTLE_ENDIAN).putInt((Integer)this.value).array();
            }
        }
        throw new IllegalArgumentException("Invalid length");
    }

    private boolean isNotValid(long max, int unknownValue) {
        return (Integer)this.value == unknownValue || (Integer)this.value < 0 || (long)((Integer)this.value).intValue() > max;
    }
}

