/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.util.Log;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.transport.ConfigMessage;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class ConfigAppKeyUpdate
extends ConfigMessage {
    private static final String TAG = ConfigAppKeyUpdate.class.getSimpleName();
    private static final int OP_CODE = 1;
    private final ApplicationKey mAppKey;

    public ConfigAppKeyUpdate(@NonNull ApplicationKey appKey) throws IllegalArgumentException {
        if (appKey.getKey().length != 16) {
            throw new IllegalArgumentException("App key must be 16 bytes");
        }
        this.mAppKey = appKey;
        this.assembleMessageParameters();
    }

    public ApplicationKey getAppKey() {
        return this.mAppKey;
    }

    @Override
    public int getOpCode() {
        return 1;
    }

    @Override
    void assembleMessageParameters() {
        Log.v((String)TAG, (String)("NetKeyIndex: " + this.mAppKey.getBoundNetKeyIndex()));
        Log.v((String)TAG, (String)("AppKeyIndex: " + this.mAppKey.getKeyIndex()));
        byte[] netKeyIndex = MeshParserUtils.addKeyIndexPadding(this.mAppKey.getBoundNetKeyIndex());
        byte[] appKeyIndex = MeshParserUtils.addKeyIndexPadding(this.mAppKey.getKeyIndex());
        ByteBuffer paramsBuffer = ByteBuffer.allocate(19).order(ByteOrder.LITTLE_ENDIAN);
        paramsBuffer.put(netKeyIndex[1]);
        paramsBuffer.put((byte)((appKeyIndex[1] & 0xFF) << 4 | netKeyIndex[0] & 0xFF & 0xF));
        paramsBuffer.put((byte)((appKeyIndex[0] & 0xFF) << 4 | (appKeyIndex[1] & 0xFF) >> 4));
        paramsBuffer.put(this.mAppKey.getKey());
        this.mParameters = paramsBuffer.array();
    }
}

