/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.Features;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ConfigStatusMessage;
import no.nordicsemi.android.mesh.utils.DeviceFeatureUtils;
import no.nordicsemi.android.mesh.utils.HeartbeatPublication;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class ConfigHeartbeatPublicationStatus
extends ConfigStatusMessage
implements Parcelable {
    private static final String TAG = ConfigHeartbeatPublicationStatus.class.getSimpleName();
    private static final int OP_CODE = 6;
    private HeartbeatPublication heartbeatPublication;
    public static final Parcelable.Creator<ConfigHeartbeatPublicationStatus> CREATOR = new Parcelable.Creator<ConfigHeartbeatPublicationStatus>(){

        public ConfigHeartbeatPublicationStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new ConfigHeartbeatPublicationStatus(message);
        }

        public ConfigHeartbeatPublicationStatus[] newArray(int size) {
            return new ConfigHeartbeatPublicationStatus[size];
        }
    };

    public ConfigHeartbeatPublicationStatus(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    public int getOpCode() {
        return 6;
    }

    @Override
    void parseStatusParameters() {
        this.mStatusCode = this.mParameters[0];
        this.mStatusCodeName = this.getStatusCodeName(this.mStatusCode);
        int dst = MeshParserUtils.unsignedBytesToInt(this.mParameters[1], this.mParameters[2]);
        int countLog = MeshParserUtils.unsignedByteToInt(this.mParameters[3]);
        int periodLog = MeshParserUtils.unsignedByteToInt(this.mParameters[4]);
        int ttl = MeshParserUtils.unsignedByteToInt(this.mParameters[5]);
        int featuresInt = MeshParserUtils.unsignedBytesToInt(this.mParameters[6], this.mParameters[7]);
        Features features = new Features(DeviceFeatureUtils.getFriendFeature(featuresInt), DeviceFeatureUtils.getLowPowerFeature(featuresInt), DeviceFeatureUtils.getProxyFeature(featuresInt), DeviceFeatureUtils.getRelayFeature(featuresInt));
        int netKeyIndex = MeshParserUtils.unsignedBytesToInt(this.mParameters[8], this.mParameters[9]);
        this.heartbeatPublication = new HeartbeatPublication(dst, (byte)countLog, (byte)periodLog, ttl, features, netKeyIndex);
        Log.v((String)TAG, (String)("Status code: " + this.mStatusCode));
        Log.v((String)TAG, (String)("Status message: " + this.mStatusCodeName));
        Log.d((String)TAG, (String)("Heartbeat publication: " + this.heartbeatPublication.toString()));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }

    public final boolean isSuccessful() {
        return this.mStatusCode == 0;
    }

    public HeartbeatPublication getHeartbeatPublication() {
        return this.heartbeatPublication;
    }
}

