/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ConfigStatusMessage;
import no.nordicsemi.android.mesh.utils.HeartbeatSubscription;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class ConfigHeartbeatSubscriptionStatus
extends ConfigStatusMessage
implements Parcelable {
    private static final String TAG = ConfigHeartbeatSubscriptionStatus.class.getSimpleName();
    private static final int OP_CODE = 32828;
    private HeartbeatSubscription heartbeatSubscription;
    public static final Parcelable.Creator<ConfigHeartbeatSubscriptionStatus> CREATOR = new Parcelable.Creator<ConfigHeartbeatSubscriptionStatus>(){

        public ConfigHeartbeatSubscriptionStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new ConfigHeartbeatSubscriptionStatus(message);
        }

        public ConfigHeartbeatSubscriptionStatus[] newArray(int size) {
            return new ConfigHeartbeatSubscriptionStatus[size];
        }
    };

    public ConfigHeartbeatSubscriptionStatus(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    public int getOpCode() {
        return 32828;
    }

    @Override
    void parseStatusParameters() {
        this.mStatusCode = this.mParameters[0];
        this.mStatusCodeName = this.getStatusCodeName(this.mStatusCode);
        int srcAddress = MeshParserUtils.unsignedBytesToInt(this.mParameters[1], this.mParameters[2]);
        int dstAddress = MeshParserUtils.unsignedBytesToInt(this.mParameters[3], this.mParameters[4]);
        int periodLog = MeshParserUtils.unsignedByteToInt(this.mParameters[5]);
        int countLog = MeshParserUtils.unsignedByteToInt(this.mParameters[6]);
        int minHops = MeshParserUtils.unsignedByteToInt(this.mParameters[7]);
        int maxHops = MeshParserUtils.unsignedByteToInt(this.mParameters[8]);
        this.heartbeatSubscription = new HeartbeatSubscription(srcAddress, dstAddress, (byte)periodLog, (byte)countLog, minHops, maxHops);
        Log.v((String)TAG, (String)("Status code: " + this.mStatusCode));
        Log.v((String)TAG, (String)("Status message: " + this.mStatusCodeName));
        Log.d((String)TAG, (String)("Heartbeat subscription: " + this.heartbeatSubscription.toString()));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }

    public HeartbeatSubscription getHeartbeatSubscription() {
        return this.heartbeatSubscription;
    }

    public final boolean isSuccessful() {
        return this.mStatusCode == 0;
    }
}

