/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ConfigStatusMessage;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class ConfigLowPowerNodePollTimeoutStatus
extends ConfigStatusMessage {
    private static final String TAG = ConfigLowPowerNodePollTimeoutStatus.class.getSimpleName();
    private static final int OP_CODE = 32814;
    private int address;
    private int pollTimeout;

    public ConfigLowPowerNodePollTimeoutStatus(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        this.address = MeshParserUtils.unsignedBytesToInt(this.mParameters[0], this.mParameters[1]);
        this.pollTimeout = MeshParserUtils.convert24BitsToInt(new byte[]{this.mParameters[2], this.mParameters[3], this.mParameters[4]});
    }

    @Override
    public int getOpCode() {
        return 32814;
    }

    public int getAddress() {
        return this.address;
    }

    public int getPollTimeout() {
        return this.pollTimeout;
    }
}

