/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.transport.ConfigMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;

public final class ConfigModelSubscriptionDelete
extends ConfigMessage {
    private static final String TAG = ConfigModelSubscriptionDelete.class.getSimpleName();
    private static final int OP_CODE = 32796;
    private static final int SIG_MODEL_APP_KEY_BIND_PARAMS_LENGTH = 6;
    private static final int VENDOR_MODEL_APP_KEY_BIND_PARAMS_LENGTH = 8;
    private final int mElementAddress;
    private final int mSubscriptionAddress;
    private final int mModelIdentifier;

    public ConfigModelSubscriptionDelete(int elementAddress, int subscriptionAddress, int modelIdentifier) throws IllegalArgumentException {
        if (!MeshAddress.isValidUnicastAddress(elementAddress)) {
            throw new IllegalArgumentException("Invalid unicast address, unicast address must be a 16-bit value, and must range from 0x0001 to 0x7FFF");
        }
        this.mElementAddress = elementAddress;
        if (MeshAddress.isValidUnassignedAddress(subscriptionAddress) || MeshAddress.isValidUnicastAddress(subscriptionAddress) || MeshAddress.isValidVirtualAddress(subscriptionAddress) || subscriptionAddress == 65535) {
            throw new IllegalArgumentException("The value of the Address field shall not be an unassigned address, unicast address, all-nodes address or virtual address.");
        }
        this.mSubscriptionAddress = subscriptionAddress;
        this.mModelIdentifier = modelIdentifier;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 32796;
    }

    @Override
    void assembleMessageParameters() {
        byte[] elementaddress = MeshAddress.addressIntToBytes(this.mElementAddress);
        byte[] subscriptionAddress = MeshAddress.addressIntToBytes(this.mSubscriptionAddress);
        if (this.mModelIdentifier >= Short.MIN_VALUE && this.mModelIdentifier <= Short.MAX_VALUE) {
            ByteBuffer paramsBuffer = ByteBuffer.allocate(6).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.put(elementaddress[1]);
            paramsBuffer.put(elementaddress[0]);
            paramsBuffer.put(subscriptionAddress[1]);
            paramsBuffer.put(subscriptionAddress[0]);
            paramsBuffer.putShort((short)this.mModelIdentifier);
            this.mParameters = paramsBuffer.array();
        } else {
            ByteBuffer paramsBuffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.put(elementaddress[1]);
            paramsBuffer.put(elementaddress[0]);
            paramsBuffer.put(subscriptionAddress[1]);
            paramsBuffer.put(subscriptionAddress[0]);
            byte[] modelIdentifier = new byte[]{(byte)(this.mModelIdentifier >> 24 & 0xFF), (byte)(this.mModelIdentifier >> 16 & 0xFF), (byte)(this.mModelIdentifier >> 8 & 0xFF), (byte)(this.mModelIdentifier & 0xFF)};
            paramsBuffer.put(modelIdentifier[1]);
            paramsBuffer.put(modelIdentifier[0]);
            paramsBuffer.put(modelIdentifier[3]);
            paramsBuffer.put(modelIdentifier[2]);
            this.mParameters = paramsBuffer.array();
        }
    }
}

